/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.MemorySegmentRequest;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectLongsSketch;
import org.apache.datasketches.kll.KllHeapLongsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllLongsHelper;
import org.apache.datasketches.kll.KllLongsSketchIterator;
import org.apache.datasketches.kll.KllMemorySegmentValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.quantilescommon.LongsSketchSortedView;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesLongsAPI;
import org.apache.datasketches.quantilescommon.QuantilesLongsSketchIterator;

public abstract class KllLongsSketch
extends KllSketch
implements QuantilesLongsAPI {
    private LongsSketchSortedView longsSV = null;
    static final int ITEM_BYTES = 8;

    KllLongsSketch(KllSketch.SketchStructure sketchStructure) {
        super(KllSketch.SketchType.KLL_LONGS_SKETCH, sketchStructure);
    }

    KllLongsSketch(KllMemorySegmentValidate segVal) {
        super(segVal);
    }

    public static KllLongsSketch newHeapInstance() {
        return KllLongsSketch.newHeapInstance(200);
    }

    public static KllLongsSketch newHeapInstance(int k) {
        return new KllHeapLongsSketch(k, 8);
    }

    public static KllLongsSketch newDirectInstance(MemorySegment dstSeg) {
        return KllLongsSketch.newDirectInstance(200, dstSeg, null);
    }

    public static KllLongsSketch newDirectInstance(int k, MemorySegment dstSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(dstSeg, "Parameter 'dstSeg' must not be null");
        return KllDirectLongsSketch.newDirectUpdatableInstance(k, 8, dstSeg, mSegReq);
    }

    public static KllLongsSketch heapify(MemorySegment srcSeg) {
        Objects.requireNonNull(srcSeg, "Parameter 'srcSeg' must not be null");
        return KllHeapLongsSketch.heapifyImpl(srcSeg);
    }

    public static KllLongsSketch wrap(MemorySegment srcSeg) {
        return KllLongsSketch.wrap(srcSeg, null);
    }

    public static KllLongsSketch wrap(MemorySegment srcSeg, MemorySegmentRequest mSegReq) {
        Objects.requireNonNull(srcSeg, "Parameter 'srcSeg' must not be null");
        KllMemorySegmentValidate segVal = new KllMemorySegmentValidate(srcSeg, KllSketch.SketchType.KLL_LONGS_SKETCH);
        return new KllDirectLongsSketch(srcSeg, segVal, mSegReq);
    }

    @Override
    public double[] getCDF(long[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.longsSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public double[] getPMF(long[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.longsSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public long getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.longsSV.getQuantile(rank, searchCrit);
    }

    @Override
    public long[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        long[] quantiles = new long[len];
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.longsSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public long getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public long getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(long quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.longsSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(long[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.longsSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public QuantilesLongsSketchIterator iterator() {
        return new KllLongsSketchIterator(this.getLongItemsArray(), this.getLevelsArray(KllSketch.SketchStructure.UPDATABLE), this.getNumLevels());
    }

    @Override
    public final void merge(KllSketch other) {
        if (this.readOnly || this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (this == other) {
            throw new SketchesArgumentException("A sketch cannot merge with itself. ");
        }
        KllLongsSketch otherLngSk = (KllLongsSketch)other;
        if (otherLngSk.isEmpty()) {
            return;
        }
        KllLongsHelper.mergeLongsImpl(this, otherLngSk);
        this.longsSV = null;
    }

    @Override
    public final void reset() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        this.setMinItem(Long.MAX_VALUE);
        this.setMaxItem(Long.MIN_VALUE);
        this.setLongItemsArray(new long[k]);
        this.longsSV = null;
    }

    @Override
    public byte[] toByteArray() {
        return KllHelper.toByteArray(this, false);
    }

    @Override
    public String toString(boolean withLevels, boolean withLevelsAndItems) {
        KllLongsSketch sketch = this;
        if (withLevelsAndItems && this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            MemorySegment seg = this.getMemorySegment();
            assert (seg != null);
            sketch = KllLongsSketch.heapify(this.getMemorySegment());
        }
        return KllHelper.toStringImpl(sketch, withLevels, withLevelsAndItems);
    }

    @Override
    public void update(long item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllLongsSketch.updateLong(this, item);
        this.longsSV = null;
    }

    static void updateLong(KllLongsSketch lngSk, long item) {
        lngSk.updateMinMax(item);
        int freeSpace = lngSk.levelsArr[0];
        assert (freeSpace >= 0);
        if (freeSpace == 0) {
            KllLongsHelper.compressWhileUpdatingSketch(lngSk);
            freeSpace = lngSk.levelsArr[0];
            assert (freeSpace > 0);
        }
        lngSk.incN(1);
        lngSk.setLevelZeroSorted(false);
        int nextPos = freeSpace - 1;
        lngSk.setLevelsArrayAt(0, nextPos);
        lngSk.setLongItemsArrayAt(nextPos, item);
    }

    final void updateMinMax(long item) {
        if (this.isEmpty()) {
            this.setMinItem(item);
            this.setMaxItem(item);
        } else {
            this.setMinItem(Math.min(this.getMinItemInternal(), item));
            this.setMaxItem(Math.max(this.getMaxItemInternal(), item));
        }
    }

    public void update(long item, long weight) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (weight < 1L) {
            throw new SketchesArgumentException("Weight is less than one.");
        }
        if (weight == 1L) {
            KllLongsSketch.updateLong(this, item);
        } else if (weight < (long)this.levelsArr[0]) {
            for (int i = 0; i < (int)weight; ++i) {
                KllLongsSketch.updateLong(this, item);
            }
        } else {
            KllHeapLongsSketch tmpSk = new KllHeapLongsSketch(this.getK(), 8, item, weight);
            this.merge(tmpSk);
        }
        this.longsSV = null;
    }

    public void update(long[] items, int offset, int length) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        if (length == 0) {
            return;
        }
        this.updateLong(items, offset, length);
        this.longsSV = null;
    }

    private void updateLong(long[] srcItems, int srcOffset, int length) {
        int numItemsToCopy;
        if (this.isEmpty()) {
            this.setMinItem(srcItems[srcOffset]);
            this.setMaxItem(srcItems[srcOffset]);
        }
        for (int count = 0; count < length; count += numItemsToCopy) {
            if (this.levelsArr[0] == 0) {
                KllLongsHelper.compressWhileUpdatingSketch(this);
            }
            int spaceNeeded = length - count;
            int freeSpace = this.levelsArr[0];
            assert (freeSpace > 0);
            numItemsToCopy = Math.min(spaceNeeded, freeSpace);
            int dstOffset = freeSpace - numItemsToCopy;
            int localSrcOffset = srcOffset + count;
            this.setLongItemsArrayAt(dstOffset, srcItems, localSrcOffset, numItemsToCopy);
            this.updateMinMax(srcItems, localSrcOffset, numItemsToCopy);
            this.incN(numItemsToCopy);
            this.setLevelsArrayAt(0, dstOffset);
        }
        this.setLevelZeroSorted(false);
    }

    private void updateMinMax(long[] srcItems, int srcOffset, int length) {
        int end = srcOffset + length;
        for (int i = srcOffset; i < end; ++i) {
            this.setMinItem(Math.min(this.getMinItemInternal(), srcItems[i]));
            this.setMaxItem(Math.max(this.getMaxItemInternal(), srcItems[i]));
        }
    }

    abstract long[] getLongItemsArray();

    abstract long[] getLongRetainedItemsArray();

    abstract long getLongSingleItem();

    abstract long getMaxItemInternal();

    abstract void setMaxItem(long var1);

    abstract long getMinItemInternal();

    abstract void setMinItem(long var1);

    @Override
    abstract byte[] getMinMaxByteArr();

    @Override
    int getMinMaxSizeBytes() {
        return 16;
    }

    @Override
    abstract byte[] getRetainedItemsByteArr();

    @Override
    int getRetainedItemsSizeBytes() {
        return this.getNumRetained() * 8;
    }

    @Override
    ArrayOfItemsSerDe<?> getSerDe() {
        return null;
    }

    @Override
    final byte[] getSingleItemByteArr() {
        byte[] bytes = new byte[8];
        ByteArrayUtil.putLongLE(bytes, 0, this.getLongSingleItem());
        return bytes;
    }

    @Override
    int getSingleItemSizeBytes() {
        return 8;
    }

    @Override
    abstract byte[] getTotalItemsByteArr();

    @Override
    int getTotalItemsNumBytes() {
        return this.levelsArr[this.getNumLevels()] * 8;
    }

    abstract void setLongItemsArray(long[] var1);

    abstract void setLongItemsArrayAt(int var1, long var2);

    abstract void setLongItemsArrayAt(int var1, long[] var2, int var3, int var4);

    @Override
    public LongsSketchSortedView getSortedView() {
        this.refreshSortedView();
        return this.longsSV;
    }

    private final LongsSketchSortedView refreshSortedView() {
        if (this.longsSV == null) {
            CreateSortedView csv = new CreateSortedView(this);
            this.longsSV = csv.getSV();
        }
        return this.longsSV;
    }

    private static void blockyTandemMergeSort(long[] quantiles, long[] weights, int[] levels, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        long[] quantilesTmp = Arrays.copyOf(quantiles, quantiles.length);
        long[] weightsTmp = Arrays.copyOf(weights, quantiles.length);
        KllLongsSketch.blockyTandemMergeSortRecursion(quantilesTmp, weightsTmp, quantiles, weights, levels, 0, numLevels);
    }

    private static void blockyTandemMergeSortRecursion(long[] quantilesSrc, long[] weightsSrc, long[] quantilesDst, long[] weightsDst, int[] levels, int startingLevel, int numLevels) {
        if (numLevels == 1) {
            return;
        }
        int numLevels1 = numLevels / 2;
        int numLevels2 = numLevels - numLevels1;
        assert (numLevels1 >= 1);
        assert (numLevels2 >= numLevels1);
        int startingLevel1 = startingLevel;
        int startingLevel2 = startingLevel + numLevels1;
        KllLongsSketch.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel1, numLevels1);
        KllLongsSketch.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel2, numLevels2);
        KllLongsSketch.tandemMerge(quantilesSrc, weightsSrc, quantilesDst, weightsDst, levels, startingLevel1, numLevels1, startingLevel2, numLevels2);
    }

    private static void tandemMerge(long[] quantilesSrc, long[] weightsSrc, long[] quantilesDst, long[] weightsDst, int[] levelStarts, int startingLevel1, int numLevels1, int startingLevel2, int numLevels2) {
        int fromIndex1 = levelStarts[startingLevel1];
        int toIndex1 = levelStarts[startingLevel1 + numLevels1];
        int fromIndex2 = levelStarts[startingLevel2];
        int toIndex2 = levelStarts[startingLevel2 + numLevels2];
        int iSrc1 = fromIndex1;
        int iSrc2 = fromIndex2;
        int iDst = fromIndex1;
        while (iSrc1 < toIndex1 && iSrc2 < toIndex2) {
            if (quantilesSrc[iSrc1] < quantilesSrc[iSrc2]) {
                quantilesDst[iDst] = quantilesSrc[iSrc1];
                weightsDst[iDst] = weightsSrc[iSrc1];
                ++iSrc1;
            } else {
                quantilesDst[iDst] = quantilesSrc[iSrc2];
                weightsDst[iDst] = weightsSrc[iSrc2];
                ++iSrc2;
            }
            ++iDst;
        }
        if (iSrc1 < toIndex1) {
            System.arraycopy(quantilesSrc, iSrc1, quantilesDst, iDst, toIndex1 - iSrc1);
            System.arraycopy(weightsSrc, iSrc1, weightsDst, iDst, toIndex1 - iSrc1);
        } else if (iSrc2 < toIndex2) {
            System.arraycopy(quantilesSrc, iSrc2, quantilesDst, iDst, toIndex2 - iSrc2);
            System.arraycopy(weightsSrc, iSrc2, weightsDst, iDst, toIndex2 - iSrc2);
        }
    }

    private final class CreateSortedView {
        long[] quantiles;
        long[] cumWeights;
        final /* synthetic */ KllLongsSketch this$0;

        private CreateSortedView(KllLongsSketch kllLongsSketch) {
            KllLongsSketch kllLongsSketch2 = kllLongsSketch;
            Objects.requireNonNull(kllLongsSketch2);
            this.this$0 = kllLongsSketch2;
        }

        LongsSketchSortedView getSV() {
            if (this.this$0.isEmpty()) {
                throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
            }
            long[] srcQuantiles = this.this$0.getLongItemsArray();
            int[] srcLevels = this.this$0.levelsArr;
            int srcNumLevels = this.this$0.getNumLevels();
            if (!this.this$0.isLevelZeroSorted()) {
                Arrays.sort(srcQuantiles, srcLevels[0], srcLevels[1]);
                if (!this.this$0.hasMemorySegment()) {
                    this.this$0.setLevelZeroSorted(true);
                }
            }
            int numQuantiles = this.this$0.getNumRetained();
            this.quantiles = new long[numQuantiles];
            this.cumWeights = new long[numQuantiles];
            this.populateFromSketch(srcQuantiles, srcLevels, srcNumLevels, numQuantiles);
            return new LongsSketchSortedView(this.quantiles, this.cumWeights, this.this$0);
        }

        private void populateFromSketch(long[] srcQuantiles, int[] srcLevels, int srcNumLevels, int numItems) {
            int[] myLevels = new int[srcNumLevels + 1];
            int offset = srcLevels[0];
            System.arraycopy(srcQuantiles, offset, this.quantiles, 0, numItems);
            int srcLevel = 0;
            int dstLevel = 0;
            long weight = 1L;
            while (srcLevel < srcNumLevels) {
                int fromIndex = srcLevels[srcLevel] - offset;
                int toIndex = srcLevels[srcLevel + 1] - offset;
                if (fromIndex < toIndex) {
                    Arrays.fill(this.cumWeights, fromIndex, toIndex, weight);
                    myLevels[dstLevel] = fromIndex;
                    myLevels[dstLevel + 1] = toIndex;
                    ++dstLevel;
                }
                ++srcLevel;
                weight *= 2L;
            }
            int numLevels = dstLevel;
            KllLongsSketch.blockyTandemMergeSort(this.quantiles, this.cumWeights, myLevels, numLevels);
            KllHelper.convertToCumulative(this.cumWeights);
        }
    }
}

