/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesException;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.hll.CouponHashSet;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectCouponList;
import org.apache.datasketches.hll.HllSketchImpl;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;

final class DirectCouponHashSet
extends DirectCouponList {
    DirectCouponHashSet(int lgConfigK, TgtHllType tgtHllType, MemorySegment wseg) {
        super(lgConfigK, tgtHllType, CurMode.SET, wseg);
        assert (wseg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.LG_K_BYTE) > 7);
    }

    DirectCouponHashSet(int lgConfigK, TgtHllType tgtHllType, MemorySegment seg, boolean readOnly) {
        super(lgConfigK, tgtHllType, CurMode.SET, seg, readOnly);
        assert (seg.get(ValueLayout.JAVA_BYTE, (long)PreambleUtil.LG_K_BYTE) > 7);
    }

    @Override
    CouponHashSet copy() {
        return CouponHashSet.heapifySet(this.seg);
    }

    @Override
    CouponHashSet copyAs(TgtHllType tgtHllType) {
        CouponHashSet clist = CouponHashSet.heapifySet(this.seg);
        return new CouponHashSet(clist, tgtHllType);
    }

    @Override
    HllSketchImpl couponUpdate(int coupon) {
        int index;
        if (this.wseg == null) {
            HllUtil.noWriteAccess();
        }
        if ((index = DirectCouponHashSet.find(this.seg, this.getLgCouponArrInts(), coupon)) >= 0) {
            return this;
        }
        PreambleUtil.insertInt(this.wseg, PreambleUtil.HASH_SET_INT_ARR_START + (~index << 2), coupon);
        PreambleUtil.insertHashSetCount(this.wseg, this.getCouponCount() + 1);
        boolean promote = this.checkGrowOrPromote();
        if (!promote) {
            return this;
        }
        return DirectCouponHashSet.promoteListOrSetToHll(this);
    }

    @Override
    int getCouponCount() {
        return PreambleUtil.extractHashSetCount(this.seg);
    }

    @Override
    int getSegDataStart() {
        return PreambleUtil.HASH_SET_INT_ARR_START;
    }

    @Override
    int getPreInts() {
        return 3;
    }

    private boolean checkGrowOrPromote() {
        int lgCouponArrInts = this.getLgCouponArrInts();
        if (4 * this.getCouponCount() > 3 * (1 << lgCouponArrInts)) {
            if (lgCouponArrInts == this.getLgConfigK() - 3) {
                return true;
            }
            PreambleUtil.insertLgArr(this.wseg, ++lgCouponArrInts);
            DirectCouponHashSet.growHashSet(this.wseg, lgCouponArrInts);
        }
        return false;
    }

    private static void growHashSet(MemorySegment wseg, int tgtLgCouponArrSize) {
        int tgtArrSize = 1 << tgtLgCouponArrSize;
        int[] tgtCouponIntArr = new int[tgtArrSize];
        int oldLen = 1 << PreambleUtil.extractLgArr(wseg);
        for (int i = 0; i < oldLen; ++i) {
            int fetched = PreambleUtil.extractInt(wseg, PreambleUtil.HASH_SET_INT_ARR_START + (i << 2));
            if (fetched == 0) continue;
            int idx = DirectCouponHashSet.find(tgtCouponIntArr, tgtLgCouponArrSize, fetched);
            if (idx < 0) {
                tgtCouponIntArr[idx ^ 0xFFFFFFFF] = fetched;
                continue;
            }
            throw new SketchesStateException("Error: found duplicate.");
        }
        Util.clear(wseg, PreambleUtil.HASH_SET_INT_ARR_START, tgtArrSize << 2);
        try {
            MemorySegment.copy(tgtCouponIntArr, 0, wseg, ValueLayout.JAVA_INT_UNALIGNED, (long)PreambleUtil.HASH_SET_INT_ARR_START, tgtArrSize);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SketchesException("The MemorySegment is undersized. Use the public methods for properly sizing MemorySegment.", e);
        }
    }

    private static int find(MemorySegment seg, int lgArr, int coupon) {
        int stride;
        int probe;
        int arrMask = (1 << lgArr) - 1;
        int loopIndex = probe = coupon & arrMask;
        do {
            int couponAtIndex;
            if ((couponAtIndex = PreambleUtil.extractInt(seg, PreambleUtil.HASH_SET_INT_ARR_START + (probe << 2))) == 0) {
                return ~probe;
            }
            if (coupon != couponAtIndex) continue;
            return probe;
        } while ((probe = probe + (stride = (coupon & 0x3FFFFFF) >>> lgArr | 1) & arrMask) != loopIndex);
        throw new SketchesArgumentException("Key not found and no empty slots!");
    }
}

