/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.datasketches.common.MemorySegmentRequest;

public final class MemorySegmentRequestExample
implements MemorySegmentRequest {
    private final ConcurrentHashMap<MemorySegment, Arena> map = new ConcurrentHashMap();

    @Override
    public synchronized MemorySegment request(long newByteSize) {
        Arena arena = Arena.ofConfined();
        MemorySegment seg = arena.allocate(newByteSize);
        this.map.put(seg, arena);
        return seg;
    }

    @Override
    public synchronized void requestClose(MemorySegment segKey) {
        Objects.requireNonNull(segKey, "MemorySegment segKey must not be null");
        Arena arena = this.map.get(segKey);
        if (arena != null) {
            if (arena.scope().isAlive()) {
                arena.close();
            }
            this.map.remove(segKey);
        }
    }

    public synchronized void cleanup() {
        Enumeration<Arena> e = this.map.elements();
        while (e.hasMoreElements()) {
            Arena arena = e.nextElement();
            if (!arena.scope().isAlive()) continue;
            arena.close();
        }
        this.map.clear();
    }
}

