/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.lib.calendar.DFDLDate;
import org.apache.daffodil.lib.calendar.DFDLDateConversion$;
import org.apache.daffodil.lib.calendar.DFDLDateTime;
import org.apache.daffodil.lib.calendar.DFDLDateTimeConversion$;
import org.apache.daffodil.lib.calendar.DFDLTime;
import org.apache.daffodil.lib.calendar.DFDLTimeConversion$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.iapi.DaffodilSchemaSource;
import org.apache.daffodil.lib.iapi.URISchemaSource;
import org.apache.daffodil.lib.iapi.URISchemaSource$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.NS$;
import org.apache.daffodil.lib.xml.PrettyPrinter;
import org.apache.daffodil.lib.xml.RemapPUAToXMLIllegalChar;
import org.apache.daffodil.lib.xml.RemapXMLIllegalCharToPUA;
import org.apache.daffodil.lib.xml.XMLUtils;
import org.xml.sax.XMLReader;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;
import scala.xml.Atom;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.Elem$;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NamespaceBinding$;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.PrefixedAttribute$;
import scala.xml.ProcInstr;
import scala.xml.ProcInstr$;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.Unparsed;
import scala.xml.Utility$;

public final class XMLUtils$
implements Serializable {
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(XMLUtils$.class.getDeclaredField("tdmlURI$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(XMLUtils$.class.getDeclaredField("dafextURI$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(XMLUtils$.class.getDeclaredField("schemaForDFDLSchemas$lzy1"));
    private volatile Object schemaForDFDLSchemas$lzy1;
    private volatile Object dafextURI$lzy1;
    private volatile Object tdmlURI$lzy1;
    private static final PrefixedAttribute xmlNilAttribute;
    private static final String PositiveInfinityString;
    private static final String NegativeInfinityString;
    private static final String NaNString;
    private static final RemapXMLIllegalCharToPUA remapXMLToPUA;
    private static final RemapPUAToXMLIllegalChar remapPUAToXML;
    private static final NS XSD_NAMESPACE;
    private static final NS XSI_NAMESPACE;
    private static final NS XPATH_FUNCTION_NAMESPACE;
    private static final NS XPATH_MATH_NAMESPACE;
    private static final NS DFDL_NAMESPACE;
    private static final NS DFDLX_NAMESPACE;
    private static final NS TDML_NAMESPACE;
    private static final NS EXAMPLE_NAMESPACE;
    private static final NS XHTML_NAMESPACE;
    private static final String EXT_PREFIX_NCSA;
    private static final NS EXT_NS_NCSA;
    private static final String EXT_PREFIX_APACHE;
    private static final NS EXT_NS_APACHE;
    private static final NS DAFFODIL_INTERNAL_NAMESPACE;
    private static final String INT_PREFIX;
    private static final NS INT_NS;
    private static final String DAFFODIL_SAX_URN_ROOT;
    private static final String DAFFODIL_SAX_URN_PARSERESULT;
    private static final String DAFFODIL_SAX_URN_BLOBDIRECTORY;
    private static final String DAFFODIL_SAX_URN_BLOBPREFIX;
    private static final String DAFFODIL_SAX_URN_BLOBSUFFIX;
    private static final String SAX_NAMESPACES_FEATURE;
    private static final String SAX_NAMESPACE_PREFIXES_FEATURE;
    private static final String XML_DISALLOW_DOCTYPE_FEATURE;
    private static final String XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE;
    private static final String XML_EXTERNAL_GENERAL_ENTITIES_FEATURE;
    private static final String XML_LOAD_EXTERNAL_DTD_FEATURE;
    private static final String FILE_ATTRIBUTE_NAME;
    private static final String LINE_ATTRIBUTE_NAME;
    private static final String COLUMN_ATTRIBUTE_NAME;
    private static final NS xsdURI;
    private static final NS dfdlURI;
    private static final NS dfdlxURI;
    private static final NS dfdlAppinfoSource;
    private static final NS targetNS;
    private static final NS xsiURI;
    private static final NS fnURI;
    private static final NS mathURI;
    private static final NS dafintURI;
    private static final List DFDL_SIMPLE_BUILT_IN_TYPES;
    private static final RemapXMLIllegalCharToPUA xmlRemapperPreservingCR;
    private static final Regex xmlEntityPattern;
    public static final XMLUtils$ MODULE$;

    private XMLUtils$() {
    }

    static {
        MODULE$ = new XMLUtils$();
        xmlNilAttribute = new PrefixedAttribute("xsi", "nil", "true", (MetaData)Null$.MODULE$);
        PositiveInfinityString = "INF";
        NegativeInfinityString = "-INF";
        NaNString = "NaN";
        remapXMLToPUA = new RemapXMLIllegalCharToPUA(false, true);
        remapPUAToXML = new RemapPUAToXMLIllegalChar();
        XSD_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema");
        XSI_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema-instance");
        XPATH_FUNCTION_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions");
        XPATH_MATH_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions/math");
        DFDL_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/");
        DFDLX_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/extensions");
        TDML_NAMESPACE = NS$.MODULE$.apply("http://www.ibm.com/xmlns/dfdl/testData");
        EXAMPLE_NAMESPACE = NS$.MODULE$.apply("http://example.com");
        XHTML_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/1999/xhtml");
        String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA = "urn:ogf:dfdl:2013:imp:opensource.ncsa.illinois.edu:2012";
        NS DAFFODIL_EXTENSION_NAMESPACE_NCSA = NS$.MODULE$.apply(DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA + ":ext");
        EXT_PREFIX_NCSA = "daf";
        EXT_NS_NCSA = NS$.MODULE$.apply(DAFFODIL_EXTENSION_NAMESPACE_NCSA.uri());
        String DAFFODIL_NAMESPACE_ROOT_APACHE = "urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018";
        NS DAFFODIL_EXTENSION_NAMESPACE_APACHE = NS$.MODULE$.apply(DAFFODIL_NAMESPACE_ROOT_APACHE + ":ext");
        EXT_PREFIX_APACHE = "daf";
        EXT_NS_APACHE = NS$.MODULE$.apply(DAFFODIL_EXTENSION_NAMESPACE_APACHE.uri());
        DAFFODIL_INTERNAL_NAMESPACE = NS$.MODULE$.apply(DAFFODIL_NAMESPACE_ROOT_APACHE + ":int");
        INT_PREFIX = "dafint";
        INT_NS = NS$.MODULE$.apply(DAFFODIL_INTERNAL_NAMESPACE.uri());
        DAFFODIL_SAX_URN_ROOT = DAFFODIL_NAMESPACE_ROOT_APACHE + ":sax";
        DAFFODIL_SAX_URN_PARSERESULT = MODULE$.DAFFODIL_SAX_URN_ROOT() + ":ParseResult";
        DAFFODIL_SAX_URN_BLOBDIRECTORY = MODULE$.DAFFODIL_SAX_URN_ROOT() + ":BlobDirectory";
        DAFFODIL_SAX_URN_BLOBPREFIX = MODULE$.DAFFODIL_SAX_URN_ROOT() + ":BlobPrefix";
        DAFFODIL_SAX_URN_BLOBSUFFIX = MODULE$.DAFFODIL_SAX_URN_ROOT() + ":BlobSuffix";
        SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
        SAX_NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
        XML_DISALLOW_DOCTYPE_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
        XML_EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
        XML_LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        FILE_ATTRIBUTE_NAME = "file";
        LINE_ATTRIBUTE_NAME = "line";
        COLUMN_ATTRIBUTE_NAME = "col";
        xsdURI = MODULE$.XSD_NAMESPACE();
        dfdlURI = MODULE$.DFDL_NAMESPACE();
        dfdlxURI = MODULE$.DFDLX_NAMESPACE();
        dfdlAppinfoSource = NS$.MODULE$.apply("http://www.ogf.org/dfdl/");
        targetNS = MODULE$.EXAMPLE_NAMESPACE();
        xsiURI = MODULE$.XSI_NAMESPACE();
        fnURI = MODULE$.XPATH_FUNCTION_NAMESPACE();
        mathURI = MODULE$.XPATH_MATH_NAMESPACE();
        dafintURI = DAFFODIL_INTERNAL_NAMESPACE;
        DFDL_SIMPLE_BUILT_IN_TYPES = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"string", "float", "double", "decimal", "integer", "long", "int", "short", "byte", "unsignedLong", "unsignedInt", "nonNegativeInteger", "unsignedShort", "unsignedByte", "boolean", "date", "time", "dateTime", "hexBinary"}));
        xmlRemapperPreservingCR = new RemapXMLIllegalCharToPUA(false, false);
        xmlEntityPattern = new Regex("&(quot|amp|apos|lt|gt);", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"entity"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(XMLUtils$.class);
    }

    public URI schemaForDFDLSchemas() {
        Object object = this.schemaForDFDLSchemas$lzy1;
        if (object instanceof URI) {
            return (URI)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (URI)this.schemaForDFDLSchemas$lzyINIT1();
    }

    private Object schemaForDFDLSchemas$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.schemaForDFDLSchemas$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    URI uRI = null;
                    try {
                        uRI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/XMLSchema_for_DFDL.xsd");
                        object2 = uRI == null ? LazyVals.NullValue$.MODULE$ : uRI;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.schemaForDFDLSchemas$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uRI;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public URI dafextURI() {
        Object object = this.dafextURI$lzy1;
        if (object instanceof URI) {
            return (URI)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (URI)this.dafextURI$lzyINIT1();
    }

    private Object dafextURI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.dafextURI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    URI uRI = null;
                    try {
                        uRI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/dafext.xsd");
                        object2 = uRI == null ? LazyVals.NullValue$.MODULE$ : uRI;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.dafextURI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uRI;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public URI tdmlURI() {
        Object object = this.tdmlURI$lzy1;
        if (object instanceof URI) {
            return (URI)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (URI)this.tdmlURI$lzyINIT1();
    }

    private Object tdmlURI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.tdmlURI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    URI uRI = null;
                    try {
                        uRI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/tdml.xsd");
                        object2 = uRI == null ? LazyVals.NullValue$.MODULE$ : uRI;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.tdmlURI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return uRI;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public PrefixedAttribute xmlNilAttribute() {
        return xmlNilAttribute;
    }

    public String PositiveInfinityString() {
        return PositiveInfinityString;
    }

    public String NegativeInfinityString() {
        return NegativeInfinityString;
    }

    public String NaNString() {
        return NaNString;
    }

    public float strToFloat(String s) {
        String string = s;
        String string2 = this.PositiveInfinityString();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Float.POSITIVE_INFINITY;
        }
        String string4 = this.NegativeInfinityString();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return Float.NEGATIVE_INFINITY;
        }
        String string6 = this.NaNString();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return Float.NaN;
        }
        return StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s));
    }

    public double strToDouble(String s) {
        String string = s;
        String string2 = this.PositiveInfinityString();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Double.POSITIVE_INFINITY;
        }
        String string4 = this.NegativeInfinityString();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return Double.NEGATIVE_INFINITY;
        }
        String string6 = this.NaNString();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return Double.NaN;
        }
        return StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s));
    }

    public int uncodeLength(String s) {
        int res = s.getBytes("UTF-32BE").length / 4;
        return res;
    }

    public <T> scala.collection.immutable.Seq<T> walkUnicodeString(String str, Function3<Object, Object, Object, T> bodyFunc) {
        int len = str.length();
        if (len == 0) {
            return scala.package$.MODULE$.Nil();
        }
        ListBuffer list = new ListBuffer();
        char prev = (char)0;
        char curr = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), 0);
        char next = (char)0;
        for (int pos = 0; pos < len; ++pos) {
            next = pos + 1 < len ? StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), pos + 1) : (char)0;
            list.$plus$eq(bodyFunc.apply((Object)BoxesRunTime.boxToCharacter((char)prev), (Object)BoxesRunTime.boxToCharacter((char)curr), (Object)BoxesRunTime.boxToCharacter((char)next)));
            prev = curr;
            curr = next;
        }
        return list.toSeq();
    }

    public String remapXMLIllegalCharactersToPUA(String s) {
        return remapXMLToPUA.remap(s);
    }

    public String remapPUAToXMLIllegalCharacters(String text) {
        return remapPUAToXML.remap(text);
    }

    public Node coalesceAllAdjacentTextNodes(Node node) {
        Option option;
        Node node2 = node;
        if (node2 != null && !(option = Elem$.MODULE$.unapplySeq(node2)).isEmpty()) {
            Tuple5 tuple5 = (Tuple5)option.get();
            String prefix = (String)tuple5._1();
            String label = (String)tuple5._2();
            MetaData attribs = (MetaData)tuple5._3();
            NamespaceBinding scope = (NamespaceBinding)tuple5._4();
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)tuple5._5();
            if (seq.lengthCompare(0) >= 0) {
                scala.collection.immutable.Seq seq2;
                scala.collection.immutable.Seq child = seq2 = seq.toSeq();
                scala.collection.immutable.Seq coalescedChildren = (scala.collection.immutable.Seq)child.map((Function1 & Serializable)_$26 -> MODULE$.coalesceAllAdjacentTextNodes((Node)_$26));
                scala.collection.immutable.Seq<Node> newChildren = this.coalesceAdjacentTextNodes((scala.collection.immutable.Seq<Node>)coalescedChildren);
                return Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
            }
        }
        Node x = node2;
        return x;
    }

    public scala.collection.immutable.Seq<Node> coalesceAdjacentTextNodes(scala.collection.immutable.Seq<Node> seq) {
        Node node;
        if (seq.length() == 0) {
            return seq;
        }
        if (seq.length() == 1 && (node = (Node)seq.apply(0)) instanceof Atom) {
            Atom a = (Atom)node;
            return seq;
        }
        ArrayBuilder ab = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Node.class));
        boolean i = false;
        ObjectRef tn = ObjectRef.create(null);
        ObjectRef sb = ObjectRef.create(null);
        seq.foreach((Function1 & Serializable)current -> {
            if (current instanceof Text || current instanceof Unparsed) {
                if ((Node)tn$2.elem == null) {
                    if ((StringBuilder)sb$2.elem == null || ((StringBuilder)sb$2.elem).length() == 0) {
                        tn$2.elem = current;
                        return BoxedUnit.UNIT;
                    }
                    return ((StringBuilder)sb$2.elem).append(current.text());
                }
                if ((StringBuilder)sb$2.elem == null) {
                    sb$2.elem = new StringBuilder();
                }
                ((StringBuilder)sb$2.elem).append(((Node)tn$2.elem).text());
                ((StringBuilder)sb$2.elem).append(current.text());
                tn$2.elem = null;
                return BoxedUnit.UNIT;
            }
            this.processText$1(tn, sb, ab);
            return ab.$plus$eq(current);
        });
        this.processText$1(tn, sb, ab);
        Object object = Predef$.MODULE$.refArrayOps((Object[])ab.result());
        return ArrayOps$.MODULE$.toSeq$extension(object);
    }

    public NS XSD_NAMESPACE() {
        return XSD_NAMESPACE;
    }

    public NS XSI_NAMESPACE() {
        return XSI_NAMESPACE;
    }

    public NS XPATH_FUNCTION_NAMESPACE() {
        return XPATH_FUNCTION_NAMESPACE;
    }

    public NS XPATH_MATH_NAMESPACE() {
        return XPATH_MATH_NAMESPACE;
    }

    public NS DFDL_NAMESPACE() {
        return DFDL_NAMESPACE;
    }

    public NS DFDLX_NAMESPACE() {
        return DFDLX_NAMESPACE;
    }

    public NS TDML_NAMESPACE() {
        return TDML_NAMESPACE;
    }

    public NS EXAMPLE_NAMESPACE() {
        return EXAMPLE_NAMESPACE;
    }

    public NS XHTML_NAMESPACE() {
        return XHTML_NAMESPACE;
    }

    public Elem getXSDElement(NamespaceBinding scope) {
        String string;
        boolean isXSDTheDefaultNS;
        String xsdPre = scope.getPrefix(this.XSD_NAMESPACE().toString());
        String string2 = this.XSD_NAMESPACE().toString();
        String string3 = scope.getURI(null);
        boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? true : (isXSDTheDefaultNS = false);
        if (xsdPre != null) {
            string = xsdPre;
        } else {
            if (!isXSDTheDefaultNS) {
                throw Assert$.MODULE$.usageError("Scope argument must have a binding for the XSD namespace.");
            }
            string = null;
        }
        String xsdPrefix = string;
        Elem res = Elem$.MODULE$.apply(xsdPrefix, "element", (MetaData)Null$.MODULE$, scope, true, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Node[0]));
        return res;
    }

    public String EXT_PREFIX_NCSA() {
        return EXT_PREFIX_NCSA;
    }

    public NS EXT_NS_NCSA() {
        return EXT_NS_NCSA;
    }

    public String EXT_PREFIX_APACHE() {
        return EXT_PREFIX_APACHE;
    }

    public NS EXT_NS_APACHE() {
        return EXT_NS_APACHE;
    }

    public String INT_PREFIX() {
        return INT_PREFIX;
    }

    public NS INT_NS() {
        return INT_NS;
    }

    public String DAFFODIL_SAX_URN_ROOT() {
        return DAFFODIL_SAX_URN_ROOT;
    }

    public String DAFFODIL_SAX_URN_PARSERESULT() {
        return DAFFODIL_SAX_URN_PARSERESULT;
    }

    public String DAFFODIL_SAX_URN_BLOBDIRECTORY() {
        return DAFFODIL_SAX_URN_BLOBDIRECTORY;
    }

    public String DAFFODIL_SAX_URN_BLOBPREFIX() {
        return DAFFODIL_SAX_URN_BLOBPREFIX;
    }

    public String DAFFODIL_SAX_URN_BLOBSUFFIX() {
        return DAFFODIL_SAX_URN_BLOBSUFFIX;
    }

    public String SAX_NAMESPACES_FEATURE() {
        return SAX_NAMESPACES_FEATURE;
    }

    public String SAX_NAMESPACE_PREFIXES_FEATURE() {
        return SAX_NAMESPACE_PREFIXES_FEATURE;
    }

    public String XML_DISALLOW_DOCTYPE_FEATURE() {
        return XML_DISALLOW_DOCTYPE_FEATURE;
    }

    public String XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE() {
        return XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE;
    }

    public String XML_EXTERNAL_GENERAL_ENTITIES_FEATURE() {
        return XML_EXTERNAL_GENERAL_ENTITIES_FEATURE;
    }

    public String XML_LOAD_EXTERNAL_DTD_FEATURE() {
        return XML_LOAD_EXTERNAL_DTD_FEATURE;
    }

    public void setSecureDefaults(XMLReader xmlReader) {
        xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        xmlReader.setFeature(this.XML_DISALLOW_DOCTYPE_FEATURE(), true);
        xmlReader.setFeature(this.XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE(), false);
        xmlReader.setFeature(this.XML_EXTERNAL_GENERAL_ENTITIES_FEATURE(), false);
    }

    public String FILE_ATTRIBUTE_NAME() {
        return FILE_ATTRIBUTE_NAME;
    }

    public String LINE_ATTRIBUTE_NAME() {
        return LINE_ATTRIBUTE_NAME;
    }

    public String COLUMN_ATTRIBUTE_NAME() {
        return COLUMN_ATTRIBUTE_NAME;
    }

    public NS xsdURI() {
        return xsdURI;
    }

    public NS dfdlURI() {
        return dfdlURI;
    }

    public NS dfdlxURI() {
        return dfdlxURI;
    }

    public NS dfdlAppinfoSource() {
        return dfdlAppinfoSource;
    }

    public NS targetNS() {
        return targetNS;
    }

    public NS xsiURI() {
        return xsiURI;
    }

    public NS fnURI() {
        return fnURI;
    }

    public NS mathURI() {
        return mathURI;
    }

    public NS dafintURI() {
        return dafintURI;
    }

    public List<String> DFDL_SIMPLE_BUILT_IN_TYPES() {
        return DFDL_SIMPLE_BUILT_IN_TYPES;
    }

    public String slashify(String s) {
        String string = s;
        String string2 = "";
        if (!(string == null ? string2 != null : !string.equals(string2)) || s.endsWith("/")) {
            return s;
        }
        return s + "/";
    }

    public scala.collection.immutable.Seq<NamespaceBinding> namespaceBindings(NamespaceBinding nsBinding) {
        if (nsBinding == null) {
            return scala.package$.MODULE$.Nil();
        }
        Nil$ thisOne = nsBinding.uri() != null ? (List)new .colon.colon((Object)nsBinding, (List)Nil$.MODULE$) : scala.package$.MODULE$.Nil();
        scala.collection.immutable.Seq<NamespaceBinding> others = this.namespaceBindings(nsBinding.parent());
        return (scala.collection.immutable.Seq)thisOne.$plus$plus(others);
    }

    public MetaData dfdlAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable)_$27 -> {
            String string = _$27.getNamespace(n);
            String string2 = MODULE$.DFDL_NAMESPACE().toString();
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public MetaData dfdlxAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable)_$28 -> {
            String string = _$28.getNamespace(n);
            String string2 = MODULE$.DFDLX_NAMESPACE().toString();
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    public MetaData dafAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable)a -> {
            String string = a.getNamespace(n);
            String string2 = MODULE$.EXT_NS_NCSA().toString();
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) return true;
            String string3 = a.getNamespace(n);
            String string4 = MODULE$.EXT_NS_APACHE().toString();
            if (string3 != null) {
                if (!string3.equals(string4)) return false;
                return true;
            }
            if (string4 == null) return true;
            return false;
        });
    }

    public NamespaceBinding combineScopes(NamespaceBinding local, NamespaceBinding outer) {
        String outerURI;
        NamespaceBinding moreBindings;
        String uri;
        String pre;
        while (true) {
            NamespaceBinding namespaceBinding = local;
            TopScope$ topScope$ = TopScope$.MODULE$;
            if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null)) {
                return outer;
            }
            NamespaceBinding namespaceBinding2 = local;
            if (namespaceBinding2 == null) {
                throw new MatchError((Object)namespaceBinding2);
            }
            NamespaceBinding namespaceBinding3 = NamespaceBinding$.MODULE$.unapply(namespaceBinding2);
            String string = namespaceBinding3._1();
            String string2 = namespaceBinding3._2();
            NamespaceBinding namespaceBinding4 = namespaceBinding3._3();
            String pre2 = string;
            String uri2 = string2;
            NamespaceBinding moreBindings2 = namespaceBinding4;
            Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)pre2, (Object)uri2, (Object)moreBindings2);
            pre = (String)tuple3._1();
            uri = (String)tuple3._2();
            moreBindings = (NamespaceBinding)tuple3._3();
            String string3 = outerURI = outer.getURI(pre);
            String string4 = uri;
            if (string3 != null ? !string3.equals(string4) : string4 != null) break;
            local = moreBindings;
        }
        if (outerURI == null) {
            return NamespaceBinding$.MODULE$.apply(pre, uri, this.combineScopes(moreBindings, outer));
        }
        NamespaceBinding outerWithoutDuplicate = this.removeBindings(NamespaceBinding$.MODULE$.apply(pre, uri, (NamespaceBinding)TopScope$.MODULE$), outer);
        NamespaceBinding moreBindingsWithoutConflict = this.removeBindings(NamespaceBinding$.MODULE$.apply(pre, uri, (NamespaceBinding)TopScope$.MODULE$), moreBindings);
        return NamespaceBinding$.MODULE$.apply(pre, uri, this.combineScopes(moreBindingsWithoutConflict, outerWithoutDuplicate));
    }

    public NamespaceBinding removeBindings(NamespaceBinding nb, NamespaceBinding scope) {
        NamespaceBinding more;
        while (true) {
            NamespaceBinding namespaceBinding = nb;
            TopScope$ topScope$ = TopScope$.MODULE$;
            if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null)) {
                return scope;
            }
            NamespaceBinding namespaceBinding2 = scope;
            TopScope$ topScope$2 = TopScope$.MODULE$;
            if (!(namespaceBinding2 != null ? !namespaceBinding2.equals(topScope$2) : topScope$2 != null)) {
                return scope;
            }
            NamespaceBinding namespaceBinding3 = scope;
            if (namespaceBinding3 == null) {
                throw new MatchError((Object)namespaceBinding3);
            }
            NamespaceBinding namespaceBinding4 = NamespaceBinding$.MODULE$.unapply(namespaceBinding3);
            String string = namespaceBinding4._1();
            String string2 = namespaceBinding4._2();
            NamespaceBinding namespaceBinding5 = namespaceBinding4._3();
            String pre = string;
            NamespaceBinding more2 = namespaceBinding5;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)pre, (Object)more2);
            String pre2 = (String)tuple2._1();
            more = (NamespaceBinding)tuple2._2();
            if (nb.getURI(pre2) == null) break;
            scope = more;
        }
        NamespaceBinding namespaceBinding = this.removeBindings(nb, more);
        String string = scope.copy$default$1();
        String string3 = scope.copy$default$2();
        return scope.copy(string, string3, namespaceBinding);
    }

    public NamespaceBinding combineScopes(String prefix, NS ns, NamespaceBinding outer) {
        Object object = ns.optURI();
        if (Maybe$.MODULE$.isEmpty$extension(object)) {
            return outer;
        }
        Object object2 = ns.optURI();
        String uri = ((URI)Maybe$.MODULE$.get$extension(object2)).toString();
        NamespaceBinding inner = NamespaceBinding$.MODULE$.apply(prefix, uri, (NamespaceBinding)TopScope$.MODULE$);
        return this.combineScopes(inner, outer);
    }

    public Node collapseScopes(Node x, NamespaceBinding outer) {
        Option option;
        Node node = x;
        if (node != null && !(option = Elem$.MODULE$.unapplySeq(node)).isEmpty()) {
            Tuple5 tuple5 = (Tuple5)option.get();
            String pre = (String)tuple5._1();
            String lab = (String)tuple5._2();
            MetaData md = (MetaData)tuple5._3();
            NamespaceBinding scp = (NamespaceBinding)tuple5._4();
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)tuple5._5();
            if (seq.lengthCompare(0) >= 0) {
                scala.collection.immutable.Seq seq2;
                scala.collection.immutable.Seq child = seq2 = seq.toSeq();
                NamespaceBinding newScope = this.combineScopes(scp, outer);
                return Elem$.MODULE$.apply(pre, lab, md, newScope, true, (scala.collection.immutable.Seq)child.flatMap((Function1 & Serializable)ch -> MODULE$.collapseScopes((Node)ch, newScope)));
            }
        }
        return x;
    }

    public NamespaceBinding filterScope(NamespaceBinding nsb, scala.collection.immutable.Seq<NS> nss) {
        TopScope$ topScope$;
        NamespaceBinding namespaceBinding = nsb;
        TopScope$ topScope$2 = TopScope$.MODULE$;
        if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$2) : topScope$2 != null)) {
            topScope$ = TopScope$.MODULE$;
        } else {
            NamespaceBinding parentCopy = this.filterScope(nsb.parent(), nss);
            topScope$ = nss.contains((Object)NS$.MODULE$.apply(nsb.uri())) ? parentCopy : nsb.copy(nsb.copy$default$1(), nsb.copy$default$2(), parentCopy);
        }
        TopScope$ newHead = topScope$;
        return newHead;
    }

    public boolean prefixInScope(String prefix, NamespaceBinding scope) {
        boolean bl;
        if (scope == null) {
            bl = false;
        } else {
            String string = prefix;
            String string2 = scope.prefix();
            bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : this.prefixInScope(prefix, scope.parent());
        }
        boolean ret = bl;
        return ret;
    }

    public Node removeComments(Node e) {
        Option option;
        Node node = e;
        if (node != null && !(option = Elem$.MODULE$.unapplySeq(node)).isEmpty()) {
            Tuple5 tuple5 = (Tuple5)option.get();
            String prefix = (String)tuple5._1();
            String label = (String)tuple5._2();
            MetaData attribs = (MetaData)tuple5._3();
            NamespaceBinding scope = (NamespaceBinding)tuple5._4();
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)tuple5._5();
            if (seq.lengthCompare(0) >= 0) {
                scala.collection.immutable.Seq seq2;
                scala.collection.immutable.Seq child = seq2 = seq.toSeq();
                scala.collection.immutable.Seq newChildren = (scala.collection.immutable.Seq)((IterableOps)child.filterNot((Function1 & Serializable)_$29 -> _$29 instanceof Comment)).map((Function1 & Serializable)_$30 -> MODULE$.removeComments((Node)_$30));
                return Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
            }
        }
        Node x = node;
        return x;
    }

    public Node removeAttributes(Node n, scala.collection.immutable.Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Node res1 = (Node)this.removeAttributes1(n, ns, parentScope);
        Node res2 = this.removeMixedWhitespace(res1);
        Node res = res2.apply(0);
        return res;
    }

    public scala.collection.immutable.Seq<NS> removeAttributes$default$2() {
        return (scala.collection.immutable.Seq)((SeqOps)Nil$.MODULE$);
    }

    public Option<NamespaceBinding> removeAttributes$default$3() {
        return None$.MODULE$;
    }

    private Node removeMixedWhitespace(Node ns2) {
        if (!(ns2 instanceof Elem)) {
            return ns2;
        }
        Elem e = (Elem)ns2;
        scala.collection.immutable.Seq children = e.child();
        scala.collection.immutable.Seq noMixedChildren = children.exists((Function1 & Serializable)_$31 -> _$31 instanceof Elem) ? (scala.collection.immutable.Seq)((IterableOps)children.filter((Function1 & Serializable)x$1 -> {
            Option option;
            Node node = x$1;
            if (node != null && !(option = Text$.MODULE$.unapply((Object)node)).isEmpty()) {
                String string = (String)option.get();
                String string2 = string;
                String data = string2;
                if (data.matches("\\s*")) {
                    return false;
                }
                String data2 = string2;
                throw new Exception(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Element %s contains mixed data: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{e.label(), data2})));
            }
            return true;
        })).map((Function1 & Serializable)ns -> MODULE$.removeMixedWhitespace((Node)ns)) : (scala.collection.immutable.Seq)children.filter((Function1 & Serializable)x$1 -> {
            String string;
            Option option;
            Node node = x$1;
            return node == null || (option = Text$.MODULE$.unapply((Object)node)).isEmpty() || !"".equals(string = (String)option.get());
        });
        Elem res = noMixedChildren == children ? e : e.copy(e.copy$default$1(), e.copy$default$2(), e.copy$default$3(), e.copy$default$4(), e.copy$default$5(), (Seq)noMixedChildren);
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private Node convertPCDataToText(Node n) {
        block3: {
            block4: {
                block2: {
                    var3_2 = n;
                    if (!(var3_2 instanceof Text)) break block2;
                    v0 = t = (Text)var3_2;
                    break block3;
                }
                if (!(var3_2 instanceof Atom)) break block4;
                a = (Atom)var3_2;
                v0 = Text$.MODULE$.apply(a.text());
                break block3;
            }
            if (var3_2 == null || (var6_5 = Elem$.MODULE$.unapplySeq(var3_2)).isEmpty()) ** GOTO lbl-1000
            var7_6 = (Tuple5)var6_5.get();
            prefix = (String)var7_6._1();
            label = (String)var7_6._2();
            attributes = (MetaData)var7_6._3();
            scope = (NamespaceBinding)var7_6._4();
            var12_11 = (scala.collection.immutable.Seq)var7_6._5();
            if (var12_11.lengthCompare(0) >= 0) {
                children = var13_12 = var12_11.toSeq();
                newChildren = (scala.collection.immutable.Seq)children.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$8(scala.xml.Node ), (Lscala/xml/Node;)Lscala/xml/Node;)());
                v0 = Elem$.MODULE$.apply(prefix, label, attributes, scope, true, newChildren);
            } else lbl-1000:
            // 2 sources

            {
                v0 = n;
            }
        }
        res = v0;
        return res;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private NodeSeq removeAttributes1(Node n, scala.collection.immutable.Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        var5_4 = n;
        if (var5_4 == null || (var6_5 = Elem$.MODULE$.unapplySeq(var5_4)).isEmpty()) ** GOTO lbl-1000
        var7_6 = (Tuple5)var6_5.get();
        prefix = (String)var7_6._1();
        label = (String)var7_6._2();
        attributes = (MetaData)var7_6._3();
        scope = (NamespaceBinding)var7_6._4();
        var12_11 = (scala.collection.immutable.Seq)var7_6._5();
        if (var12_11.lengthCompare(0) >= 0) {
            children = var13_12 = var12_11.toSeq();
            e = var5_4;
            filteredScope = ns.length() > 0 ? this.filterScope(scope, ns) : TopScope$.MODULE$;
            var18_16 = parentScope;
            if (var18_16 instanceof Some) {
                v0 = ps = (NamespaceBinding)((Some)var18_16).value();
                var20_18 = filteredScope;
                v1 /* !! */  = !(v0 != null ? v0.equals(var20_18) == false : var20_18 != null) ? ps : filteredScope;
            } else if (None$.MODULE$.equals(var18_16)) {
                v1 /* !! */  = filteredScope;
            } else {
                throw new MatchError(var18_16);
            }
            newScope = v1 /* !! */ ;
            newChildren = NodeSeq$.MODULE$.seqToNodeSeq((Seq)children.flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$9(scala.collection.immutable.Seq scala.xml.NamespaceBinding scala.xml.Node ), (Lscala/xml/Node;)Lscala/collection/IterableOnce;)(ns, (NamespaceBinding)newScope)));
            textMergedChildren = this.coalesceAdjacentTextNodes((scala.collection.immutable.Seq<Node>)newChildren);
            newPrefix = this.prefixInScope(prefix, (NamespaceBinding)newScope) != false ? prefix : null;
            newAttributes = attributes.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$10(scala.xml.Node scala.xml.MetaData ), (Lscala/xml/MetaData;)Ljava/lang/Boolean;)((Node)e));
            v2 = Elem$.MODULE$.apply(newPrefix, label, newAttributes, (NamespaceBinding)newScope, true, textMergedChildren);
        } else if (var5_4 instanceof Comment) {
            c = (Comment)var5_4;
            v2 = NodeSeq$.MODULE$.Empty();
        } else {
            v2 = other = var5_4;
        }
        res = v2;
        return res;
    }

    public Node normalize(Node n) {
        Node noComments = this.removeComments(n);
        Node noPCData = this.convertPCDataToText(noComments);
        Node combinedText = this.coalesceAllAdjacentTextNodes(noPCData);
        Node noMixedWS = this.removeMixedWhitespace(combinedText);
        return noMixedWS;
    }

    public void compareAndReport(Node expected, Node actual, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        Node actualMinimized;
        Node expectedMinimized = this.normalize(expected);
        scala.collection.immutable.Seq<Tuple3<String, String, String>> diffs = this.computeDiff(expectedMinimized, actualMinimized = this.normalize(actual), ignoreProcInstr, checkPrefixes, checkNamespaces, maybeFloatEpsilon, maybeDoubleEpsilon);
        if (diffs.length() > 0) {
            throw new XMLUtils.XMLDifferenceException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\nComparison failed.\nExpected (attributes %s)\n          %s\nActual (attributes %s for diff)\n          %s\nDifferences were (path, expected, actual):\n%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{checkPrefixes || checkNamespaces ? "compared for diff" : "stripped", checkPrefixes || checkNamespaces ? expected : this.removeAttributes(expected, this.removeAttributes$default$2(), this.removeAttributes$default$3()).toString(), checkPrefixes || checkNamespaces ? "compared" : "ignored", actual, ((IterableOnceOps)diffs.map((Function1 & Serializable)_$34 -> _$34.toString())).mkString("- ", "\n- ", "\n")})));
        }
    }

    public boolean compareAndReport$default$3() {
        return true;
    }

    public boolean compareAndReport$default$4() {
        return false;
    }

    public boolean compareAndReport$default$5() {
        return false;
    }

    public Option<Object> compareAndReport$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> compareAndReport$default$7() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeDiff(Node a, Node b, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        return this.computeDiffOne(a, b, (NamespaceBinding)TopScope$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<String>)scala.package$.MODULE$.Nil(), ignoreProcInstr, checkPrefixes, checkNamespaces, (Option<String>)None$.MODULE$, maybeFloatEpsilon, maybeDoubleEpsilon);
    }

    public boolean computeDiff$default$3() {
        return true;
    }

    public boolean computeDiff$default$4() {
        return false;
    }

    public boolean computeDiff$default$5() {
        return false;
    }

    public Option<Object> computeDiff$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> computeDiff$default$7() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Map<String, Object> childArrayCounters(Elem e) {
        scala.collection.immutable.Seq seq;
        Tuple5 tuple5;
        scala.collection.immutable.Seq seq2;
        Option option;
        Elem elem = e;
        if (elem == null || (option = Elem$.MODULE$.unapplySeq((Node)elem)).isEmpty() || (seq2 = (scala.collection.immutable.Seq)(tuple5 = (Tuple5)option.get())._5()).lengthCompare(0) < 0) {
            Elem x2 = elem;
            throw Assert$.MODULE$.invariantFailed("Expected elem with children, found " + x2);
        }
        scala.collection.immutable.Seq c = seq = seq2.toSeq();
        scala.collection.immutable.Seq children = c;
        scala.collection.immutable.Seq labels = (scala.collection.immutable.Seq)children.map((Function1 & Serializable)_$35 -> _$35.label());
        scala.collection.immutable.Map groups = labels.groupBy((Function1 & Serializable)x -> x);
        scala.collection.immutable.Map counts = (scala.collection.immutable.Map)groups.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                scala.collection.immutable.Seq labelList = (scala.collection.immutable.Seq)tuple2._2();
                return Tuple2$.MODULE$.apply((Object)label, (Object)BoxesRunTime.boxToInteger((int)labelList.length()));
            }
            throw new MatchError((Object)tuple2);
        });
        scala.collection.immutable.Map arrayCounts = (scala.collection.immutable.Map)counts.filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                if (1 == BoxesRunTime.unboxToInt((Object)tuple2._2())) {
                    return false;
                }
            }
            return true;
        });
        scala.collection.immutable.Map arrayCounters = (scala.collection.immutable.Map)arrayCounts.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                return Tuple2$.MODULE$.apply((Object)label, (Object)BoxesRunTime.boxToLong((long)1));
            }
            throw new MatchError((Object)tuple2);
        });
        return arrayCounters;
    }

    private Option<String> getXSIType(Elem a) {
        Option res = a.attribute(this.XSI_NAMESPACE().toString(), "type").map((Function1 & Serializable)_$36 -> ((Node)_$36.head()).text());
        return res;
    }

    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeDiffOne(Node an, Node bn, NamespaceBinding aParentScope, NamespaceBinding bParentScope, Option<Object> maybeIndex, scala.collection.immutable.Seq<String> parentPathSteps, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces, Option<String> maybeType, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        LazyRef lazyRef;
        block23: {
            Node node;
            Node node2;
            block24: {
                Tuple2 tuple2;
                scala.collection.immutable.Seq seq;
                scala.collection.immutable.Seq seq2;
                NamespaceBinding nsbB;
                MetaData attribsB;
                String labelB;
                String prefixB;
                scala.collection.immutable.Seq childrenA;
                NamespaceBinding nsbA;
                String labelA;
                String prefixA;
                Elem b;
                Elem a;
                block28: {
                    Elem elem;
                    block27: {
                        Option option;
                        scala.collection.immutable.Seq seq3;
                        scala.collection.immutable.Seq seq4;
                        NamespaceBinding nsbA2;
                        MetaData attribsA;
                        String labelA2;
                        String prefixA2;
                        block26: {
                            Elem elem2;
                            block25: {
                                Option option2;
                                lazyRef = new LazyRef();
                                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)an, (Object)bn);
                                if (tuple22 == null) break block23;
                                node2 = (Node)tuple22._1();
                                node = (Node)tuple22._2();
                                if (!(node2 instanceof Elem)) break block24;
                                a = (Elem)node2;
                                if (!(node instanceof Elem)) break block24;
                                b = (Elem)node;
                                elem2 = a;
                                if (elem2 == null || (option2 = Elem$.MODULE$.unapplySeq((Node)elem2)).isEmpty()) break block25;
                                Tuple5 tuple5 = (Tuple5)option2.get();
                                prefixA2 = (String)tuple5._1();
                                labelA2 = (String)tuple5._2();
                                attribsA = (MetaData)tuple5._3();
                                nsbA2 = (NamespaceBinding)tuple5._4();
                                seq4 = (scala.collection.immutable.Seq)tuple5._5();
                                if (seq4.lengthCompare(0) >= 0) break block26;
                            }
                            Elem x = elem2;
                            throw Assert$.MODULE$.invariantFailed("Expected elem, found " + x);
                        }
                        scala.collection.immutable.Seq childrenA2 = seq3 = seq4.toSeq();
                        Tuple5 tuple5 = Tuple5$.MODULE$.apply((Object)prefixA2, (Object)labelA2, (Object)attribsA, (Object)nsbA2, (Object)childrenA2);
                        if (tuple5 == null) {
                            throw new MatchError((Object)tuple5);
                        }
                        String prefixA3 = (String)tuple5._1();
                        String labelA3 = (String)tuple5._2();
                        MetaData attribsA2 = (MetaData)tuple5._3();
                        NamespaceBinding nsbA3 = (NamespaceBinding)tuple5._4();
                        scala.collection.immutable.Seq childrenA3 = (scala.collection.immutable.Seq)tuple5._5();
                        Tuple5 tuple52 = Tuple5$.MODULE$.apply((Object)prefixA3, (Object)labelA3, (Object)attribsA2, (Object)nsbA3, (Object)childrenA3);
                        prefixA = (String)tuple52._1();
                        labelA = (String)tuple52._2();
                        MetaData attribsA3 = (MetaData)tuple52._3();
                        nsbA = (NamespaceBinding)tuple52._4();
                        childrenA = (scala.collection.immutable.Seq)tuple52._5();
                        elem = b;
                        if (elem == null || (option = Elem$.MODULE$.unapplySeq((Node)elem)).isEmpty()) break block27;
                        Tuple5 tuple53 = (Tuple5)option.get();
                        prefixB = (String)tuple53._1();
                        labelB = (String)tuple53._2();
                        attribsB = (MetaData)tuple53._3();
                        nsbB = (NamespaceBinding)tuple53._4();
                        seq2 = (scala.collection.immutable.Seq)tuple53._5();
                        if (seq2.lengthCompare(0) >= 0) break block28;
                    }
                    Elem x = elem;
                    throw Assert$.MODULE$.invariantFailed("Expected elem, found " + x);
                }
                scala.collection.immutable.Seq childrenB = seq = seq2.toSeq();
                Tuple5 tuple5 = Tuple5$.MODULE$.apply((Object)prefixB, (Object)labelB, (Object)attribsB, (Object)nsbB, (Object)childrenB);
                if (tuple5 == null) {
                    throw new MatchError((Object)tuple5);
                }
                String prefixB2 = (String)tuple5._1();
                String labelB2 = (String)tuple5._2();
                MetaData attribsB2 = (MetaData)tuple5._3();
                NamespaceBinding nsbB2 = (NamespaceBinding)tuple5._4();
                scala.collection.immutable.Seq childrenB2 = (scala.collection.immutable.Seq)tuple5._5();
                Tuple5 tuple54 = Tuple5$.MODULE$.apply((Object)prefixB2, (Object)labelB2, (Object)attribsB2, (Object)nsbB2, (Object)childrenB2);
                String prefixB3 = (String)tuple54._1();
                String labelB3 = (String)tuple54._2();
                MetaData attribsB3 = (MetaData)tuple54._3();
                NamespaceBinding nsbB3 = (NamespaceBinding)tuple54._4();
                scala.collection.immutable.Seq childrenB3 = (scala.collection.immutable.Seq)tuple54._5();
                Option<String> typeA = this.getXSIType(a);
                Option<String> typeB = this.getXSIType(b);
                Option maybeType2 = Option$.MODULE$.apply(typeA.getOrElse(() -> XMLUtils$.$anonfun$17(typeB)));
                Option nilledA = a.attribute(this.XSI_NAMESPACE().toString(), "nil");
                Option nilledB = b.attribute(this.XSI_NAMESPACE().toString(), "nil");
                String mappingsA = checkNamespaces ? nsbA.buildString(aParentScope).trim() : "";
                String mappingsB = checkNamespaces ? nsbB3.buildString(bParentScope).trim() : "";
                String string = labelA;
                String string2 = labelB3;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return (scala.collection.immutable.Seq)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)this.zPath$1(lazyRef, parentPathSteps), (Object)labelA, (Object)labelB3), (List)Nil$.MODULE$);
                }
                if (checkPrefixes) {
                    String string3 = prefixA;
                    String string4 = prefixB3;
                    if (string3 == null ? string4 != null : !string3.equals(string4)) {
                        return (scala.collection.immutable.Seq)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)(this.zPath$1(lazyRef, parentPathSteps) + "/" + labelA + "@prefix"), (Object)prefixA, (Object)prefixB3), (List)Nil$.MODULE$);
                    }
                }
                if (checkNamespaces) {
                    String string5 = mappingsA;
                    String string6 = mappingsB;
                    if (string5 == null ? string6 != null : !string5.equals(string6)) {
                        return (scala.collection.immutable.Seq)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)(this.zPath$1(lazyRef, parentPathSteps) + "/" + labelA + "@xmlns"), (Object)mappingsA, (Object)mappingsB), (List)Nil$.MODULE$);
                    }
                }
                Option option = nilledA;
                Option option3 = nilledB;
                if (option == null ? option3 != null : !option.equals(option3)) {
                    return (scala.collection.immutable.Seq)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)(this.zPath$1(lazyRef, parentPathSteps) + "/" + labelA + "@xsi:nil"), nilledA.map((Function1 & Serializable)_$37 -> _$37.toString()).getOrElse(XMLUtils$::computeDiffOne$$anonfun$2), nilledB.map((Function1 & Serializable)_$38 -> _$38.toString()).getOrElse(XMLUtils$::computeDiffOne$$anonfun$4)), (List)Nil$.MODULE$);
                }
                Option<String> option4 = typeA;
                Option<String> option5 = typeB;
                if ((option4 == null ? option5 != null : !option4.equals(option5)) && typeA.isDefined() && typeB.isDefined()) {
                    return (scala.collection.immutable.Seq)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)(this.zPath$1(lazyRef, parentPathSteps) + "/" + labelA + "@xsi:type"), typeA.map((Function1 & Serializable)_$39 -> _$39.toString()).getOrElse(XMLUtils$::computeDiffOne$$anonfun$6), typeA.map((Function1 & Serializable)_$40 -> _$40.toString()).getOrElse(XMLUtils$::computeDiffOne$$anonfun$8)), (List)Nil$.MODULE$);
                }
                String pathLabel = labelA + maybeIndex.map((Function1 & Serializable)_$41 -> XMLUtils$.$anonfun$18(BoxesRunTime.unboxToInt((Object)_$41))).getOrElse(XMLUtils$::$anonfun$19);
                scala.collection.immutable.Seq thisPathStep = (scala.collection.immutable.Seq)parentPathSteps.$plus$colon((Object)pathLabel);
                if (ignoreProcInstr) {
                    scala.collection.immutable.Seq ca = (scala.collection.immutable.Seq)childrenA.filterNot((Function1 & Serializable)_$42 -> _$42 instanceof ProcInstr);
                    scala.collection.immutable.Seq cb = (scala.collection.immutable.Seq)childrenB3.filterNot((Function1 & Serializable)_$43 -> _$43 instanceof ProcInstr);
                    tuple2 = Tuple2$.MODULE$.apply((Object)ca, (Object)cb);
                } else {
                    tuple2 = Tuple2$.MODULE$.apply((Object)childrenA, (Object)childrenB3);
                }
                Tuple2 tuple23 = tuple2;
                scala.collection.immutable.Seq childrenACompare = (scala.collection.immutable.Seq)tuple23._1();
                scala.collection.immutable.Seq childrenBCompare = (scala.collection.immutable.Seq)tuple23._2();
                Iterable repeatingChildrenLabels = ((MapOps)childrenA.groupBy((Function1 & Serializable)_$44 -> _$44.label()).filter((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        scala.collection.immutable.Seq v = (scala.collection.immutable.Seq)tuple2._2();
                        return v.length() > 1;
                    }
                    throw new MatchError((Object)tuple2);
                })).keys();
                Iterable labelsWithZeroCount = (Iterable)repeatingChildrenLabels.map((Function1 & Serializable)_$45 -> {
                    String string = (String)Predef$.MODULE$.ArrowAssoc(_$45);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BoxesRunTime.boxToInteger((int)0));
                });
                Map countMap = (Map)Map$.MODULE$.apply(labelsWithZeroCount.toSeq());
                scala.collection.immutable.Seq childrenDiffs = (scala.collection.immutable.Seq)((IterableOps)childrenACompare.zip((IterableOnce)childrenBCompare)).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Node ca = (Node)tuple2._1();
                        Node cb = (Node)tuple2._2();
                        Option maybeChildCount = countMap.get((Object)ca.label());
                        Option maybeChildIndex = maybeChildCount.map((Function1)(JFunction1.mcII.sp & Serializable)count -> {
                            String string = ca.label();
                            countMap.update((Object)string, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)countMap.apply((Object)string)) + 1)));
                            return count + 1;
                        });
                        return MODULE$.computeDiffOne(ca, cb, nsbA, nsbB3, (Option<Object>)maybeChildIndex, (scala.collection.immutable.Seq<String>)thisPathStep, ignoreProcInstr, checkPrefixes, checkNamespaces, (Option<String>)maybeType2, maybeFloatEpsilon, maybeDoubleEpsilon);
                    }
                    throw new MatchError((Object)tuple2);
                });
                Nil$ childrenLengthDiff = childrenA.length() != childrenB3.length() ? (List)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)(this.zPath$1(lazyRef, parentPathSteps) + "/" + labelA + "::child@count)"), (Object)BoxesRunTime.boxToInteger((int)childrenA.length()).toString(), (Object)BoxesRunTime.boxToInteger((int)childrenB3.length()).toString()), (List)Nil$.MODULE$) : scala.package$.MODULE$.Nil();
                return (scala.collection.immutable.Seq)childrenDiffs.$plus$plus((IterableOnce)childrenLengthDiff);
            }
            if (node2 instanceof Text) {
                Text tA = (Text)node2;
                if (node instanceof Text) {
                    Text tB = (Text)node;
                    scala.collection.immutable.Seq<Tuple3<String, String, String>> thisDiff = this.computeTextDiff(this.zPath$1(lazyRef, parentPathSteps), tA, tB, maybeType, maybeFloatEpsilon, maybeDoubleEpsilon);
                    return thisDiff;
                }
            }
            if (node2 instanceof ProcInstr) {
                ProcInstr pA = (ProcInstr)node2;
                if (node instanceof ProcInstr) {
                    ProcInstr pB = (ProcInstr)node;
                    ProcInstr procInstr = pA;
                    if (procInstr == null) {
                        throw new MatchError((Object)procInstr);
                    }
                    ProcInstr procInstr2 = ProcInstr$.MODULE$.unapply(procInstr);
                    String string = procInstr2._1();
                    String string7 = procInstr2._2();
                    String tA1label = string;
                    String tA1content = string7;
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)tA1label, (Object)tA1content);
                    String tA1label2 = (String)tuple2._1();
                    String tA1content2 = (String)tuple2._2();
                    ProcInstr procInstr3 = pB;
                    if (procInstr3 == null) {
                        throw new MatchError((Object)procInstr3);
                    }
                    ProcInstr procInstr4 = ProcInstr$.MODULE$.unapply(procInstr3);
                    String string8 = procInstr4._1();
                    String string9 = procInstr4._2();
                    String tB1label = string8;
                    String tB1content = string9;
                    Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)tB1label, (Object)tB1content);
                    String tB1label2 = (String)tuple24._1();
                    String tB1content2 = (String)tuple24._2();
                    scala.collection.immutable.Seq<Tuple3<String, String, String>> labelDiff = this.computeTextDiff(this.zPath$1(lazyRef, parentPathSteps), tA1label2, tB1label2, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    scala.collection.immutable.Seq<Tuple3<String, String, String>> contentDiff = this.computeTextDiff(this.zPath$1(lazyRef, parentPathSteps), tA1content2, tB1content2, maybeType, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    return (scala.collection.immutable.Seq)labelDiff.$plus$plus(contentDiff);
                }
            }
        }
        return (scala.collection.immutable.Seq)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)this.zPath$1(lazyRef, parentPathSteps), (Object)an.toString(), (Object)bn.toString()), (List)Nil$.MODULE$);
    }

    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, Text tA, Text tB, Option<String> maybeType, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        String dataA = tA.toString();
        String dataB = tB.toString();
        return this.computeTextDiff(zPath, dataA, dataB, maybeType, maybeFloatEpsilon, maybeDoubleEpsilon);
    }

    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeBlobDiff(String zPath, String dataA, String dataB) {
        Option<URI> uriA = Misc$.MODULE$.searchResourceOption(dataA, (Option<URI>)None$.MODULE$);
        Option<URI> uriB = Misc$.MODULE$.searchResourceOption(dataB, (Option<URI>)None$.MODULE$);
        Option pathA = uriA.map((Function1 & Serializable)u -> Paths.get(u));
        Option pathB = uriB.map((Function1 & Serializable)u -> Paths.get(u));
        boolean canReadA = BoxesRunTime.unboxToBoolean((Object)pathA.map((Function1 & Serializable)p -> Files.isReadable(p)).getOrElse(XMLUtils$::$anonfun$30));
        boolean canReadB = BoxesRunTime.unboxToBoolean((Object)pathB.map((Function1 & Serializable)p -> Files.isReadable(p)).getOrElse(XMLUtils$::$anonfun$32));
        if (!canReadA || !canReadB) {
            String path = zPath + ".canRead";
            return (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)path, (Object)BoxesRunTime.boxToBoolean((boolean)canReadA).toString(), (Object)BoxesRunTime.boxToBoolean((boolean)canReadB).toString()), (List)Nil$.MODULE$));
        }
        int CHUNK_SIZE = 1024;
        byte[] arrayA = new byte[CHUNK_SIZE];
        byte[] arrayB = new byte[CHUNK_SIZE];
        InputStream streamA = Files.newInputStream((Path)pathA.get(), StandardOpenOption.READ);
        InputStream streamB = Files.newInputStream((Path)pathB.get(), StandardOpenOption.READ);
        int lenA = 0;
        int lenB = 0;
        int numSameBytes = 0;
        boolean areSame = true;
        while (true) {
            boolean bl = areSame = (lenA = streamA.read(arrayA)) == (lenB = streamB.read(arrayB)) && Predef$.MODULE$.wrapByteArray(arrayA).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(arrayB));
            if (!areSame || lenA == -1 || lenB == -1) break;
            numSameBytes += lenA;
        }
        if (!areSame) {
            Object object = Predef$.MODULE$.byteArrayOps(arrayA);
            Object[] zip = ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.wrapByteArray(arrayB));
            Object object2 = Predef$.MODULE$.refArrayOps(zip);
            int firstDiffIndex = ArrayOps$.MODULE$.indexWhere$extension(object2, (Function1 & Serializable)z -> BoxesRunTime.unboxToByte((Object)z._1()) != BoxesRunTime.unboxToByte((Object)z._2()), ArrayOps$.MODULE$.indexWhere$default$2$extension(object2));
            int MAX_CONTEXT = 40;
            Object object3 = Predef$.MODULE$.byteArrayOps(arrayA);
            Object object4 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.take$extension(object3, lenA));
            Object object5 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.drop$extension(object4, firstDiffIndex));
            byte[] contextA = (byte[])ArrayOps$.MODULE$.take$extension(object5, MAX_CONTEXT);
            Object object6 = Predef$.MODULE$.byteArrayOps(arrayB);
            Object object7 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.take$extension(object6, lenB));
            Object object8 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.drop$extension(object7, firstDiffIndex));
            byte[] contextB = (byte[])ArrayOps$.MODULE$.take$extension(object8, MAX_CONTEXT);
            String hexA = Misc$.MODULE$.bytes2Hex(contextA);
            String hexB = Misc$.MODULE$.bytes2Hex(contextB);
            int absoluteIndex = numSameBytes + firstDiffIndex;
            String path = zPath + ".bytesAt(" + (absoluteIndex + 1) + ")";
            return (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)path, (Object)hexA, (Object)hexB), (List)Nil$.MODULE$));
        }
        return scala.package$.MODULE$.Nil();
    }

    /*
     * Unable to fully structure code
     */
    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, String dataA, String dataB, Option<String> maybeType, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        if (!maybeType.isDefined()) ** GOTO lbl-1000
        v0 = maybeType.get();
        var8_7 = "xs:anyURI";
        if (!(v0 != null ? v0.equals(var8_7) == false : var8_7 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        hasBlobType = v1;
        dataLooksLikeBlobURI = ((SeqOps)new .colon.colon((Object)dataA, (List)new .colon.colon((Object)dataB, (List)Nil$.MODULE$))).forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$34(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Boolean;)());
        if (hasBlobType || dataLooksLikeBlobURI) {
            return this.computeBlobDiff(zPath, dataA, dataB);
        }
        if (this.textIsSame(dataA, dataB, maybeType, maybeFloatEpsilon, maybeDoubleEpsilon)) {
            return scala.package$.MODULE$.Nil();
        }
        CHARS_TO_SHOW_AFTER_DIFF = 40;
        lenA = dataA.length();
        lenB = dataB.length();
        for (index = 0; index < lenA && index < lenB && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataA), index) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataB), index); ++index) {
        }
        contextA = Misc$.MODULE$.remapStringToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataA), index, index + CHARS_TO_SHOW_AFTER_DIFF));
        contextB = Misc$.MODULE$.remapStringToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataB), index, index + CHARS_TO_SHOW_AFTER_DIFF));
        path = zPath + ".charAt(" + (index + 1) + ")";
        return (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)Tuple3$.MODULE$.apply((Object)path, (Object)contextA, (Object)contextB), (List)Nil$.MODULE$));
    }

    public boolean textIsSame(String dataA, String dataB, Option<String> maybeType, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        maybeFloatEpsilon.foreach((Function1)(JFunction1.mcVF.sp & Serializable)eps -> {
            if (!((double)eps > 0.0)) {
                throw Assert$.MODULE$.usageError("eps.>(0.0)");
            }
        });
        maybeDoubleEpsilon.foreach((Function1)(JFunction1.mcVD.sp & Serializable)eps -> {
            if (!(eps > 0.0)) {
                throw Assert$.MODULE$.usageError("eps.>(0.0)");
            }
        });
        Option<String> option = maybeType;
        if (option instanceof Some) {
            String string = (String)((Some)option).value();
            switch (string == null ? 0 : string.hashCode()) {
                case -1970409158: {
                    if (!"xs:dateTime".equals(string)) break;
                    DFDLDateTime a = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataA);
                    DFDLDateTime b = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataB);
                    DFDLDateTime dFDLDateTime = a;
                    DFDLDateTime dFDLDateTime2 = b;
                    return !(dFDLDateTime != null ? !((Object)dFDLDateTime).equals(dFDLDateTime2) : dFDLDateTime2 != null);
                }
                case -1819715379: {
                    if (!"xs:date".equals(string)) break;
                    DFDLDate a = DFDLDateConversion$.MODULE$.fromXMLString(dataA);
                    DFDLDate b = DFDLDateConversion$.MODULE$.fromXMLString(dataB);
                    DFDLDate dFDLDate = a;
                    DFDLDate dFDLDate2 = b;
                    return !(dFDLDate != null ? !((Object)dFDLDate).equals(dFDLDate2) : dFDLDate2 != null);
                }
                case -1819231252: {
                    if (!"xs:time".equals(string)) break;
                    DFDLTime a = DFDLTimeConversion$.MODULE$.fromXMLString(dataA);
                    DFDLTime b = DFDLTimeConversion$.MODULE$.fromXMLString(dataB);
                    DFDLTime dFDLTime = a;
                    DFDLTime dFDLTime2 = b;
                    return !(dFDLTime != null ? !((Object)dFDLTime).equals(dFDLTime2) : dFDLTime2 != null);
                }
                case -681830096: {
                    if (!"xs:double".equals(string)) break;
                    double a = this.strToDouble(dataA);
                    double b = this.strToDouble(dataB);
                    if (Predef$.MODULE$.double2Double(a).isNaN() && Predef$.MODULE$.double2Double(b).isNaN()) {
                        return true;
                    }
                    Option<Object> option2 = maybeDoubleEpsilon;
                    if (None$.MODULE$.equals(option2)) {
                        return a == b;
                    }
                    if (option2 instanceof Some) {
                        double epsilon = BoxesRunTime.unboxToDouble((Object)((Some)option2).value());
                        return package$.MODULE$.abs(a - b) < epsilon;
                    }
                    throw new MatchError(option2);
                }
                case 1355808061: {
                    if (!"xs:hexBinary".equals(string)) break;
                    return dataA.equalsIgnoreCase(dataB);
                }
            }
            if ("xs:float".equals(string)) {
                float a = this.strToFloat(dataA);
                float b = this.strToFloat(dataB);
                if (Predef$.MODULE$.float2Float(a).isNaN() && Predef$.MODULE$.float2Float(b).isNaN()) {
                    return true;
                }
                Option<Object> option3 = maybeFloatEpsilon;
                if (None$.MODULE$.equals(option3)) {
                    return a == b;
                }
                if (option3 instanceof Some) {
                    float epsilon = BoxesRunTime.unboxToFloat((Object)((Some)option3).value());
                    return package$.MODULE$.abs(a - b) < epsilon;
                }
                throw new MatchError(option3);
            }
        }
        String string = dataA;
        String string2 = dataB;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public Option<File> getOptTDMLFileFromNode(Node node) {
        return node.attribute(NS$.MODULE$.implicitNStoString(this.INT_NS()), this.FILE_ATTRIBUTE_NAME()).map((Function1 & Serializable)uriStringNode -> new File(NodeSeq$.MODULE$.seqToNodeSeq((Seq)uriStringNode).text()));
    }

    public File convertNodeToTempFile(Node xml, File tmpDir, String nameHint) {
        String prefix = this.prefixFromHint(nameHint);
        File tmpSchemaFile = File.createTempFile(prefix, ".dfdl.xsd", tmpDir);
        tmpSchemaFile.deleteOnExit();
        PrettyPrinter pp = new PrettyPrinter(2);
        String xmlString = pp.format(xml);
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        fw.write(xmlString);
        fw.close();
        return tmpSchemaFile;
    }

    public String convertNodeToTempFile$default$3() {
        return "daffodil_tmp_";
    }

    private String prefixFromHint(String nameHint) {
        int n = nameHint.length();
        switch (n) {
            case 0: {
                return "daffodil_tmp_";
            }
            case 1: {
                return nameHint + "__";
            }
            case 2: {
                return nameHint + "_";
            }
        }
        return nameHint;
    }

    public File convertInputStreamToTempFile(InputStream is, File tmpDir, String nameHint, String suffix) {
        String prefix = this.prefixFromHint(nameHint);
        File tmpSchemaFile = File.createTempFile(prefix, suffix, tmpDir);
        tmpSchemaFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        IOUtils.copy((InputStream)is, (OutputStream)fos);
        fos.close();
        return tmpSchemaFile;
    }

    public StringBuilder escape(String s, StringBuilder sb) {
        String str = xmlRemapperPreservingCR.remap(s);
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), i);
            char c2 = c;
            switch (c2) {
                case '\'': {
                    sb.append("&#x27;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
            }
            if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                sb.append(c);
                continue;
            }
            if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c)) || RichChar$.MODULE$.isControl$extension(Predef$.MODULE$.charWrapper(c))) {
                this.toNumericCharacterEntity(c, sb);
                continue;
            }
            if (c == '\u00a0') {
                this.toNumericCharacterEntity(c, sb);
                continue;
            }
            if (c < '\u00ff') {
                sb.append(c);
                continue;
            }
            this.toNumericCharacterEntity(c, sb);
        }
        return sb;
    }

    public StringBuilder escape$default$2() {
        return new StringBuilder();
    }

    public StringBuilder toNumericCharacterEntity(char c, StringBuilder sb) {
        char i = c;
        if (i <= '\u0000') {
            throw Assert$.MODULE$.usageError("i.>(0)");
        }
        String s = Integer.toHexString(i).toUpperCase();
        sb.append("&#x");
        sb.append(s);
        return sb.append(";");
    }

    /*
     * WARNING - void declaration
     */
    public String unescape(String raw) {
        void var3_2;
        String res = xmlEntityPattern.replaceAllIn((CharSequence)raw, (Function1 & Serializable)m -> {
            StringBuilder sb = Utility$.MODULE$.unescape(m.group("entity"), new StringBuilder());
            if (sb == null) {
                throw Assert$.MODULE$.abort("Invariant broken: sb.ne(null)");
            }
            return sb.toString();
        });
        void withoutNamedXMLCharEntities = var3_2;
        return withoutNamedXMLCharEntities;
    }

    public Object maybeURI(NamespaceBinding nsb, String prefix) {
        while (nsb != null) {
            String string = nsb.prefix();
            String string2 = prefix;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return Maybe$One$.MODULE$.apply(nsb.uri());
            }
            nsb = nsb.parent();
        }
        return Maybe$.MODULE$.Nope();
    }

    public Object maybePrefix(NamespaceBinding nsb, String uri) {
        while (nsb != null) {
            String string = nsb.uri();
            String string2 = uri;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (nsb.prefix() == null) {
                    return Maybe$.MODULE$.Nope();
                }
                return Maybe$One$.MODULE$.apply(nsb.prefix());
            }
            nsb = nsb.parent();
        }
        return Maybe$.MODULE$.Nope();
    }

    public Option<Tuple2<URISchemaSource, Object>> resolveSchemaLocation(String schemaLocation, Option<DaffodilSchemaSource> optContextURI) {
        None$ none$;
        boolean uriIsJustPathComponent;
        URI uRI;
        try {
            uRI = new URI(schemaLocation);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("schemaLocation is not a valid URI: " + schemaLocation, e);
        }
        URI uri = uRI;
        boolean bl = uriIsJustPathComponent = uri.getScheme() == null && uri.getAuthority() == null && uri.getQuery() == null && uri.getFragment() == null && uri.getPath() != null;
        if (uri.isAbsolute()) {
            try {
                uri.toURL().openStream().close();
                URISchemaSource uss = URISchemaSource$.MODULE$.apply(Misc$.MODULE$.uriToDiagnosticFile(uri), uri);
                none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)uss, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
            }
            catch (IOException e) {
                none$ = None$.MODULE$;
            }
        } else {
            if (!uriIsJustPathComponent) {
                String msg = "Non-absolute schemaLocation URI can only contain a path component: " + schemaLocation;
                throw new IllegalArgumentException(msg);
            }
            if (uri.getPath().startsWith("/")) {
                Option optResolvedAbsolute = None$.MODULE$.orElse(() -> this.$anonfun$36(uri)).orElse(() -> XMLUtils$.$anonfun$37(uri));
                none$ = optResolvedAbsolute;
            } else {
                if (!optContextURI.isDefined()) {
                    throw Assert$.MODULE$.usageError("optContextURI.isDefined");
                }
                DaffodilSchemaSource contextURI = (DaffodilSchemaSource)optContextURI.get();
                Option optResolvedRelative = None$.MODULE$.orElse(() -> XMLUtils$.$anonfun$38(uri, contextURI)).orElse(() -> this.$anonfun$40(uri));
                none$ = optResolvedRelative;
            }
        }
        None$ optResolved = none$;
        return optResolved;
    }

    private final void processText$1(ObjectRef tn$1, ObjectRef sb$1, ArrayBuilder ab$1) {
        if ((Node)tn$1.elem == null) {
            if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() > 0) {
                ab$1.$plus$eq((Object)new Text(((StringBuilder)sb$1.elem).toString()));
                ((StringBuilder)sb$1.elem).clear();
                return;
            }
            return;
        }
        if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() != 0) {
            throw Assert$.MODULE$.abort("Invariant broken: sb.==(null).||(sb.length().==(0))");
        }
        ab$1.$plus$eq((Object)((Node)tn$1.elem));
        tn$1.elem = null;
    }

    private static final /* synthetic */ Node $anonfun$8(Node _$32) {
        return MODULE$.convertPCDataToText(_$32);
    }

    private static final /* synthetic */ IterableOnce $anonfun$9(scala.collection.immutable.Seq ns$1, NamespaceBinding newScope$2, Node _$33) {
        return MODULE$.removeAttributes1(_$33, (scala.collection.immutable.Seq<NS>)ns$1, (Option<NamespaceBinding>)Some$.MODULE$.apply((Object)newScope$2));
    }

    private static final /* synthetic */ boolean $anonfun$10(Node e$2, MetaData m) {
        PrefixedAttribute prefixedAttribute;
        Some some;
        MetaData metaData = m;
        if (metaData instanceof PrefixedAttribute && !(some = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute = (PrefixedAttribute)metaData)).isEmpty()) {
            PrefixedAttribute xsiNilAttr;
            String string;
            Option option;
            String string2;
            Option option2;
            Tuple4 tuple4 = (Tuple4)some.get();
            String string3 = (String)tuple4._1();
            String string4 = (String)tuple4._2();
            Seq seq = (Seq)tuple4._3();
            if ("nil".equals(string4) && seq != null && !(option2 = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string2 = (String)option2.get())) {
                PrefixedAttribute xsiNilAttr2 = prefixedAttribute;
                NS nS = NS$.MODULE$.apply(xsiNilAttr2.getNamespace(e$2));
                NS nS2 = MODULE$.XSI_NAMESPACE();
                if (!(nS != null ? !((Object)nS).equals(nS2) : nS2 != null)) {
                    return true;
                }
            }
            if ("xsi".equals(string3) && "nil".equals(string4) && seq != null && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string = (String)option.get()) && (xsiNilAttr = prefixedAttribute).getNamespace(e$2) == null) {
                return true;
            }
            String pre = string3;
            PrefixedAttribute dafIntAttr = prefixedAttribute;
            if (pre != null) {
                String string5 = dafIntAttr.getNamespace(e$2);
                String string6 = DAFFODIL_INTERNAL_NAMESPACE.toString();
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    String string7 = pre;
                    String string8 = "";
                    if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                        throw Assert$.MODULE$.abort("Invariant broken: pre.!=(\"\")");
                    }
                    return false;
                }
            }
            if ("type".equals(string4)) {
                PrefixedAttribute xsiTypeAttr = prefixedAttribute;
                NS nS = NS$.MODULE$.apply(xsiTypeAttr.getNamespace(e$2));
                NS nS3 = MODULE$.XSI_NAMESPACE();
                if (!(nS != null ? !((Object)nS).equals(nS3) : nS3 != null)) {
                    return true;
                }
            }
            if ("xsi".equals(string3) && "type".equals(string4)) {
                PrefixedAttribute xsiTypeAttr = prefixedAttribute;
                return true;
            }
        }
        MetaData attr = metaData;
        return true;
    }

    private final String zPath$lzyINIT1$1(LazyRef zPath$lzy1$1, scala.collection.immutable.Seq parentPathSteps$1) {
        String string;
        LazyRef lazyRef = zPath$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(zPath$lzy1$1.initialized() ? zPath$lzy1$1.value() : zPath$lzy1$1.initialize((Object)((IterableOnceOps)parentPathSteps$1.reverse()).mkString("/")));
        }
        return string;
    }

    private final String zPath$1(LazyRef zPath$lzy1$2, scala.collection.immutable.Seq parentPathSteps$2) {
        return (String)(zPath$lzy1$2.initialized() ? zPath$lzy1$2.value() : this.zPath$lzyINIT1$1(zPath$lzy1$2, parentPathSteps$2));
    }

    private static final String $anonfun$17$$anonfun$1() {
        return null;
    }

    private static final String $anonfun$17(Option typeB$1) {
        return (String)typeB$1.getOrElse(XMLUtils$::$anonfun$17$$anonfun$1);
    }

    private static final String computeDiffOne$$anonfun$2() {
        return "";
    }

    private static final String computeDiffOne$$anonfun$4() {
        return "";
    }

    private static final String computeDiffOne$$anonfun$6() {
        return "";
    }

    private static final String computeDiffOne$$anonfun$8() {
        return "";
    }

    private static final /* synthetic */ String $anonfun$18(int _$41) {
        return "[" + _$41 + "]";
    }

    private static final String $anonfun$19() {
        return "";
    }

    private static final boolean $anonfun$30() {
        return false;
    }

    private static final boolean $anonfun$32() {
        return false;
    }

    private static final /* synthetic */ boolean $anonfun$34(String _$46) {
        return _$46.startsWith("file://");
    }

    private final Option $anonfun$36(URI uri$3) {
        URL resource = this.getClass().getResource(uri$3.getPath());
        if (resource != null) {
            URISchemaSource uss = URISchemaSource$.MODULE$.apply(new File(uri$3.getPath()), resource.toURI());
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)uss, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }
        return None$.MODULE$;
    }

    private static final Option $anonfun$37(URI uri$4) {
        File file = Paths.get(uri$4.getPath(), new String[0]).toFile();
        if (file.exists()) {
            URISchemaSource uss = URISchemaSource$.MODULE$.apply(file, file.toURI());
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)uss, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }
        return None$.MODULE$;
    }

    private static final Option $anonfun$38(URI uri$5, DaffodilSchemaSource contextURI$1) {
        Option relativeURI = Misc$.MODULE$.getResourceRelativeOnlyOption(uri$5.getPath(), contextURI$1.uriForLoading()).map((Function1 & Serializable)u -> {
            File contextURIDiagnosticFile = contextURI$1.diagnosticFile();
            File relativeDiagnosticFile = contextURIDiagnosticFile.toPath().resolveSibling(Paths.get(uri$5.getPath(), new String[0])).normalize().toFile();
            return Tuple2$.MODULE$.apply((Object)URISchemaSource$.MODULE$.apply(relativeDiagnosticFile, (URI)u), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        });
        return relativeURI;
    }

    private final Option $anonfun$40(URI uri$7) {
        String uriPath = "/" + uri$7.getPath();
        Option pair = Option$.MODULE$.apply((Object)this.getClass().getResource(uriPath)).map((Function1 & Serializable)r -> URISchemaSource$.MODULE$.apply(new File(uriPath), r.toURI())).map((Function1 & Serializable)_$47 -> Tuple2$.MODULE$.apply(_$47, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
        return pair;
    }
}

