/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.text.translate.SinglePassTranslator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SinglePassTranslatorTest {
    private final SinglePassTranslator dummyTranslator = new SinglePassTranslator(){

        void translateWhole(CharSequence input, Writer writer) throws IOException {
        }
    };
    private StringWriter out;

    SinglePassTranslatorTest() {
    }

    @BeforeEach
    public void before() {
        this.out = new StringWriter();
    }

    @Test
    void testCodePointsAreReturned() throws Exception {
        Assertions.assertEquals((int)0, (int)this.dummyTranslator.translate((CharSequence)"", 0, (Writer)this.out));
        Assertions.assertEquals((int)3, (int)this.dummyTranslator.translate((CharSequence)"abc", 0, (Writer)this.out));
        Assertions.assertEquals((int)7, (int)this.dummyTranslator.translate((CharSequence)"abcdefg", 0, (Writer)this.out));
    }

    @Test
    void testIndexIsValidated() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.dummyTranslator.translate((CharSequence)"abc", 1, (Writer)this.out));
    }

    @Test
    void testTranslateThrowsIllegalArgumentException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.dummyTranslator.translate((CharSequence)"(,Fk", 647, null));
    }
}

