/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.stream.Stream;
import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.SplittableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.AbstractL64;
import org.apache.commons.rng.core.source64.LXMSupport;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.core.util.RandomStreams;

public class L64X1024Mix
extends AbstractL64
implements SplittableUniformRandomProvider {
    private static final int SEED_SIZE = 18;
    private static final int XBG_STATE_SIZE = 16;
    private static final int LCG_STATE_SIZE = 2;
    private static final long M = -3372029247567499371L;
    private final long[] x;
    private int index;

    public L64X1024Mix(long[] seed) {
        seed = L64X1024Mix.extendSeed(seed, 18);
        super(seed);
        this.x = new long[16];
        System.arraycopy(seed, 2, this.x, 0, 16);
        this.index = 15;
    }

    protected L64X1024Mix(L64X1024Mix source) {
        super(source);
        this.x = new long[16];
        System.arraycopy(source.x, 0, this.x, 0, 16);
        this.index = source.index;
    }

    @Override
    protected byte[] getStateInternal() {
        long[] s = new long[17];
        System.arraycopy(this.x, 0, s, 0, 16);
        s[16] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 136);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        System.arraycopy(tmp, 0, this.x, 0, 16);
        this.index = (int)tmp[16];
        super.setStateInternal(c[1]);
    }

    @Override
    public long next() {
        int q = this.index;
        this.index = q + 1 & 0xF;
        long s0 = this.x[this.index];
        long s15 = this.x[q];
        long s = this.ls;
        long z = LXMSupport.lea64(s + s0);
        this.ls = -3372029247567499371L * s + this.la;
        this.x[q] = Long.rotateLeft(s0, 25) ^ (s15 ^= s0) ^ s15 << 27;
        this.x[this.index] = Long.rotateLeft(s15, 36);
        return z;
    }

    @Override
    public UniformRandomProvider jump() {
        return super.jump();
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        return super.longJump();
    }

    @Override
    AbstractL64 copy() {
        return new L64X1024Mix(this);
    }

    public SplittableUniformRandomProvider split(UniformRandomProvider source) {
        return L64X1024Mix.create(source.nextLong(), source);
    }

    public Stream<SplittableUniformRandomProvider> splits(long streamSize, SplittableUniformRandomProvider source) {
        return RandomStreams.generateWithSeed(streamSize, source, L64X1024Mix::create);
    }

    private static SplittableUniformRandomProvider create(long seed, UniformRandomProvider source) {
        int i;
        long[] s = new long[18];
        s[0] = seed << 1;
        s[1] = source.nextLong();
        long x = 0L;
        for (i = 2; i < s.length; ++i) {
            s[i] = source.nextLong();
            x |= s[i];
        }
        if (x == 0L) {
            x = s[1];
            for (i = 2; i < s.length; ++i) {
                s[i] = LXMSupport.lea64(x);
                x += -7046029254386353131L;
            }
        }
        return new L64X1024Mix(s);
    }
}

