/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.AbstractL64;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractL64X128
extends AbstractL64 {
    protected static final long M = -3372029247567499371L;
    private static final int SEED_SIZE = 4;
    private static final int XBG_STATE_SIZE = 2;
    protected long x0;
    protected long x1;

    AbstractL64X128(long[] seed) {
        seed = AbstractL64X128.extendSeed(seed, 4);
        super(seed);
        this.x0 = seed[2];
        this.x1 = seed[3];
    }

    AbstractL64X128(long seed0, long seed1, long seed2, long seed3) {
        super(seed0, seed1);
        this.x0 = seed2;
        this.x1 = seed3;
    }

    AbstractL64X128(AbstractL64X128 source) {
        super(source);
        this.x0 = source.x0;
        this.x1 = source.x1;
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.x0, this.x1}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        this.x0 = tmp[0];
        this.x1 = tmp[1];
        super.setStateInternal(c[1]);
    }

    @Override
    public UniformRandomProvider jump() {
        return super.jump();
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        return super.longJump();
    }
}

