/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.simple.internal;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.util.NumberFactory;

final class SeedUtils {
    private static final int MOD_09 = 4;
    private static final int MOD_10 = 6;
    private static final int MOD_11 = 3;
    private static final int MOD_12 = 4;
    private static final int MOD_13 = 9;
    private static final int MOD_14 = 4;
    private static final int MOD_15 = 1;
    private static final byte[] HEX_DIGIT_ARRAY = new byte[]{15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};

    private SeedUtils() {
    }

    static int createIntHexPermutation(UniformRandomProvider rng) {
        UnsignedByteProvider provider = new UnsignedByteProvider(rng);
        return SeedUtils.createUpperBitsHexPermutation(provider);
    }

    static long createLongHexPermutation(UniformRandomProvider rng) {
        UnsignedByteProvider provider = new UnsignedByteProvider(rng);
        return NumberFactory.makeLong((int)SeedUtils.createUpperBitsHexPermutation(provider), (int)SeedUtils.createUpperBitsHexPermutation(provider));
    }

    private static int createUpperBitsHexPermutation(UnsignedByteProvider provider) {
        byte[] digits = (byte[])HEX_DIGIT_ARRAY.clone();
        int bits = SeedUtils.copyToOutput(digits, 0, 15, provider.nextUnsignedByte() & 0xF);
        bits = SeedUtils.copyToOutput(digits, bits, 14, SeedUtils.nextUnsignedByteInRange(provider, 1, 15));
        bits = SeedUtils.copyToOutput(digits, bits, 13, SeedUtils.nextUnsignedByteInRange(provider, 4, 14));
        bits = SeedUtils.copyToOutput(digits, bits, 12, SeedUtils.nextUnsignedByteInRange(provider, 9, 13));
        bits = SeedUtils.copyToOutput(digits, bits, 11, SeedUtils.nextUnsignedByteInRange(provider, 4, 12));
        bits = SeedUtils.copyToOutput(digits, bits, 10, SeedUtils.nextUnsignedByteInRange(provider, 3, 11));
        bits = SeedUtils.copyToOutput(digits, bits, 9, SeedUtils.nextUnsignedByteInRange(provider, 6, 10));
        bits = SeedUtils.copyToOutput(digits, bits, 8, SeedUtils.nextUnsignedByteInRange(provider, 4, 9));
        return bits;
    }

    private static int nextUnsignedByteInRange(UnsignedByteProvider provider, int threshold, int n) {
        int m;
        while (((m = n * provider.nextUnsignedByte()) & 0xFF) < threshold) {
        }
        return m >>> 8;
    }

    private static int copyToOutput(byte[] digits, int bits, int upper, int lower) {
        int newbits = bits << 4 | digits[lower] & 0xF;
        digits[lower] = digits[upper];
        return newbits;
    }

    private static class UnsignedByteProvider {
        private static final int MASK_2_BITS = 3;
        private static final int MASK_8_BITS = 255;
        private final UniformRandomProvider rng;
        private int bits;
        private int counter;

        UnsignedByteProvider(UniformRandomProvider rng) {
            this.rng = rng;
        }

        int nextUnsignedByte() {
            int count = this.counter & 3;
            ++this.counter;
            if (count == 0) {
                this.bits = this.rng.nextInt();
                return this.bits & 0xFF;
            }
            this.bits >>>= 8;
            return this.bits & 0xFF;
        }
    }
}

