/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.fitting.leastsquares;

import java.io.IOException;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.fitting.leastsquares.AbstractLeastSquaresOptimizerAbstractTest;
import org.apache.commons.math3.fitting.leastsquares.CircleVectorial;
import org.apache.commons.math3.fitting.leastsquares.GaussNewtonOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresOptimizer;
import org.apache.commons.math3.fitting.leastsquares.LeastSquaresProblem;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Plane;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.SimpleVectorValueChecker;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class GaussNewtonOptimizerWithSVDTest
extends AbstractLeastSquaresOptimizerAbstractTest {
    public int getMaxIterations() {
        return 1000;
    }

    public LeastSquaresOptimizer getOptimizer() {
        return new GaussNewtonOptimizer(GaussNewtonOptimizer.Decomposition.SVD);
    }

    @Test
    public void testMaxEvaluations() throws Exception {
        try {
            CircleVectorial circle = new CircleVectorial();
            circle.addPoint(30.0, 68.0);
            circle.addPoint(50.0, -6.0);
            circle.addPoint(110.0, -20.0);
            circle.addPoint(35.0, 15.0);
            circle.addPoint(45.0, 97.0);
            LeastSquaresProblem lsp = this.builder(circle).checkerPair((ConvergenceChecker)new SimpleVectorValueChecker(1.0E-30, 1.0E-30)).maxIterations(Integer.MAX_VALUE).start(new double[]{98.68, 47.345}).build();
            this.optimizer.optimize(lsp);
            this.fail(this.optimizer);
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    @Test
    public void testCircleFittingBadInit() {
        try {
            super.testCircleFittingBadInit();
            this.fail(this.optimizer);
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testHahn1() throws IOException {
        try {
            super.testHahn1();
            this.fail(this.optimizer);
        }
        catch (ConvergenceException convergenceException) {
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    @Test
    public void testGetIterations() {
        try {
            super.testGetIterations();
            this.fail(this.optimizer);
        }
        catch (TooManyEvaluationsException tooManyEvaluationsException) {
            // empty catch block
        }
    }

    @Test
    public void testNonInvertible() throws Exception {
        AbstractLeastSquaresOptimizerAbstractTest.LinearProblem problem = new AbstractLeastSquaresOptimizerAbstractTest.LinearProblem(this, new double[][]{{1.0, 2.0, -3.0}, {2.0, 1.0, 3.0}, {-3.0, 0.0, -9.0}}, new double[]{1.0, 1.0, 1.0});
        LeastSquaresOptimizer.Optimum optimum = this.optimizer.optimize(problem.getBuilder().build());
        Plane span = new Plane(Vector3D.ZERO, new Vector3D(1.0, 2.0, -3.0), new Vector3D(2.0, 1.0, 0.0), 1.0E-10);
        double expected = FastMath.abs((double)span.getOffset((Vector)new Vector3D(1.0, 1.0, 1.0)));
        double actual = optimum.getResiduals().getNorm();
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-10);
    }
}

