/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.roundtrip;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.Stream;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.common.BufferedImageFactory;
import org.apache.commons.imaging.common.RgbBufferedImageFactory;
import org.apache.commons.imaging.internal.ImageParserFactory;
import org.apache.commons.imaging.roundtrip.FormatInfo;
import org.apache.commons.imaging.roundtrip.ImageAsserts;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.provider.Arguments;

public class RoundtripBase {
    public static Stream<Arguments> createRoundtripArguments(BufferedImage[] images) {
        return Stream.of(images).flatMap(i -> Stream.of(FormatInfo.READ_WRITE_FORMATS).map(f -> Arguments.of((Object[])new Object[]{i, f})));
    }

    protected void roundtrip(FormatInfo formatInfo, BufferedImage testImage, String tempPrefix, boolean imageExact) throws IOException, ImagingException, ImagingException {
        byte[] temp1;
        AbstractImageParser abstractImageParser = ImageParserFactory.getImageParser((ImageFormat)formatInfo.format);
        ImagingParameters params = ImageParserFactory.getImageParser((ImageFormat)formatInfo.format).getDefaultParameters();
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            abstractImageParser.writeImage(testImage, (OutputStream)bos, params);
            temp1 = bos.toByteArray();
        }
        ImagingParameters readParams = ImageParserFactory.getImageParser((ImageFormat)formatInfo.format).getDefaultParameters();
        readParams.setBufferedImageFactory((BufferedImageFactory)new RgbBufferedImageFactory());
        BufferedImage image2 = abstractImageParser.getBufferedImage(temp1, readParams);
        Assertions.assertNotNull((Object)image2);
        if (imageExact) {
            ImageAsserts.assertImageEquals(testImage, image2);
        }
        if (formatInfo.identicalSecondWrite) {
            byte[] temp2;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                abstractImageParser.writeImage(image2, (OutputStream)bos, params);
                temp2 = bos.toByteArray();
            }
            Assertions.assertArrayEquals((byte[])temp1, (byte[])temp2);
        }
    }
}

