/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.iptc;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.AbstractImagingTest;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;

public abstract class AbstractIptcTest
extends AbstractImagingTest {
    private static final AbstractImagingTest.ImageFilter HAS_IPTC_IMAGE_FILTER = AbstractIptcTest::hasIptcData;
    private static final AbstractImagingTest.ImageFilter JPEG_IMAGE_FILTER = file -> file.getName().toLowerCase().endsWith(".jpg");

    protected static List<File> getImagesWithIptcData() throws IOException, ImagingException {
        return AbstractIptcTest.getTestImages(HAS_IPTC_IMAGE_FILTER);
    }

    protected static List<File> getJpegImages() throws IOException, ImagingException {
        return AbstractIptcTest.getTestImages(JPEG_IMAGE_FILTER);
    }

    protected static boolean hasIptcData(File file) {
        if (!file.getName().toLowerCase().endsWith(".jpg")) {
            return false;
        }
        try {
            ByteSource byteSource = ByteSource.file((File)file);
            return new JpegImageParser().hasIptcSegment(byteSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected List<File> getImagesWithIptcData(int max) throws IOException, ImagingException {
        return AbstractIptcTest.getTestImages(HAS_IPTC_IMAGE_FILTER, max);
    }

    protected File getImageWithIptcData() throws IOException, ImagingException {
        return this.getTestImage(HAS_IPTC_IMAGE_FILTER);
    }

    protected File getJpegImage() throws IOException, ImagingException {
        return this.getTestImage(JPEG_IMAGE_FILTER);
    }

    protected List<File> getJpegImages(int max) throws IOException, ImagingException {
        return AbstractIptcTest.getTestImages(JPEG_IMAGE_FILTER, max);
    }
}

