/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.exif.AbstractExifTest;
import org.apache.commons.imaging.formats.jpeg.exif.ExifRewriter;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.write.TiffOutputSet;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ExifRewriteTest
extends AbstractExifTest {
    private void compare(File imageFile, TiffImageMetadata oldExifMetadata, TiffImageMetadata newExifMetadata) throws ImagingException {
        Assertions.assertNotNull((Object)oldExifMetadata);
        Assertions.assertNotNull((Object)newExifMetadata);
        List oldDirectories = oldExifMetadata.getDirectories();
        List newDirectories = newExifMetadata.getDirectories();
        Assertions.assertEquals((int)oldDirectories.size(), (int)newDirectories.size());
        Map<Integer, TiffImageMetadata.Directory> oldDirectoryMap = this.makeDirectoryMap(oldDirectories);
        Map<Integer, TiffImageMetadata.Directory> newDirectoryMap = this.makeDirectoryMap(newDirectories);
        Assertions.assertEquals((int)oldDirectories.size(), (int)oldDirectoryMap.size());
        ArrayList<Integer> oldDirectoryTypes = new ArrayList<Integer>(oldDirectoryMap.keySet());
        Collections.sort(oldDirectoryTypes);
        ArrayList<Integer> newDirectoryTypes = new ArrayList<Integer>(newDirectoryMap.keySet());
        Collections.sort(newDirectoryTypes);
        Assertions.assertEquals(oldDirectoryTypes, newDirectoryTypes);
        for (Integer dirType : oldDirectoryTypes) {
            TiffImageMetadata.Directory oldDirectory = oldDirectoryMap.get(dirType);
            TiffImageMetadata.Directory newDirectory = newDirectoryMap.get(dirType);
            Assertions.assertNotNull((Object)oldDirectory);
            Assertions.assertNotNull((Object)newDirectory);
            List oldItems = oldDirectory.getItems();
            List newItems = newDirectory.getItems();
            Map<Integer, TiffField> oldFieldMap = this.makeFieldMap(oldItems);
            Map<Integer, TiffField> newFieldMap = this.makeFieldMap(newItems);
            HashSet<Integer> missingInNew = new HashSet<Integer>(oldFieldMap.keySet());
            missingInNew.removeAll(newFieldMap.keySet());
            HashSet<Integer> missingInOld = new HashSet<Integer>(newFieldMap.keySet());
            missingInOld.removeAll(oldFieldMap.keySet());
            Assertions.assertTrue((boolean)missingInNew.isEmpty());
            Assertions.assertTrue((boolean)missingInOld.isEmpty());
            Assertions.assertEquals((int)oldItems.size(), (int)oldFieldMap.size());
            Assertions.assertEquals(oldFieldMap.keySet(), newFieldMap.keySet());
            Assertions.assertEquals(oldFieldMap.keySet(), newFieldMap.keySet());
            ArrayList<Integer> oldFieldTags = new ArrayList<Integer>(oldFieldMap.keySet());
            Collections.sort(oldFieldTags);
            ArrayList<Integer> newFieldTags = new ArrayList<Integer>(newFieldMap.keySet());
            Collections.sort(newFieldTags);
            Assertions.assertEquals(oldFieldTags, newFieldTags);
            for (Integer fieldTag : oldFieldTags) {
                TiffField oldField = oldFieldMap.get(fieldTag);
                TiffField newField = newFieldMap.get(fieldTag);
                Assertions.assertNotNull((Object)oldField);
                Assertions.assertNotNull((Object)newField);
                Assertions.assertEquals((int)oldField.getTag(), (int)newField.getTag());
                Assertions.assertEquals((int)dirType, (int)newField.getDirectoryType());
                Assertions.assertEquals((int)oldField.getDirectoryType(), (int)newField.getDirectoryType());
                if (oldField.getFieldType() == AbstractFieldType.ASCII) {
                    byte[] rawBytes = oldField.getByteArrayValue();
                    boolean hasInvalidByte = false;
                    for (byte rawByte : rawBytes) {
                        if ((rawByte & 0x80) == 0) continue;
                        hasInvalidByte = true;
                        break;
                    }
                    if (hasInvalidByte) continue;
                }
                Assertions.assertEquals((long)oldField.getCount(), (long)newField.getCount());
                Assertions.assertEquals((Object)oldField.isLocalValue(), (Object)newField.isLocalValue());
                if (oldField.getTag() == 514 || oldField.getTagInfo().isOffset() || oldField.getTagInfo().isText()) continue;
                if (oldField.isLocalValue()) {
                    if (oldField.getTag() == 278 || oldField.getTag() == 279) {
                        Assertions.assertEquals((Object)oldField.getValue(), (Object)newField.getValue());
                        continue;
                    }
                    Assertions.assertEquals((int)oldField.getBytesLength(), (int)newField.getBytesLength());
                    Assertions.assertArrayEquals((byte[])oldField.getByteArrayValue(), (byte[])newField.getByteArrayValue());
                    continue;
                }
                Assertions.assertArrayEquals((byte[])oldField.getByteArrayValue(), (byte[])newField.getByteArrayValue());
            }
        }
    }

    private Map<Integer, TiffImageMetadata.Directory> makeDirectoryMap(List<? extends ImageMetadata.ImageMetadataItem> directories) {
        HashMap<Integer, TiffImageMetadata.Directory> directoryMap = new HashMap<Integer, TiffImageMetadata.Directory>();
        for (ImageMetadata.ImageMetadataItem imageMetadataItem : directories) {
            TiffImageMetadata.Directory directory = (TiffImageMetadata.Directory)imageMetadataItem;
            directoryMap.put(directory.type, directory);
        }
        return directoryMap;
    }

    private Map<Integer, TiffField> makeFieldMap(List<? extends ImageMetadata.ImageMetadataItem> items) {
        HashMap<Integer, TiffField> fieldMap = new HashMap<Integer, TiffField>();
        for (ImageMetadata.ImageMetadataItem imageMetadataItem : items) {
            TiffImageMetadata.TiffMetadataItem item = (TiffImageMetadata.TiffMetadataItem)imageMetadataItem;
            TiffField field = item.getTiffField();
            if (fieldMap.containsKey(field.getTag())) continue;
            fieldMap.put(field.getTag(), field);
        }
        return fieldMap;
    }

    private void rewrite(Rewriter rewriter, String name) throws IOException, ImagingException {
        List<File> images = ExifRewriteTest.getImagesWithExifData();
        for (File imageFile : images) {
            try {
                Debug.debug((String)"imageFile", (Object)imageFile);
                boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
                if (ignoreImageData) continue;
                ByteSource byteSource = ByteSource.file((File)imageFile);
                Debug.debug((String)"Source Segments:");
                new JpegUtils().dumpJfif(byteSource);
                JpegImageMetadata oldMetadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
                if (null == oldMetadata) continue;
                Assertions.assertNotNull((Object)oldMetadata);
                TiffImageMetadata oldExifMetadata = oldMetadata.getExif();
                if (null == oldExifMetadata) continue;
                Assertions.assertNotNull((Object)oldExifMetadata);
                oldMetadata.dump();
                TiffOutputSet outputSet = oldExifMetadata.getOutputSet();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                rewriter.rewrite(byteSource, baos, outputSet);
                byte[] bytes = baos.toByteArray();
                Debug.debug((String)"Output Segments:");
                new JpegUtils().dumpJfif(ByteSource.array((byte[])bytes));
                JpegImageMetadata newMetadata = (JpegImageMetadata)Imaging.getMetadata((InputStream)new ByteArrayInputStream(bytes), (String)(name + ".jpg"));
                Assertions.assertNotNull((Object)newMetadata);
                TiffImageMetadata newExifMetadata = newMetadata.getExif();
                Assertions.assertNotNull((Object)newExifMetadata);
                this.compare(imageFile, oldExifMetadata, newExifMetadata);
            }
            catch (IOException e) {
                Debug.debug((String)"imageFile", (Object)imageFile.getAbsoluteFile());
                Debug.debug((Throwable)e);
                throw e;
            }
        }
    }

    @Test
    public void testInsert() throws Exception {
        List<File> images = ExifRewriteTest.getImagesWithExifData();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
            if (ignoreImageData) continue;
            ByteSource byteSource = ByteSource.file((File)imageFile);
            Debug.debug((String)"Source Segments:");
            new JpegUtils().dumpJfif(byteSource);
            JpegImageMetadata originalMetadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
            Assertions.assertNotNull((Object)originalMetadata);
            TiffImageMetadata oldExifMetadata = originalMetadata.getExif();
            Assertions.assertNotNull((Object)oldExifMetadata);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ExifRewriter().removeExifMetadata(byteSource, (OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            Debug.debug((String)"Output Segments:");
            ByteSource stripped = ByteSource.array((byte[])bytes);
            new JpegUtils().dumpJfif(stripped);
            Assertions.assertFalse((boolean)ExifRewriteTest.hasExifData("removed.jpg", bytes));
            TiffOutputSet outputSet = oldExifMetadata.getOutputSet();
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
            new ExifRewriter().updateExifMetadataLossy(stripped, (OutputStream)baos2, outputSet);
            byte[] bytes2 = baos2.toByteArray();
            Debug.debug((String)"Output Segments:");
            new JpegUtils().dumpJfif(ByteSource.array((byte[])bytes2));
            JpegImageMetadata newMetadata = (JpegImageMetadata)Imaging.getMetadata((InputStream)new ByteArrayInputStream(bytes2), (String)"inserted.jpg");
            Assertions.assertNotNull((Object)newMetadata);
            TiffImageMetadata newExifMetadata = newMetadata.getExif();
            Assertions.assertNotNull((Object)newExifMetadata);
            this.compare(imageFile, oldExifMetadata, newExifMetadata);
        }
    }

    @Test
    public void testRemove() throws Exception {
        List<File> images = ExifRewriteTest.getImagesWithExifData();
        for (File imageFile : images) {
            Debug.debug((String)"imageFile", (Object)imageFile);
            boolean ignoreImageData = this.isPhilHarveyTestImage(imageFile);
            if (ignoreImageData) continue;
            ByteSource byteSource = ByteSource.file((File)imageFile);
            Debug.debug((String)"Source Segments:");
            new JpegUtils().dumpJfif(byteSource);
            JpegImageMetadata metadata = (JpegImageMetadata)Imaging.getMetadata((File)imageFile);
            Assertions.assertNotNull((Object)metadata);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ExifRewriter().removeExifMetadata(byteSource, (OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            Debug.debug((String)"Output Segments:");
            new JpegUtils().dumpJfif(ByteSource.array((byte[])bytes));
            Assertions.assertFalse((boolean)ExifRewriteTest.hasExifData("test.jpg", bytes));
        }
    }

    @Test
    public void testRewriteLossless() throws Exception {
        Rewriter rewriter = (byteSource, os, outputSet) -> new ExifRewriter().updateExifMetadataLossless(byteSource, os, outputSet);
        this.rewrite(rewriter, "lossless");
    }

    @Test
    public void testRewriteLossy() throws Exception {
        Rewriter rewriter = (byteSource, os, outputSet) -> new ExifRewriter().updateExifMetadataLossy(byteSource, os, outputSet);
        this.rewrite(rewriter, "lossy");
    }

    private static interface Rewriter {
        public void rewrite(ByteSource var1, OutputStream var2, TiffOutputSet var3) throws ImagingException, IOException, ImagingException;
    }
}

