/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.geometry.spherical.twod;

import java.util.Collection;
import java.util.List;
import org.apache.commons.geometry.spherical.twod.AbstractGreatArcConnector;
import org.apache.commons.geometry.spherical.twod.GreatArc;
import org.apache.commons.geometry.spherical.twod.GreatArcPath;
import org.apache.commons.geometry.spherical.twod.GreatCircle;

public abstract class InteriorAngleGreatArcConnector
extends AbstractGreatArcConnector {
    protected AbstractGreatArcConnector.ConnectableGreatArc selectConnection(AbstractGreatArcConnector.ConnectableGreatArc incoming, List<AbstractGreatArcConnector.ConnectableGreatArc> outgoing) {
        GreatCircle circle = incoming.getArc().getCircle();
        double selectedInteriorAngle = Double.POSITIVE_INFINITY;
        AbstractGreatArcConnector.ConnectableGreatArc selected = null;
        for (AbstractGreatArcConnector.ConnectableGreatArc candidate : outgoing) {
            double interiorAngle = Math.PI - circle.angle(candidate.getArc().getCircle(), incoming.getArc().getEndPoint());
            if (selected != null && !this.isBetterAngle(interiorAngle, selectedInteriorAngle)) continue;
            selectedInteriorAngle = interiorAngle;
            selected = candidate;
        }
        return selected;
    }

    protected abstract boolean isBetterAngle(double var1, double var3);

    public static List<GreatArcPath> connectMaximized(Collection<GreatArc> arcs) {
        return new Maximize().connectAll(arcs);
    }

    public static List<GreatArcPath> connectMinimized(Collection<GreatArc> arcs) {
        return new Minimize().connectAll(arcs);
    }

    public static class Minimize
    extends InteriorAngleGreatArcConnector {
        @Override
        protected boolean isBetterAngle(double newAngle, double previousAngle) {
            return newAngle < previousAngle;
        }
    }

    public static class Maximize
    extends InteriorAngleGreatArcConnector {
        @Override
        protected boolean isBetterAngle(double newAngle, double previousAngle) {
            return newAngle > previousAngle;
        }
    }
}

