/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.random;

import java.security.GeneralSecurityException;
import java.util.Properties;
import org.apache.commons.crypto.Crypto;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.OpenSslCryptoRandomNative;

final class OpenSslCryptoRandom
implements CryptoRandom {
    private static final boolean nativeEnabled;
    private static final Throwable initException;

    static {
        boolean opensslLoaded = false;
        Throwable except = null;
        if (Crypto.isNativeCodeLoaded()) {
            try {
                OpenSslCryptoRandomNative.initSR();
                opensslLoaded = true;
            }
            catch (Exception | UnsatisfiedLinkError e) {
                except = e;
            }
        }
        nativeEnabled = opensslLoaded;
        initException = except;
        try {
            OpenSslCryptoRandom.checkNative();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        if (!OpenSslCryptoRandomNative.nextRandBytes(new byte[1])) {
            throw new IllegalStateException("Check of nextRandBytes failed");
        }
    }

    private static void checkNative() throws GeneralSecurityException {
        if (!nativeEnabled) {
            if (initException != null) {
                throw new GeneralSecurityException("Native library could not be initialized", initException);
            }
            throw new GeneralSecurityException("Native library is not loaded");
        }
    }

    public static boolean isNativeCodeEnabled() {
        return nativeEnabled;
    }

    public OpenSslCryptoRandom(Properties props) throws GeneralSecurityException {
        OpenSslCryptoRandom.checkNative();
    }

    @Override
    public void close() {
    }

    @Override
    public void nextBytes(byte[] bytes) {
        if (!OpenSslCryptoRandomNative.nextRandBytes(bytes)) {
            throw new IllegalArgumentException("The nextRandBytes method failed");
        }
    }
}

