/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class SetColumnTypeToDb
extends AbstractToDbToken.Entity {
    private DbAttribute columnOriginal;
    private DbAttribute columnNew;

    public SetColumnTypeToDb(DbEntity entity, DbAttribute columnOriginal, DbAttribute columnNew) {
        super("Set Column Type", 60, entity);
        this.columnOriginal = columnOriginal;
        this.columnNew = columnNew;
    }

    protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(context.quotedFullyQualifiedName(this.getEntity()));
        sqlBuffer.append(" ALTER ");
        sqlBuffer.append(context.quotedName(this.columnNew));
        sqlBuffer.append(" TYPE ");
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuffer sqlBuffer = new StringBuffer();
        this.appendPrefix(sqlBuffer, adapter.getQuotingStrategy());
        sqlBuffer.append(JdbcAdapter.getType((DbAdapter)adapter, (DbAttribute)this.columnNew));
        sqlBuffer.append(JdbcAdapter.sizeAndPrecision((DbAdapter)adapter, (DbAttribute)this.columnNew));
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public String getTokenValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEntity().getName());
        sb.append(".");
        sb.append(this.columnNew.getName());
        if (this.columnOriginal.getType() != this.columnNew.getType()) {
            sb.append(" type: ");
            sb.append(TypesMapping.getSqlNameByType((int)this.columnOriginal.getType()));
            sb.append(" -> ");
            sb.append(TypesMapping.getSqlNameByType((int)this.columnNew.getType()));
        }
        if (this.columnOriginal.getMaxLength() != this.columnNew.getMaxLength()) {
            sb.append(" maxLength: ");
            sb.append(this.columnOriginal.getMaxLength());
            sb.append(" -> ");
            sb.append(this.columnNew.getMaxLength());
        }
        if (this.columnOriginal.getAttributePrecision() != this.columnNew.getAttributePrecision()) {
            sb.append(" precision: ");
            sb.append(this.columnOriginal.getAttributePrecision());
            sb.append(" -> ");
            sb.append(this.columnNew.getAttributePrecision());
        }
        if (this.columnOriginal.getScale() != this.columnNew.getScale()) {
            sb.append(" scale: ");
            sb.append(this.columnOriginal.getScale());
            sb.append(" -> ");
            sb.append(this.columnNew.getScale());
        }
        return sb.toString();
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createSetColumnTypeToModel(this.getEntity(), this.columnNew, this.columnOriginal);
    }

    public DbAttribute getColumnNew() {
        return this.columnNew;
    }

    public DbAttribute getColumnOriginal() {
        return this.columnOriginal;
    }
}

