/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.util.HashCodeBuilder;
import org.apache.cayenne.util.Util;

class ObjectIdCompound
implements ObjectId {
    private static final long serialVersionUID = -2265029098344119323L;
    protected final String entityName;
    protected final Map<String, Object> objectIdKeys;
    protected Map<String, Object> replacementIdMap;
    private transient int hashCode;

    private ObjectIdCompound() {
        this.entityName = null;
        this.objectIdKeys = Collections.emptyMap();
    }

    ObjectIdCompound(String entityName, Map<String, ?> idMap) {
        this.entityName = entityName;
        if (idMap == null || idMap.size() == 0) {
            this.objectIdKeys = Collections.emptyMap();
            return;
        }
        this.objectIdKeys = this.wrapIdMap(idMap);
    }

    private Map<String, Object> wrapIdMap(Map<String, ?> m) {
        if (m.getClass() == HashMap.class) {
            return m;
        }
        return new HashMap<String, Object>(m);
    }

    @Override
    public boolean isTemporary() {
        return false;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public byte[] getKey() {
        return null;
    }

    @Override
    public Map<String, Object> getIdSnapshot() {
        return Collections.unmodifiableMap(this.objectIdKeys);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectIdCompound)) {
            return false;
        }
        ObjectIdCompound id = (ObjectIdCompound)object;
        if (!Util.nullSafeEquals(this.entityName, id.entityName)) {
            return false;
        }
        if (id.objectIdKeys.size() != this.objectIdKeys.size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.objectIdKeys.entrySet()) {
            String entryKey = entry.getKey();
            Object entryValue = entry.getValue();
            if (!(entryValue != null || id.objectIdKeys.get(entryKey) == null && id.objectIdKeys.containsKey(entryKey))) {
                return false;
            }
            if (this.valueEquals(entryValue, id.objectIdKeys.get(entryKey))) continue;
            return false;
        }
        return true;
    }

    private boolean valueEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 instanceof Number) {
            return o2 instanceof Number && ((Number)o1).longValue() == ((Number)o2).longValue();
        }
        return Util.nullSafeEquals(o1, o2);
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        HashCodeBuilder builder = new HashCodeBuilder().append(this.entityName.hashCode());
        Object[] keys = this.objectIdKeys.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            builder.append(i);
            Object value = this.objectIdKeys.get(keys[i]);
            if (value instanceof Number) {
                builder.append(((Number)value).longValue());
                continue;
            }
            builder.append(value);
        }
        this.hashCode = builder.toHashCode();
        return this.hashCode;
    }

    @Override
    public Map<String, Object> getReplacementIdMap() {
        if (this.replacementIdMap == null) {
            this.replacementIdMap = new HashMap<String, Object>();
        }
        return this.replacementIdMap;
    }

    @Override
    public ObjectId createReplacementId() {
        if (this.replacementIdMap == null) {
            return this;
        }
        HashMap<String, Object> newIdMap = new HashMap<String, Object>(this.objectIdKeys);
        newIdMap.putAll(this.replacementIdMap);
        return ObjectId.of(this.entityName, newIdMap);
    }

    @Override
    public boolean isReplacementIdAttached() {
        return this.replacementIdMap != null && !this.replacementIdMap.isEmpty();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder().append("<ObjectId:").append(this.entityName);
        Object[] keys = this.objectIdKeys.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            buffer.append(", ").append((String)key).append("=").append(this.objectIdKeys.get(key));
        }
        return buffer.append(">").toString();
    }
}

