/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.MoreRows;
import org.apache.cassandra.db.transform.Transformation;

public final class RTBoundCloser
extends Transformation<UnfilteredRowIterator> {
    private RTBoundCloser() {
    }

    public static UnfilteredPartitionIterator close(UnfilteredPartitionIterator partitions) {
        return Transformation.apply(partitions, new RTBoundCloser());
    }

    public static UnfilteredRowIterator close(UnfilteredRowIterator partition) {
        RowsTransformation transformation = new RowsTransformation(partition);
        return Transformation.apply(MoreRows.extend(partition, transformation, partition.columns()), transformation);
    }

    @Override
    public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
        RowsTransformation transformation = new RowsTransformation(partition);
        return Transformation.apply(MoreRows.extend(partition, transformation, partition.columns()), transformation);
    }

    private static final class RowsTransformation
    extends Transformation
    implements MoreRows<UnfilteredRowIterator> {
        private final UnfilteredRowIterator partition;
        private Clustering lastRowClustering;
        private DeletionTime openMarkerDeletionTime;

        private RowsTransformation(UnfilteredRowIterator partition) {
            this.partition = partition;
        }

        @Override
        public Row applyToRow(Row row) {
            this.lastRowClustering = row.clustering();
            return row;
        }

        @Override
        public RangeTombstoneMarker applyToMarker(RangeTombstoneMarker marker) {
            this.openMarkerDeletionTime = marker.isOpen(this.partition.isReverseOrder()) ? marker.openDeletionTime(this.partition.isReverseOrder()) : null;
            this.lastRowClustering = null;
            return marker;
        }

        @Override
        public UnfilteredRowIterator moreContents() {
            if (null == this.openMarkerDeletionTime) {
                return null;
            }
            if (null == this.lastRowClustering) {
                CFMetaData metadata = this.partition.metadata();
                String message = String.format("UnfilteredRowIterator for %s.%s has an open RT bound as its last item", metadata.ksName, metadata.cfName);
                throw new IllegalStateException(message);
            }
            RangeTombstoneBoundMarker closingBound = RangeTombstoneBoundMarker.inclusiveClose(this.partition.isReverseOrder(), this.lastRowClustering.getRawValues(), this.openMarkerDeletionTime);
            return UnfilteredRowIterators.singleton(closingBound, this.partition.metadata(), this.partition.partitionKey(), this.partition.partitionLevelDeletion(), this.partition.columns(), this.partition.staticRow(), this.partition.isReverseOrder(), this.partition.stats());
        }
    }
}

