/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;

public class SerializationHelper {
    private final Flag flag;
    public final int version;
    private final ColumnFilter columnsToFetch;
    private ColumnFilter.Tester tester;
    private final Map<ByteBuffer, CFMetaData.DroppedColumn> droppedColumns;
    private CFMetaData.DroppedColumn currentDroppedComplex;

    public SerializationHelper(CFMetaData metadata, int version, Flag flag, ColumnFilter columnsToFetch) {
        this.flag = flag;
        this.version = version;
        this.columnsToFetch = columnsToFetch;
        this.droppedColumns = metadata.getDroppedColumns();
    }

    public SerializationHelper(CFMetaData metadata, int version, Flag flag) {
        this(metadata, version, flag, null);
    }

    public Columns fetchedStaticColumns(SerializationHeader header) {
        return this.columnsToFetch == null ? header.columns().statics : this.columnsToFetch.fetchedColumns().statics;
    }

    public Columns fetchedRegularColumns(SerializationHeader header) {
        return this.columnsToFetch == null ? header.columns().regulars : this.columnsToFetch.fetchedColumns().regulars;
    }

    public boolean includes(ColumnDefinition column) {
        return this.columnsToFetch == null || this.columnsToFetch.includes(column);
    }

    public boolean includes(CellPath path) {
        return path == null || this.tester == null || this.tester.includes(path);
    }

    public boolean canSkipValue(ColumnDefinition column) {
        return this.columnsToFetch != null && this.columnsToFetch.canSkipValue(column);
    }

    public boolean canSkipValue(CellPath path) {
        return path != null && this.tester != null && this.tester.canSkipValue(path);
    }

    public void startOfComplexColumn(ColumnDefinition column) {
        this.tester = this.columnsToFetch == null ? null : this.columnsToFetch.newTester(column);
        this.currentDroppedComplex = this.droppedColumns.get(column.name.bytes);
    }

    public void endOfComplexColumn() {
        this.tester = null;
    }

    public boolean isDropped(Cell cell, boolean isComplex) {
        CFMetaData.DroppedColumn dropped = isComplex ? this.currentDroppedComplex : this.droppedColumns.get(cell.column().name.bytes);
        return dropped != null && cell.timestamp() <= dropped.droppedTime;
    }

    public boolean isDroppedComplexDeletion(DeletionTime complexDeletion) {
        return this.currentDroppedComplex != null && complexDeletion.markedForDeleteAt() <= this.currentDroppedComplex.droppedTime;
    }

    public ByteBuffer maybeClearCounterValue(ByteBuffer value) {
        return this.flag == Flag.FROM_REMOTE || this.flag == Flag.LOCAL && CounterContext.instance().shouldClearLocal(value) ? CounterContext.instance().clearAllLocal(value) : value;
    }

    public static enum Flag {
        LOCAL,
        FROM_REMOTE,
        PRESERVE_SIZE;

    }
}

