/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestNetIf
extends SigarTestCase {
    public TestNetIf(String name) {
        super(name);
    }

    private void getNetIflist(Sigar sigar, boolean getStats) throws Exception {
        String[] ifNames = sigar.getNetInterfaceList();
        for (int i = 0; i < ifNames.length; ++i) {
            String name = ifNames[i];
            NetInterfaceConfig ifconfig = sigar.getNetInterfaceConfig(name);
            this.traceln("name=" + name);
            this.assertTrueTrace("Address", ifconfig.getAddress());
            this.assertTrueTrace("Netmask", ifconfig.getNetmask());
            if (!getStats) continue;
            if ((ifconfig.getFlags() & 1L) <= 0L) {
                this.traceln("!IFF_UP...skipping getNetInterfaceStat");
                continue;
            }
            try {
                NetInterfaceStat ifstat = sigar.getNetInterfaceStat(name);
                this.assertGtEqZeroTrace("RxPackets", ifstat.getRxPackets());
                this.assertGtEqZeroTrace("TxPackets", ifstat.getTxPackets());
                this.traceMethods(ifstat);
                continue;
            }
            catch (SigarNotImplementedException e) {
                continue;
            }
            catch (SigarException e) {
                if (name.indexOf(58) != -1) continue;
                TestNetIf.fail((String)("getNetInterfaceStat(" + name + "): " + e.getMessage()));
            }
        }
    }

    private void getGarbage(Sigar sigar) {
        try {
            this.traceln("testing bogus getNetInterfaceStat");
            sigar.getNetInterfaceStat("were switching to night vision");
            TestNetIf.fail((String)"switched to night vision");
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this.traceln("testing bogus getNetInterfaceConfig");
            sigar.getNetInterfaceConfig("happy meal");
            TestNetIf.fail((String)"unexpected treat in happy meal");
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
    }

    public void testCreate() throws Exception {
        Sigar sigar = this.getSigar();
        this.getNetIflist(sigar, false);
        this.getNetIflist(sigar, false);
        this.getNetIflist(sigar, true);
        this.traceln("Default IP=" + sigar.getNetInterfaceConfig().getAddress());
        this.getGarbage(sigar);
    }
}

