/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;

abstract class OptionMulti
extends Option {
    private static final Pattern ARGS = Pattern.compile("([^,]+)", 2);
    private final String name;
    private final Pattern pattern;
    private final String description;
    private final Delegate delegate = new Delegate();
    private final CollectAsMap collectAsMap;

    protected abstract List<? extends Option> options();

    public Map<String, String> extraOptions() {
        return this.collectAsMap == null ? new HashMap() : this.collectAsMap.options;
    }

    public OptionMulti(String name, String description, boolean collectExtraOptionsInMap) {
        this.name = name;
        this.pattern = Pattern.compile(name + "\\((.*)\\)", 2);
        this.description = description;
        this.collectAsMap = collectExtraOptionsInMap ? new CollectAsMap() : null;
    }

    @Override
    public boolean accept(String param) {
        Matcher m = this.pattern.matcher(param);
        if (!m.matches()) {
            return false;
        }
        m = ARGS.matcher(m.group(1));
        int last = -1;
        while (m.find()) {
            if (m.start() != last + 1) {
                throw new IllegalArgumentException("Invalid " + this.name + " specification: " + param);
            }
            last = m.end();
            if (this.delegate.accept(m.group())) continue;
            throw new IllegalArgumentException("Invalid " + this.name + " specification: " + m.group());
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        for (Option option : this.delegate.options()) {
            sb.append(option);
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String shortDisplay() {
        return (this.happy() ? "[" : "") + this.name + "(?)" + (this.happy() ? "]" : "");
    }

    @Override
    public String longDisplay() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append("(");
        for (Option option : this.delegate.options()) {
            sb.append(option.shortDisplay());
        }
        sb.append("): ");
        sb.append(this.description);
        return sb.toString();
    }

    @Override
    public List<String> multiLineDisplay() {
        ArrayList<String> r = new ArrayList<String>();
        for (Option option : this.options()) {
            r.add(option.longDisplay());
        }
        return r;
    }

    @Override
    boolean happy() {
        return this.delegate.happy();
    }

    List<Option> optionsSetByUser() {
        ArrayList<Option> r = new ArrayList<Option>();
        for (Option option : this.delegate.options()) {
            if (!option.setByUser()) continue;
            r.add(option);
        }
        return r;
    }

    List<Option> defaultOptions() {
        ArrayList<Option> r = new ArrayList<Option>();
        for (Option option : this.delegate.options()) {
            if (option.setByUser() || !option.present()) continue;
            r.add(option);
        }
        return r;
    }

    @Override
    boolean setByUser() {
        for (Option option : this.delegate.options()) {
            if (!option.setByUser()) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean present() {
        for (Option option : this.delegate.options()) {
            if (!option.present()) continue;
            return true;
        }
        return false;
    }

    private static final class CollectAsMap
    extends Option {
        static final String description = "Extra options";
        Map<String, String> options = new LinkedHashMap<String, String>();

        private CollectAsMap() {
        }

        @Override
        boolean accept(String param) {
            String[] args = param.split("=");
            if (args.length == 2 && args[1].length() > 0 && args[0].length() > 0) {
                if (this.options.put(args[0], args[1]) != null) {
                    throw new IllegalArgumentException(args[0] + " set twice");
                }
                return true;
            }
            return false;
        }

        @Override
        boolean happy() {
            return true;
        }

        @Override
        String shortDisplay() {
            return "[<option 1..N>=?]";
        }

        @Override
        String longDisplay() {
            return GroupedOptions.formatLong(this.shortDisplay(), description);
        }

        @Override
        List<String> multiLineDisplay() {
            return Collections.emptyList();
        }

        @Override
        boolean setByUser() {
            return !this.options.isEmpty();
        }

        @Override
        boolean present() {
            return !this.options.isEmpty();
        }
    }

    private final class Delegate
    extends GroupedOptions {
        private Delegate() {
        }

        @Override
        public List<? extends Option> options() {
            if (OptionMulti.this.collectAsMap == null) {
                return OptionMulti.this.options();
            }
            ArrayList<? extends Option> options = new ArrayList<Option>(OptionMulti.this.options());
            options.add(OptionMulti.this.collectAsMap);
            return options;
        }
    }
}

