/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.generate.values;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.MurmurHash;

public class GeneratorConfig
implements Serializable {
    public final long salt;
    private final DistributionFactory clusteringDistributions;
    private final DistributionFactory sizeDistributions;
    private final DistributionFactory identityDistributions;

    public GeneratorConfig(String seedStr, DistributionFactory clusteringDistributions, DistributionFactory sizeDistributions, DistributionFactory identityDistributions) {
        this.clusteringDistributions = clusteringDistributions;
        this.sizeDistributions = sizeDistributions;
        this.identityDistributions = identityDistributions;
        ByteBuffer buf = ByteBufferUtil.bytes((String)seedStr);
        long[] hash = new long[2];
        MurmurHash.hash3_x64_128((ByteBuffer)buf, (int)buf.position(), (int)buf.remaining(), (long)0L, (long[])hash);
        this.salt = hash[0];
    }

    Distribution getClusteringDistribution(DistributionFactory deflt) {
        return (this.clusteringDistributions == null ? deflt : this.clusteringDistributions).get();
    }

    Distribution getIdentityDistribution(DistributionFactory deflt) {
        return (this.identityDistributions == null ? deflt : this.identityDistributions).get();
    }

    Distribution getSizeDistribution(DistributionFactory deflt) {
        return (this.sizeDistributions == null ? deflt : this.sizeDistributions).get();
    }
}

