/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
*/

/**************************************************************************************
 **  DO NOT modify this script, as your changes will likely be overwritten.
 **  Auto-generated by Brooklyn on 1970-01-01 00:00:00 UTC
 **************************************************************************************/


/* Returns the approximate distance (in km) between 2 points on the Earth's surface,
 * specified as latitude and longitude in decimal degrees. Derived from the spherical
 * law of cosines.
 */
function distanceBetween($lat1_deg, $long1_deg, $lat2_deg, $long2_deg) {
    define("RADIUS_KM", 6372.8); // approx
    $lat1_rad = deg2rad($lat1_deg);
    $lat2_rad = deg2rad($lat2_deg);
    $long_delta_rad = deg2rad($long1_deg - $long2_deg);
    $distance_km = RADIUS_KM * acos( (sin($lat1_rad) * sin($lat2_rad)) +
                                     (cos($lat1_rad) * cos($lat2_rad) * cos($long_delta_rad)) );
    return $distance_km;
}

function findClosestHost($lat_deg, $long_deg, $available_hosts) {
    $minimum_distance = PHP_INT_MAX;
    for ($i = 0 ; $i < sizeof($available_hosts); $i++) {
        $host = $available_hosts[$i];
        $distance_km = distanceBetween($lat_deg, $long_deg, $host['latitude'], $host['longitude']);
        if ($distance_km < $minimum_distance) {
            $minimum_distance = $distance_km;
            $closest_host = $host;
        }
    }
    return $closest_host;
}


$hosts = array(
    array('name'      => 'Server 1',
          'latitude'  => 40.0,
          'longitude' => -80.0,
          'ip'        => '1.2.3.100'),

    array('name'      => 'Server 2',
          'latitude'  => 30.0,
          'longitude' => 20.0,
          'ip'        => '1.2.3.101')
);


$closest_host = findClosestHost($city_info['latitude'], $city_info['longitude'], $hosts);

if (isset($closest_host)) {
    $output[] = array("TXT", "Request from [".$city_info['latitude'].",".$city_info['longitude']."]-".$city_info['city']."(".strtoupper($city_info['country']).") directed to ".$closest_host['name']);
    $output[] = array("TXT", "GeoScaling config auto-updated by Brooklyn 1970-01-01 00:00:00 UTC");
    if (filter_var($closest_host['ip'], FILTER_VALIDATE_IP)) {
        $output[] = array("A", $closest_host['ip']);
    } else {
        $output[] = array("CNAME", $closest_host['ip']);
    }
} else {
    $output[] = array("fail");
}
