/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.brooklyn.rest.domain.CatalogLocationSummary;
import org.apache.brooklyn.rest.domain.HasId;
import org.apache.brooklyn.rest.domain.HasName;
import org.apache.brooklyn.rest.domain.LocationSpec;

public class LocationSummary
extends LocationSpec
implements HasName,
HasId {
    private static final long serialVersionUID = -4559153719273573670L;
    private final String id;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final String type;
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    private final CatalogLocationSummary catalog;
    private final Map<String, URI> links;

    public LocationSummary(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="spec") String spec, @JsonProperty(value="type") String type, @JsonProperty(value="config") @Nullable Map<String, ?> config, @JsonProperty(value="catalog") @Nullable CatalogLocationSummary catalog, @JsonProperty(value="links") Map<String, URI> links) {
        super(name, spec, config);
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.type = type;
        this.catalog = catalog;
        this.links = links == null ? ImmutableMap.of() : ImmutableMap.copyOf(links);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public CatalogLocationSummary getCatalog() {
        return this.catalog;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocationSummary)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocationSummary that = (LocationSummary)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.type, that.type) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.links, that.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id, this.type, this.catalog, this.links);
    }

    @Override
    public String toString() {
        return "LocationSummary{id='" + this.id + '\'' + ", type='" + this.type + '\'' + ", catalog='" + this.catalog + '\'' + ", links=" + this.links + '}';
    }
}

