/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.AbstractHttpConnection;

public class HttpInput
extends ServletInputStream {
    protected final AbstractHttpConnection _connection;
    protected final HttpParser _parser;

    public HttpInput(AbstractHttpConnection connection) {
        this._connection = connection;
        this._parser = (HttpParser)connection.getParser();
    }

    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int read = this.read(bytes, 0, 1);
        return read < 0 ? -1 : 0xFF & bytes[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int l = -1;
        Buffer content = this._parser.blockForContent(this._connection.getMaxIdleTime());
        if (content != null) {
            l = content.get(b, off, len);
        } else if (this._connection.isEarlyEOF()) {
            throw new EofException("early EOF");
        }
        return l;
    }

    public int available() throws IOException {
        return this._parser.available();
    }
}

