/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Region;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/regions")
@Consumes(value={"application/json"})
public interface RegionApi {
    @Named(value="Regions:get")
    @GET
    @Path(value="/{region}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Region get(@PathParam(value="region") String var1);

    @Named(value="Regions:list")
    @GET
    public ListPage<Region> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Regions:list")
    @GET
    @Transform(value=RegionPages.class)
    public Iterator<ListPage<Region>> list();

    @Named(value="Regions:list")
    @GET
    @Transform(value=RegionPages.class)
    public Iterator<ListPage<Region>> list(ListOptions var1);

    public static final class RegionPages
    extends BaseToIteratorOfListPage<Region, RegionPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        RegionPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Region>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Region>>(){

                public ListPage<Region> apply(String pageToken) {
                    return RegionPages.this.api.regions().listPage(pageToken, options);
                }
            };
        }
    }
}

