/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.entity.trait;

import java.util.Collection;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.annotation.EffectorParam;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.effector.MethodEffector;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.task.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Startable {
    public static final AttributeSensor<Boolean> SERVICE_UP = Attributes.SERVICE_UP;
    public static final Effector<Void> START = Effectors.effector(new MethodEffector(Startable.class, "start")).parameter(StartEffectorBody.LOCATIONS).impl(new StartEffectorBody()).build();
    public static final Effector<Void> STOP = Effectors.effector(new MethodEffector(Startable.class, "stop")).impl(new StopEffectorBody()).build();
    public static final Effector<Void> RESTART = Effectors.effector(new MethodEffector(Startable.class, "restart")).impl(new RestartEffectorBody()).build();

    @org.apache.brooklyn.core.annotation.Effector(description="Start the process/service represented by an entity")
    public void start(@EffectorParam(name="locations") Collection<? extends Location> var1);

    @org.apache.brooklyn.core.annotation.Effector(description="Stop the process/service represented by an entity")
    public void stop();

    @org.apache.brooklyn.core.annotation.Effector(description="Restart the process/service represented by an entity")
    public void restart();

    public static class RestartEffectorBody
    extends EffectorBody<Void> {
        private static final Logger log = LoggerFactory.getLogger(Startable.class);

        @Override
        public Void call(ConfigBag parameters) {
            if (!parameters.isEmpty()) {
                log.warn("Parameters " + parameters + " not supported for call to " + this.entity() + " - " + Tasks.current());
            }
            return (Void)new MethodEffector(Startable.class, "restart").call((Entity)this.entity(), parameters.getAllConfig());
        }
    }

    public static class StopEffectorBody
    extends EffectorBody<Void> {
        private static final Logger log = LoggerFactory.getLogger(Startable.class);

        @Override
        public Void call(ConfigBag parameters) {
            if (!parameters.isEmpty()) {
                log.warn("Parameters " + parameters + " not supported for call to " + this.entity() + " - " + Tasks.current());
            }
            return (Void)new MethodEffector(Startable.class, "stop").call((Entity)this.entity(), parameters.getAllConfig());
        }
    }

    public static class StartEffectorBody
    extends EffectorBody<Void> {
        public static final ConfigKey<Object> LOCATIONS = ConfigKeys.newConfigKey(Object.class, "locations", "The location or locations to start in, as a string, a location object, a list of strings, or a list of location objects");

        @Override
        public Void call(ConfigBag parameters) {
            parameters.put(LOCATIONS, this.entity().getManagementContext().getLocationRegistry().getListOfLocationsManaged(parameters.get(LOCATIONS)));
            return (Void)new MethodEffector(Startable.class, "start").call((Entity)this.entity(), parameters.getAllConfig());
        }
    }
}

