/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.catalog.internal;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.api.catalog.BrooklynCatalog;
import org.apache.brooklyn.api.catalog.CatalogItem;
import org.apache.brooklyn.api.entity.EntitySpec;
import org.apache.brooklyn.api.internal.AbstractBrooklynObjectSpec;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.ha.ManagementNodeState;
import org.apache.brooklyn.api.mgmt.rebind.RebindExceptionHandler;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.BrooklynObjectType;
import org.apache.brooklyn.api.typereg.BrooklynTypeRegistry;
import org.apache.brooklyn.api.typereg.ManagedBundle;
import org.apache.brooklyn.api.typereg.RegisteredType;
import org.apache.brooklyn.core.catalog.internal.BasicBrooklynCatalog;
import org.apache.brooklyn.core.catalog.internal.CatalogUpgradeScanner;
import org.apache.brooklyn.core.mgmt.ManagementContextInjectable;
import org.apache.brooklyn.core.mgmt.ha.OsgiBundleInstallationResult;
import org.apache.brooklyn.core.mgmt.ha.OsgiManager;
import org.apache.brooklyn.core.mgmt.internal.ManagementContextInternal;
import org.apache.brooklyn.core.mgmt.rebind.RebindManagerImpl;
import org.apache.brooklyn.core.objs.BrooklynTypes;
import org.apache.brooklyn.core.server.BrooklynServerConfig;
import org.apache.brooklyn.core.typereg.BundleUpgradeParser;
import org.apache.brooklyn.core.typereg.RegisteredTypePredicates;
import org.apache.brooklyn.core.typereg.RegisteredTypes;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.ResourceUtils;
import org.apache.brooklyn.util.exceptions.Exceptions;
import org.apache.brooklyn.util.exceptions.FatalRuntimeException;
import org.apache.brooklyn.util.exceptions.PropagatedRuntimeException;
import org.apache.brooklyn.util.exceptions.RuntimeInterruptedException;
import org.apache.brooklyn.util.exceptions.UserFacingException;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.javalang.JavaClassNames;
import org.apache.brooklyn.util.os.Os;
import org.apache.brooklyn.util.osgi.VersionedName;
import org.apache.brooklyn.util.text.Strings;
import org.apache.brooklyn.util.time.Duration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CatalogInitialization
implements ManagementContextInjectable {
    private static final Logger log = LoggerFactory.getLogger(CatalogInitialization.class);
    private String initialUri;
    private boolean hasRunInitialCatalogInitialization = false;
    private boolean hasRunPersistenceInitialization = false;
    private boolean hasRunFinalInitialization = false;
    private ManagementContextInternal managementContext;
    private CatalogUpgradeScanner catalogUpgradeScanner;
    private boolean isStartingUp = false;
    private boolean failOnStartupErrors = false;
    private boolean isPopulatingInitial = false;
    private final Object populatingCatalogMutex = new Object();

    public CatalogInitialization() {
        this(null);
    }

    public CatalogInitialization(String initialUri) {
        this.initialUri = initialUri;
    }

    @Override
    public void setManagementContext(ManagementContext managementContext) {
        Preconditions.checkNotNull((Object)managementContext, (Object)"management context");
        if (this.managementContext != null && managementContext != this.managementContext) {
            throw new IllegalStateException("Cannot switch management context, from " + this.managementContext + " to " + managementContext);
        }
        this.managementContext = (ManagementContextInternal)managementContext;
        this.catalogUpgradeScanner = new CatalogUpgradeScanner(this.managementContext, BundleUpgradeParser::parseBundleManifestForCatalogUpgrades, RegisteredTypePredicates::containingBundle, RegisteredTypePredicates::containingBundle);
    }

    public void setStartingUp(boolean isStartingUp) {
        this.isStartingUp = isStartingUp;
    }

    public void setFailOnStartupErrors(boolean startupFailOnCatalogErrors) {
        this.failOnStartupErrors = startupFailOnCatalogErrors;
    }

    public ManagementContextInternal getManagementContext() {
        return (ManagementContextInternal)Preconditions.checkNotNull((Object)this.managementContext, (Object)("management context has not been injected into " + this));
    }

    private boolean hasRunFinalInitialization() {
        return this.hasRunFinalInitialization;
    }

    private boolean hasRunInitialCatalogInitialization() {
        return this.hasRunFinalInitialization || this.hasRunInitialCatalogInitialization;
    }

    private boolean hasRunPersistenceInitialization() {
        return this.hasRunFinalInitialization || this.hasRunPersistenceInitialization;
    }

    @VisibleForTesting
    @Beta
    public boolean hasRunAnyInitialization() {
        return this.hasRunFinalInitialization || this.hasRunInitialCatalogInitialization || this.hasRunPersistenceInitialization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateInitialCatalogOnly() {
        if (log.isDebugEnabled()) {
            log.debug("Populating only the initial catalog; from " + JavaClassNames.callerNiceClassAndMethod((int)1));
        }
        Object object = this.populatingCatalogMutex;
        synchronized (object) {
            if (this.hasRunInitialCatalogInitialization()) {
                throw new IllegalStateException("Catalog initialization called to populate only initial, even though it has already run it");
            }
            this.populateInitialCatalogImpl(true);
            this.onFinalCatalog();
        }
    }

    public void clearBrooklynManagedBundles() {
        Maybe<OsgiManager> osgiManager = this.managementContext.getOsgiManager();
        if (osgiManager.isPresent()) {
            ((OsgiManager)osgiManager.get()).clearManagedBundles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateInitialAndPersistedCatalog(ManagementNodeState mode, PersistedCatalogState persistedState, RebindExceptionHandler exceptionHandler, RebindLogger rebindLogger) {
        if (log.isDebugEnabled()) {
            String message = "Add persisted catalog for " + mode + ", persistedBundles=" + persistedState.getBundles().size() + ", legacyItems=" + persistedState.getLegacyCatalogItems().size() + "; from " + JavaClassNames.callerNiceClassAndMethod((int)1);
            if (!ManagementNodeState.isHotProxy((ManagementNodeState)mode)) {
                log.debug(message);
            } else {
                log.trace(message);
            }
        }
        Object object = this.populatingCatalogMutex;
        synchronized (object) {
            if (this.hasRunFinalInitialization()) {
                log.warn("Catalog initialization called to add persisted catalog, even though it has already run the final 'master' initialization; mode=" + mode + " (perhaps previously demoted from master?)");
                this.hasRunFinalInitialization = false;
            }
            if (this.hasRunPersistenceInitialization()) {
                if (log.isDebugEnabled()) {
                    String message = "Catalog initialization repeated call to add persisted catalog, resetting catalog (including initial) to start from clean slate; mode=" + mode;
                    if (!ManagementNodeState.isHotProxy((ManagementNodeState)mode)) {
                        log.debug(message);
                    } else {
                        log.trace(message);
                    }
                }
            } else if (this.hasRunInitialCatalogInitialization()) {
                throw new IllegalStateException("Catalog initialization already run for initial catalog by mechanism other than populating persisted state; mode=" + mode);
            }
            this.populateInitialCatalogImpl(true);
            Maybe<OsgiManager> maybesOsgiManager = this.managementContext.getOsgiManager();
            if (maybesOsgiManager.isAbsent()) {
                BundleUpgradeParser.CatalogUpgrades.storeInManagementContext(BundleUpgradeParser.CatalogUpgrades.EMPTY, this.managementContext);
            } else {
                OsgiManager osgiManager = (OsgiManager)maybesOsgiManager.get();
                BundleContext bundleContext = osgiManager.getFramework().getBundleContext();
                BundleUpgradeParser.CatalogUpgrades catalogUpgrades = this.catalogUpgradeScanner.scan(osgiManager, bundleContext, rebindLogger);
                BundleUpgradeParser.CatalogUpgrades.storeInManagementContext(catalogUpgrades, this.managementContext);
            }
            PersistedCatalogState filteredPersistedState = this.filterBundlesAndCatalogInPersistedState(persistedState, rebindLogger);
            this.addPersistedCatalogImpl(filteredPersistedState, exceptionHandler, rebindLogger);
            if (mode == ManagementNodeState.MASTER) {
                this.onFinalCatalog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Beta
    public void unofficialPopulateInitialCatalog() {
        if (log.isDebugEnabled()) {
            log.debug("Unofficially populate initial catalog; should be used only by tests! Called from " + JavaClassNames.callerNiceClassAndMethod((int)1));
        }
        Object object = this.populatingCatalogMutex;
        synchronized (object) {
            if (this.hasRunInitialCatalogInitialization()) {
                return;
            }
            this.populateInitialCatalogImpl(true);
        }
    }

    public void handleException(Throwable throwable, Object details) {
        if (throwable instanceof InterruptedException) {
            throw new RuntimeInterruptedException((InterruptedException)throwable);
        }
        if (throwable instanceof RuntimeInterruptedException) {
            throw (RuntimeInterruptedException)throwable;
        }
        if (details instanceof CatalogItem && ((CatalogItem)details).getCatalogItemId() != null) {
            details = ((CatalogItem)details).getCatalogItemId();
        }
        PropagatedRuntimeException wrap = new PropagatedRuntimeException("Error loading catalog item " + details, throwable);
        log.warn(Exceptions.collapseText((Throwable)wrap));
        log.debug("Trace for: " + wrap, (Throwable)wrap);
        this.getManagementContext().errors().add((Throwable)wrap);
        if (this.isStartingUp && this.failOnStartupErrors) {
            throw new FatalRuntimeException("Unable to load catalog item " + details, (Throwable)wrap);
        }
    }

    private void confirmCatalog() {
        Stopwatch time = Stopwatch.createStarted();
        Iterable all = this.getManagementContext().getTypeRegistry().getAll();
        int errors = 0;
        for (RegisteredType rt : all) {
            if (RegisteredTypes.isTemplate(rt) || rt.getKind() != BrooklynTypeRegistry.RegisteredTypeKind.UNRESOLVED) continue;
            ++errors;
            this.handleException((Throwable)new UserFacingException("Unresolved type in catalog"), rt);
        }
        BrooklynCatalog catalog = this.getManagementContext().getCatalog();
        Iterable items = catalog.getCatalogItemsLegacy();
        for (CatalogItem item : items) {
            try {
                if (item.getCatalogItemType() == CatalogItem.CatalogItemType.TEMPLATE) continue;
                AbstractBrooklynObjectSpec spec = catalog.peekSpec(item);
                if (spec instanceof EntitySpec) {
                    BrooklynTypes.getDefinedEntityType(((EntitySpec)spec).getType());
                }
                log.debug("Catalog loaded spec " + spec + " for item " + item);
            }
            catch (Throwable throwable) {
                this.handleException(throwable, item);
            }
        }
        log.debug("Catalog (size " + Iterables.size((Iterable)all) + ", of which " + Iterables.size((Iterable)items) + " legacy) confirmed in " + Duration.of((Object)time) + (errors > 0 ? ", errors found (" + errors + ")" : ""));
    }

    private void populateInitialCatalogImpl(boolean reset) {
        assert (Thread.holdsLock(this.populatingCatalogMutex));
        if (this.isPopulatingInitial) {
            return;
        }
        this.isPopulatingInitial = true;
        try {
            BasicBrooklynCatalog catalog = (BasicBrooklynCatalog)this.managementContext.getCatalog();
            if (!catalog.getCatalog().isLoaded()) {
                catalog.load();
            } else if (reset) {
                catalog.reset((Collection<CatalogItem<?, ?>>)ImmutableList.of());
            }
            this.populateViaInitialBomImpl(catalog);
        }
        catch (Throwable e) {
            if (!Thread.currentThread().isInterrupted() && !CatalogInitialization.isRebindReadOnlyShuttingDown(this.getManagementContext())) {
                log.warn("Error populating catalog (rethrowing): " + e, e);
            }
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            this.isPopulatingInitial = false;
            this.hasRunInitialCatalogInitialization = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPersistedCatalogImpl(PersistedCatalogState persistedState, RebindExceptionHandler exceptionHandler, RebindLogger rebindLogger) {
        assert (Thread.holdsLock(this.populatingCatalogMutex));
        try {
            this.installPersistedBundles(persistedState.getBundles(), exceptionHandler, rebindLogger);
            BrooklynCatalog catalog = this.managementContext.getCatalog();
            catalog.addCatalogLegacyItemsOnRebind(persistedState.getLegacyCatalogItems());
        }
        finally {
            this.hasRunPersistenceInitialization = true;
        }
    }

    private void onFinalCatalog() {
        assert (Thread.holdsLock(this.populatingCatalogMutex));
        this.hasRunFinalInitialization = true;
        this.confirmCatalog();
    }

    private void populateViaInitialBomImpl(BasicBrooklynCatalog catalog) {
        if (this.initialUri != null) {
            this.populateInitialFromUri(catalog, this.initialUri);
            return;
        }
        String catalogUrl = (String)this.managementContext.getConfig().getConfig(BrooklynServerConfig.BROOKLYN_CATALOG_URL);
        if (Strings.isNonBlank((CharSequence)catalogUrl)) {
            this.populateInitialFromUri(catalog, catalogUrl);
            return;
        }
        catalogUrl = Os.mergePaths((String[])new String[]{BrooklynServerConfig.getMgmtBaseDir(this.managementContext.getConfig()), "catalog.bom"});
        if (new File(catalogUrl).exists()) {
            this.populateInitialFromUri(catalog, new File(catalogUrl).toURI().toString());
            return;
        }
        catalogUrl = "classpath:/brooklyn/default.catalog.bom";
        if (new ResourceUtils(this).doesUrlExist(catalogUrl)) {
            this.populateInitialFromUri(catalog, catalogUrl);
            return;
        }
        log.info("No catalog found on classpath or specified; catalog will not be initialized.");
    }

    private void populateInitialFromUri(BasicBrooklynCatalog catalog, String catalogUrl) {
        log.debug("Loading initial catalog from {}", (Object)catalogUrl);
        try {
            String contents = new ResourceUtils(this).getResourceAsString(catalogUrl);
            catalog.reset((Collection<CatalogItem<?, ?>>)MutableList.of());
            Iterable result = catalog.addItems(contents);
            log.debug("Loaded initial catalog from {}: {}", (Object)catalogUrl, (Object)result);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (CatalogInitialization.isRebindReadOnlyShuttingDown(this.getManagementContext())) {
                throw Exceptions.propagate((Throwable)e);
            }
            log.warn("Error importing catalog from " + catalogUrl + ": " + e, (Throwable)e);
        }
    }

    @Beta
    public static boolean isRebindReadOnlyShuttingDown(ManagementContext mgmt) {
        return mgmt != null && mgmt.getRebindManager() instanceof RebindManagerImpl && ((RebindManagerImpl)mgmt.getRebindManager()).isReadOnlyStopping();
    }

    private void installPersistedBundles(Map<VersionedName, InstallableManagedBundle> bundles, RebindExceptionHandler exceptionHandler, RebindLogger rebindLogger) {
        MutableMap installs = MutableMap.of();
        for (Map.Entry<VersionedName, InstallableManagedBundle> entry : bundles.entrySet()) {
            VersionedName versionedName = entry.getKey();
            InstallableManagedBundle installableBundle = entry.getValue();
            rebindLogger.debug("RebindManager installing bundle {}", versionedName);
            try {
                InputStream in = installableBundle.getInputStream();
                Throwable throwable = null;
                try {
                    installs.put(installableBundle, this.installBundle(installableBundle.getManagedBundle(), in));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Exception e) {
                exceptionHandler.onCreateFailed(BrooklynObjectType.MANAGED_BUNDLE, versionedName.toString(), installableBundle.getManagedBundle().getSymbolicName(), e);
            }
        }
        MutableSet installedTypes = MutableSet.of();
        for (OsgiBundleInstallationResult osgiBundleInstallationResult : installs.values()) {
            try {
                this.startBundle(osgiBundleInstallationResult);
                Iterables.addAll((Collection)installedTypes, (Iterable)this.managementContext.getTypeRegistry().getMatching(RegisteredTypePredicates.containingBundle(osgiBundleInstallationResult.getVersionedName())));
            }
            catch (Exception e) {
                exceptionHandler.onCreateFailed(BrooklynObjectType.MANAGED_BUNDLE, osgiBundleInstallationResult.getMetadata().getId(), osgiBundleInstallationResult.getMetadata().getSymbolicName(), e);
            }
        }
        if (!installedTypes.isEmpty()) {
            this.validateAllTypes((Set<RegisteredType>)installedTypes, exceptionHandler);
        }
        for (Map.Entry entry : installs.entrySet()) {
            ManagedBundle bundle = ((InstallableManagedBundle)entry.getKey()).getManagedBundle();
            OsgiBundleInstallationResult result = (OsgiBundleInstallationResult)entry.getValue();
            if (result.getCode() != OsgiBundleInstallationResult.ResultCode.IGNORING_BUNDLE_AREADY_INSTALLED || result.getMetadata().getId().equals(bundle.getId())) continue;
            this.managementContext.getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)bundle);
        }
    }

    private void validateAllTypes(Set<RegisteredType> installedTypes, RebindExceptionHandler exceptionHandler) {
        Stopwatch sw = Stopwatch.createStarted();
        log.debug("Getting catalog to validate all types");
        BrooklynCatalog catalog = this.managementContext.getCatalog();
        log.debug("Got catalog in {} now validate", (Object)sw.toString());
        sw.reset();
        sw.start();
        Map validationErrors = catalog.validateTypes(installedTypes);
        log.debug("Validation done in {}", (Object)sw.toString());
        if (!validationErrors.isEmpty()) {
            MutableMap errorsByBundle = MutableMap.of();
            for (RegisteredType t : validationErrors.keySet()) {
                VersionedName vn = VersionedName.fromString((String)t.getContainingBundle());
                Map errorsInBundle = (Map)errorsByBundle.get(vn);
                if (errorsInBundle == null) {
                    errorsInBundle = MutableMap.of();
                    errorsByBundle.put(vn, errorsInBundle);
                }
                errorsInBundle.put(t, validationErrors.get(t));
            }
            for (VersionedName vn : errorsByBundle.keySet()) {
                Map errorsInBundle = (Map)errorsByBundle.get(vn);
                ManagedBundle b = ((OsgiManager)this.managementContext.getOsgiManager().get()).getManagedBundle(vn);
                String id = b != null ? b.getId() : vn.toString();
                exceptionHandler.onCreateFailed(BrooklynObjectType.MANAGED_BUNDLE, id, vn.getSymbolicName(), (Exception)Exceptions.create((String)("Failed to install " + vn + ", types " + errorsInBundle.keySet() + " gave errors"), (Iterable)Iterables.concat(errorsInBundle.values())));
            }
        }
    }

    private OsgiBundleInstallationResult installBundle(ManagedBundle bundle, InputStream zipInput) {
        return (OsgiBundleInstallationResult)((OsgiManager)this.getManagementContext().getOsgiManager().get()).installDeferredStart(bundle, zipInput, false).get();
    }

    private void startBundle(OsgiBundleInstallationResult br) throws BundleException {
        if (br.getDeferredStart() != null) {
            br.getDeferredStart().run();
        }
    }

    private PersistedCatalogState filterBundlesAndCatalogInPersistedState(PersistedCatalogState persistedState, RebindLogger rebindLogger) {
        BundleUpgradeParser.CatalogUpgrades catalogUpgrades = BundleUpgradeParser.CatalogUpgrades.getFromManagementContext(this.managementContext);
        if (catalogUpgrades.isEmpty()) {
            return persistedState;
        }
        rebindLogger.info("Filtering out persisted catalog: removedBundles=" + catalogUpgrades.getRemovedBundles() + "; removedLegacyItems=" + catalogUpgrades.getRemovedLegacyItems(), new Object[0]);
        LinkedHashMap<VersionedName, InstallableManagedBundle> bundles = new LinkedHashMap<VersionedName, InstallableManagedBundle>();
        for (Map.Entry<VersionedName, InstallableManagedBundle> entry : persistedState.getBundles().entrySet()) {
            if (catalogUpgrades.isBundleRemoved(entry.getKey())) {
                rebindLogger.debug("Filtering out persisted bundle " + entry.getKey(), new Object[0]);
                continue;
            }
            bundles.put(entry.getKey(), entry.getValue());
        }
        ArrayList legacyCatalogItems = new ArrayList();
        for (CatalogItem<?, ?> legacyCatalogItem : persistedState.getLegacyCatalogItems()) {
            if (catalogUpgrades.isLegacyItemRemoved(legacyCatalogItem)) {
                rebindLogger.debug("Filtering out persisted legacy catalog item " + legacyCatalogItem.getId(), new Object[0]);
                continue;
            }
            legacyCatalogItems.add(legacyCatalogItem);
        }
        return new PersistedCatalogState(bundles, legacyCatalogItems);
    }

    public static class PersistedCatalogState {
        private final Map<VersionedName, InstallableManagedBundle> bundles;
        private final Collection<CatalogItem<?, ?>> legacyCatalogItems;

        public PersistedCatalogState(Map<VersionedName, InstallableManagedBundle> bundles, Collection<CatalogItem<?, ?>> legacyCatalogItems) {
            this.bundles = (Map)Preconditions.checkNotNull(bundles, (Object)"bundles");
            this.legacyCatalogItems = (Collection)Preconditions.checkNotNull(legacyCatalogItems, (Object)"legacyCatalogItems");
        }

        public Map<VersionedName, InstallableManagedBundle> getBundles() {
            return this.bundles;
        }

        public Collection<CatalogItem<?, ?>> getLegacyCatalogItems() {
            return this.legacyCatalogItems;
        }
    }

    public static interface InstallableManagedBundle {
        public ManagedBundle getManagedBundle();

        public InputStream getInputStream() throws IOException;
    }

    public static interface RebindLogger {
        public void debug(String var1, Object ... var2);

        public void info(String var1, Object ... var2);
    }
}

