/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.atlas.examples.sampleapp;

public final class SampleAppConstants {
    public static final String ATTR_NAME             = "name";
    public static final String ATTR_DESCRIPTION      = "description";
    public static final String ATTR_CREATE_TIME      = "createTime";
    public static final String ATTR_OWNER            = "owner";
    public static final String ATTR_TABLE_TYPE       = "tableType";
    public static final String ATTR_LAST_ACCESS_TIME = "lastAccessTime";
    public static final String ATTR_RANDOM_TABLE     = "randomTable";
    public static final String ATTR_TEMPORARY        = "temporary";
    public static final String ATTR_DATA_TYPE        = "dataType";
    public static final String ATTR_COMMENT          = "comment";
    public static final String ATTR_LOCATION_URI     = "locationUri";
    public static final String ATTR_USERNAME         = "userName";
    public static final String ATTR_START_TIME       = "startTime";
    public static final String ATTR_END_TIME         = "endTime";
    public static final String ATTR_QUERY_TEXT       = "queryText";
    public static final String ATTR_QUERY_PLAN       = "queryPlan";
    public static final String ATTR_QUERY_ID         = "queryId";
    public static final String ATTR_QUERY_GRAPH      = "queryGraph";
    public static final String ATTR_OPERATION_TYPE   = "operationType";
    public static final String ATTR_LEVEL            = "level";
    public static final String ATTR_COMPRESSED       = "compressed";
    public static final String ATTR_SERDE            = "serde";
    public static final String ATTR_SERDE1           = "serde1";
    public static final String ATTR_SERDE2           = "serde2";
    public static final String ATTR_ATTR1            = "attr1";
    public static final String ATTR_ATTR2            = "attr2";
    public static final String ATTR_ATTR8            = "attr8";
    public static final String ATTR_ATTR11           = "attr11";
    public static final String ATTR_ATTR18           = "attr88";
    public static final String ATTR_INPUTS           = "inputs";
    public static final String ATTR_OUTPUTS          = "outputs";
    public static final String ATTR_DB               = "db";
    public static final String ATTR_TABLE            = "table";
    public static final String ATTR_COLUMNS          = "columns";

    public static final String ENTITY_TYPE_DATASET = "DataSet";
    public static final String ENTITY_TYPE_PROCESS = "Process";

    public static final String PII_TAG                   = "SAMPLE_PII";
    public static final String FINANCE_TAG               = "SAMPLE_FINANCE";
    public static final String CLASSIFIED_TAG            = "SAMPLE_CLASSIFIED";
    public static final String METRIC_TAG                = "SAMPLE_METRIC";

    public static final String DATABASE_TYPE             = "sample_db_type";
    public static final String PROCESS_TYPE              = "sample_process_type";
    public static final String TABLE_TYPE                = "sample_table_type";
    public static final String COLUMN_TYPE               = "sample_column_type";

    public static final String TABLE_DATABASE_TYPE       = "sample_db_tables";
    public static final String TABLE_COLUMNS_TYPE        = "sample_table_columns";
    public static final String ENUM_TABLE_TYPE           = "sample_tableType";
    public static final String BUSINESS_METADATA_TYPE    = "sample_bmWithAllTypes";
    public static final String BUSINESS_METADATA_TYPE_MV = "sample_bmWithAllTypesMV";
    public static final String STRUCT_TYPE_SERDE         = "sample_serdeType";
}
