/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.LoggableTransaction;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.indexing.IndexQuery;
import com.thinkaurelius.titan.diskstorage.indexing.IndexTransaction;
import com.thinkaurelius.titan.diskstorage.indexing.RawQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.CacheTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.cache.KCVSCache;
import com.thinkaurelius.titan.diskstorage.log.kcvs.ExternalCachePersistor;
import com.thinkaurelius.titan.diskstorage.util.BackendOperation;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.graphdb.database.serialize.DataOutput;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendTransaction
implements LoggableTransaction {
    private static final Logger log = LoggerFactory.getLogger(BackendTransaction.class);
    public static final int MIN_TASKS_TO_PARALLELIZE = 2;
    public static final StaticBuffer EDGESTORE_MIN_KEY = BufferUtil.zeroBuffer(8);
    public static final StaticBuffer EDGESTORE_MAX_KEY = BufferUtil.oneBuffer(8);
    private final CacheTransaction storeTx;
    private final BaseTransactionConfig txConfig;
    private final StoreFeatures storeFeatures;
    private final KCVSCache edgeStore;
    private final KCVSCache indexStore;
    private final KCVSCache txLogStore;
    private final Duration maxReadTime;
    private final Executor threadPool;
    private final Map<String, IndexTransaction> indexTx;
    private boolean acquiredLock = false;
    private boolean cacheEnabled = true;

    public BackendTransaction(CacheTransaction storeTx, BaseTransactionConfig txConfig, StoreFeatures features, KCVSCache edgeStore, KCVSCache indexStore, KCVSCache txLogStore, Duration maxReadTime, Map<String, IndexTransaction> indexTx, Executor threadPool) {
        this.storeTx = storeTx;
        this.txConfig = txConfig;
        this.storeFeatures = features;
        this.edgeStore = edgeStore;
        this.indexStore = indexStore;
        this.txLogStore = txLogStore;
        this.maxReadTime = maxReadTime;
        this.indexTx = indexTx;
        this.threadPool = threadPool;
    }

    public boolean hasAcquiredLock() {
        return this.acquiredLock;
    }

    public StoreTransaction getStoreTransaction() {
        return this.storeTx;
    }

    public ExternalCachePersistor getTxLogPersistor() {
        return new ExternalCachePersistor(this.txLogStore, this.storeTx);
    }

    public BaseTransactionConfig getBaseTransactionConfig() {
        return this.txConfig;
    }

    public IndexTransaction getIndexTransaction(String index) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)index));
        IndexTransaction itx = this.indexTx.get(index);
        Preconditions.checkNotNull((Object)itx, (Object)("Unknown index: " + index));
        return itx;
    }

    public void disableCache() {
        this.cacheEnabled = false;
    }

    public void enableCache() {
        this.cacheEnabled = true;
    }

    public void commitStorage() throws BackendException {
        this.storeTx.commit();
    }

    public Map<String, Throwable> commitIndexes() {
        HashMap<String, Throwable> exceptions = new HashMap<String, Throwable>(this.indexTx.size());
        for (Map.Entry<String, IndexTransaction> txentry : this.indexTx.entrySet()) {
            try {
                txentry.getValue().commit();
            }
            catch (Throwable e) {
                exceptions.put(txentry.getKey(), e);
            }
        }
        return exceptions;
    }

    @Override
    public void commit() throws BackendException {
        this.storeTx.commit();
        for (IndexTransaction itx : this.indexTx.values()) {
            itx.commit();
        }
    }

    @Override
    public void rollback() throws BackendException {
        Throwable excep = null;
        for (IndexTransaction itx : this.indexTx.values()) {
            try {
                itx.rollback();
            }
            catch (Throwable e) {
                excep = e;
            }
        }
        this.storeTx.rollback();
        if (excep != null) {
            if (excep instanceof BackendException) {
                throw (BackendException)excep;
            }
            throw new PermanentBackendException("Unexpected exception", excep);
        }
    }

    @Override
    public void logMutations(DataOutput out) {
        this.storeTx.logMutations(out);
        for (Map.Entry<String, IndexTransaction> itx : this.indexTx.entrySet()) {
            out.writeObjectNotNull(itx.getKey());
            itx.getValue().logMutations(out);
        }
    }

    public void mutateEdges(StaticBuffer key, List<Entry> additions, List<Entry> deletions) throws BackendException {
        this.edgeStore.mutateEntries(key, additions, deletions, this.storeTx);
    }

    public void mutateIndex(StaticBuffer key, List<Entry> additions, List<Entry> deletions) throws BackendException {
        this.indexStore.mutateEntries(key, additions, deletions, this.storeTx);
    }

    public void acquireEdgeLock(StaticBuffer key, StaticBuffer column) throws BackendException {
        this.acquiredLock = true;
        this.edgeStore.acquireLock(key, column, null, this.storeTx);
    }

    public void acquireEdgeLock(StaticBuffer key, Entry entry) throws BackendException {
        this.acquiredLock = true;
        this.edgeStore.acquireLock(key, entry.getColumnAs(StaticBuffer.STATIC_FACTORY), entry.getValueAs(StaticBuffer.STATIC_FACTORY), this.storeTx);
    }

    public void acquireIndexLock(StaticBuffer key, StaticBuffer column) throws BackendException {
        this.acquiredLock = true;
        this.indexStore.acquireLock(key, column, null, this.storeTx);
    }

    public void acquireIndexLock(StaticBuffer key, Entry entry) throws BackendException {
        this.acquiredLock = true;
        this.indexStore.acquireLock(key, entry.getColumnAs(StaticBuffer.STATIC_FACTORY), entry.getValueAs(StaticBuffer.STATIC_FACTORY), this.storeTx);
    }

    public EntryList edgeStoreQuery(final KeySliceQuery query) {
        return this.executeRead(new Callable<EntryList>(){

            @Override
            public EntryList call() throws Exception {
                return BackendTransaction.this.cacheEnabled ? BackendTransaction.this.edgeStore.getSlice(query, BackendTransaction.this.storeTx) : BackendTransaction.this.edgeStore.getSliceNoCache(query, BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "EdgeStoreQuery";
            }
        });
    }

    public Map<StaticBuffer, EntryList> edgeStoreMultiQuery(final List<StaticBuffer> keys, final SliceQuery query) {
        if (this.storeFeatures.hasMultiQuery()) {
            return this.executeRead(new Callable<Map<StaticBuffer, EntryList>>(){

                @Override
                public Map<StaticBuffer, EntryList> call() throws Exception {
                    return BackendTransaction.this.cacheEnabled ? BackendTransaction.this.edgeStore.getSlice(keys, query, BackendTransaction.this.storeTx) : BackendTransaction.this.edgeStore.getSliceNoCache(keys, query, BackendTransaction.this.storeTx);
                }

                public String toString() {
                    return "MultiEdgeStoreQuery";
                }
            });
        }
        HashMap<StaticBuffer, EntryList> results = new HashMap<StaticBuffer, EntryList>(keys.size());
        if (this.threadPool == null || keys.size() < 2) {
            for (StaticBuffer key : keys) {
                results.put(key, this.edgeStoreQuery(new KeySliceQuery(key, query)));
            }
        } else {
            int i;
            CountDownLatch doneSignal = new CountDownLatch(keys.size());
            AtomicInteger failureCount = new AtomicInteger(0);
            Object[] resultArray = new EntryList[keys.size()];
            for (i = 0; i < keys.size(); ++i) {
                this.threadPool.execute(new SliceQueryRunner(new KeySliceQuery(keys.get(i), query), doneSignal, failureCount, resultArray, i));
            }
            try {
                doneSignal.await();
            }
            catch (InterruptedException e) {
                throw new TitanException("Interrupted while waiting for multi-query to complete", e);
            }
            if (failureCount.get() > 0) {
                throw new TitanException("Could not successfully complete multi-query. " + failureCount.get() + " individual queries failed.");
            }
            for (i = 0; i < keys.size(); ++i) {
                assert (resultArray[i] != null);
                results.put(keys.get(i), (EntryList)resultArray[i]);
            }
        }
        return results;
    }

    public KeyIterator edgeStoreKeys(final SliceQuery sliceQuery) {
        if (!this.storeFeatures.hasScan()) {
            throw new UnsupportedOperationException("The configured storage backend does not support global graph operations - use Faunus instead");
        }
        return this.executeRead(new Callable<KeyIterator>(){

            @Override
            public KeyIterator call() throws Exception {
                return BackendTransaction.this.storeFeatures.isKeyOrdered() ? BackendTransaction.this.edgeStore.getKeys(new KeyRangeQuery(EDGESTORE_MIN_KEY, EDGESTORE_MAX_KEY, sliceQuery), (StoreTransaction)BackendTransaction.this.storeTx) : BackendTransaction.this.edgeStore.getKeys(sliceQuery, (StoreTransaction)BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "EdgeStoreKeys";
            }
        });
    }

    public KeyIterator edgeStoreKeys(final KeyRangeQuery range) {
        Preconditions.checkArgument((boolean)this.storeFeatures.hasOrderedScan(), (Object)"The configured storage backend does not support ordered scans");
        return this.executeRead(new Callable<KeyIterator>(){

            @Override
            public KeyIterator call() throws Exception {
                return BackendTransaction.this.edgeStore.getKeys(range, (StoreTransaction)BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "EdgeStoreKeys";
            }
        });
    }

    public EntryList indexQuery(final KeySliceQuery query) {
        return this.executeRead(new Callable<EntryList>(){

            @Override
            public EntryList call() throws Exception {
                return BackendTransaction.this.cacheEnabled ? BackendTransaction.this.indexStore.getSlice(query, BackendTransaction.this.storeTx) : BackendTransaction.this.indexStore.getSliceNoCache(query, BackendTransaction.this.storeTx);
            }

            public String toString() {
                return "VertexIndexQuery";
            }
        });
    }

    public List<String> indexQuery(String index, final IndexQuery query) {
        final IndexTransaction indexTx = this.getIndexTransaction(index);
        return this.executeRead(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                return indexTx.query(query);
            }

            public String toString() {
                return "IndexQuery";
            }
        });
    }

    public Iterable<RawQuery.Result<String>> rawQuery(String index, final RawQuery query) {
        final IndexTransaction indexTx = this.getIndexTransaction(index);
        return this.executeRead(new Callable<Iterable<RawQuery.Result<String>>>(){

            @Override
            public Iterable<RawQuery.Result<String>> call() throws Exception {
                return indexTx.query(query);
            }

            public String toString() {
                return "RawQuery";
            }
        });
    }

    private final <V> V executeRead(Callable<V> exe) throws TitanException {
        return BackendOperation.execute(exe, this.maxReadTime);
    }

    private class SliceQueryRunner
    implements Runnable {
        final KeySliceQuery kq;
        final CountDownLatch doneSignal;
        final AtomicInteger failureCount;
        final Object[] resultArray;
        final int resultPosition;

        private SliceQueryRunner(KeySliceQuery kq, CountDownLatch doneSignal, AtomicInteger failureCount, Object[] resultArray, int resultPosition) {
            this.kq = kq;
            this.doneSignal = doneSignal;
            this.failureCount = failureCount;
            this.resultArray = resultArray;
            this.resultPosition = resultPosition;
        }

        @Override
        public void run() {
            try {
                EntryList result = BackendTransaction.this.edgeStoreQuery(this.kq);
                this.resultArray[this.resultPosition] = result;
            }
            catch (Exception e) {
                this.failureCount.incrementAndGet();
                log.warn("Individual query in multi-transaction failed: ", (Throwable)e);
            }
            finally {
                this.doneSignal.countDown();
            }
        }
    }
}

