/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSender;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderInfo;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToQueueSender;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeType;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBridgeToQueuePolicyManager
extends AMQPBridgeToPolicyManager
implements ActiveMQServerQueuePlugin {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPBridgeQueuePolicy policy;
    private final Map<String, AMQPBridgeQueueSenderManager> queueSenders = new HashMap<String, AMQPBridgeQueueSenderManager>();

    public AMQPBridgeToQueuePolicyManager(AMQPBridgeManager bridge, AMQPBridgeMetrics metrics, AMQPBridgeQueuePolicy policy) {
        super(bridge, metrics, policy.getPolicyName(), AMQPBridgeType.BRIDGE_TO_QUEUE);
        Objects.requireNonNull(policy, "The Queue match policy cannot be null");
        this.policy = policy;
    }

    @Override
    public AMQPBridgeQueuePolicy getPolicy() {
        return this.policy;
    }

    @Override
    protected void scanManagedResources() {
        this.server.getPostOffice().getAllBindings().filter(binding -> binding instanceof QueueBinding).forEach(binding -> this.checkQueueForMatch(((QueueBinding)binding).getQueue()));
    }

    @Override
    protected void safeCleanupManagerResources() {
        try {
            this.queueSenders.forEach((k, v) -> v.shutdownNow());
        }
        finally {
            this.queueSenders.clear();
        }
    }

    public synchronized void afterCreateQueue(Queue queue) throws ActiveMQException {
        if (this.isActive()) {
            this.checkQueueForMatch(queue);
        }
    }

    public synchronized void afterDestroyQueue(Queue queue, SimpleString address, SecurityAuth session, boolean checkConsumerCount, boolean removeConsumers, boolean autoDeleteAddress) throws ActiveMQException {
        String fqqn;
        AMQPBridgeQueueSenderManager manager;
        if (this.isActive() && (manager = this.queueSenders.remove(fqqn = CompositeAddress.toFullyQualified((SimpleString)queue.getAddress(), (SimpleString)queue.getName()).toString())) != null) {
            logger.trace("Clearing sender tracking for removed bridged Queues {}", (Object)fqqn);
            manager.shutdownNow();
        }
    }

    private boolean testIfQueueMatchesPolicy(String address, String queueName) {
        return this.policy.test(address, queueName);
    }

    protected final void checkQueueForMatch(Queue queue) {
        if (this.testIfQueueMatchesPolicy(queue.getAddress().toString(), queue.getName().toString())) {
            AddressInfo addressInfo = this.server.getPostOffice().getAddressInfo(queue.getAddress());
            logger.trace("AMQP Bridge To Queue Policy matched on Queue: {}:{}", (Object)addressInfo, (Object)queue);
            AMQPBridgeSenderInfo info = this.createSenderInfo(addressInfo, queue);
            if (!this.queueSenders.containsKey(info.getLocalFqqn())) {
                AMQPBridgeQueueSenderManager manager = new AMQPBridgeQueueSenderManager(this, this.configuration, info);
                this.queueSenders.put(info.getLocalFqqn(), manager);
                manager.start();
            }
        }
    }

    private AMQPBridgeSenderInfo createSenderInfo(AddressInfo addressInfo, Queue queue) {
        String queueName = queue.getName().toString();
        StringBuilder remoteAddressBuilder = new StringBuilder();
        if (this.policy.getRemoteAddressPrefix() != null) {
            remoteAddressBuilder.append(this.policy.getRemoteAddressPrefix());
        }
        if (this.policy.getRemoteAddress() != null && !this.policy.getRemoteAddress().isBlank()) {
            remoteAddressBuilder.append(this.policy.getRemoteAddress());
        } else {
            remoteAddressBuilder.append(queueName);
        }
        if (this.policy.getRemoteAddressSuffix() != null) {
            remoteAddressBuilder.append(this.policy.getRemoteAddressSuffix());
        }
        return new AMQPBridgeSenderInfo(AMQPBridgeSenderInfo.Role.QUEUE_SENDER, addressInfo.getName().toString(), queueName, addressInfo.getRoutingType(), remoteAddressBuilder.toString());
    }

    private AMQPBridgeSender createBridgeSender(AMQPBridgeSenderInfo senderInfo) {
        Objects.requireNonNull(senderInfo, "AMQP Bridge Queue sender information object was null");
        if (logger.isTraceEnabled()) {
            logger.trace("AMQP Bridge {} creating Queue sender: {} for policy: {}", new Object[]{this.bridge.getName(), senderInfo, this.policy.getPolicyName()});
        }
        return new AMQPBridgeToQueueSender(this, this.configuration, this.session, senderInfo, this.metrics.newSenderMetrics());
    }

    private static class AMQPBridgeQueueSenderManager
    extends AMQPBridgeSenderManager {
        private final AMQPBridgeToQueuePolicyManager manager;
        private final AMQPBridgeSenderInfo senderInfo;

        AMQPBridgeQueueSenderManager(AMQPBridgeToQueuePolicyManager manager, AMQPBridgeSenderConfiguration configuration, AMQPBridgeSenderInfo senderInfo) {
            super(manager, configuration);
            this.manager = manager;
            this.senderInfo = senderInfo;
        }

        @Override
        protected AMQPBridgeSender createBridgeSender() {
            return this.manager.createBridgeSender(this.senderInfo);
        }
    }
}

