/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthHelpers;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.Redirector;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRouteRedirectFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRouteRedirectFilter.class);
    public static final String ATTRIBUTE_UNSECURED_PATHS = "unsecuredPaths";
    private int timeout;
    private AuthenticationConfiguration authConfiguration;
    private String[] unsecuredPaths;
    private final String basePath;
    private String baseFullPath;
    private String contextPath;
    private Redirector redirector = new Redirector();

    public ClientRouteRedirectFilter() {
        this(AuthenticationConfiguration.UNSECURED_PATHS, "/");
    }

    public ClientRouteRedirectFilter(String[] unsecuredPaths, String hawtioBase) {
        this.unsecuredPaths = unsecuredPaths;
        this.basePath = ServletHelpers.cleanPath(hawtioBase);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(filterConfig.getServletContext());
        this.timeout = AuthSessionHelpers.getSessionTimeout(filterConfig.getServletContext());
        LOG.info("Hawtio ClientRouteRedirectFilter is using {} sec. HttpSession timeout", (Object)this.timeout);
        Object unsecured = filterConfig.getServletContext().getAttribute(ATTRIBUTE_UNSECURED_PATHS);
        if (unsecured != null) {
            this.unsecuredPaths = (String[])unsecured;
        }
        this.contextPath = filterConfig.getServletContext().getContextPath();
        this.baseFullPath = ServletHelpers.webContextPath(this.contextPath, this.basePath);
        String appContextPath = filterConfig.getInitParameter("applicationContextPath");
        if (appContextPath != null && !appContextPath.isEmpty()) {
            this.baseFullPath = ServletHelpers.cleanPath(appContextPath);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(false);
        String requestURI = ServletHelpers.cleanPath(httpRequest.getRequestURI());
        String hawtioPath = requestURI.length() < this.baseFullPath.length() ? "" : requestURI.substring(this.baseFullPath.length());
        String path = requestURI.length() < this.contextPath.length() ? "" : requestURI.substring(this.contextPath.length());
        boolean loginPage = hawtioPath.startsWith("/login");
        if (this.baseFullPath.equals(requestURI)) {
            path = "/".equals(this.basePath) ? "/" : this.basePath + "/";
        }
        LOG.debug("Check if path [{}] requires redirect", (Object)path);
        if (!loginPage && !this.isSecuredPath(path)) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.authConfiguration.isEnabled() || this.authConfiguration.isExternalAuthenticationEnabled()) {
            if (loginPage) {
                this.redirector.doRedirect(httpRequest, httpResponse, "/");
            } else {
                this.redirector.doForward(httpRequest, httpResponse, "/index.html");
            }
            return;
        }
        if (AuthSessionHelpers.isAuthenticated(session)) {
            if (loginPage) {
                this.redirector.doRedirect(httpRequest, httpResponse, "/");
            } else {
                this.redirector.doForward(httpRequest, httpResponse, "/index.html");
            }
            return;
        }
        if (loginPage) {
            this.redirector.doForward(httpRequest, httpResponse, "/index.html");
            return;
        }
        AuthenticateResult.Type preemptiveAuthResult = this.tryAuthenticateRequest(httpRequest, session);
        if (preemptiveAuthResult != AuthenticateResult.Type.AUTHORIZED) {
            if (preemptiveAuthResult != AuthenticateResult.Type.NOT_AUTHORIZED) {
                this.redirector.doRedirect(httpRequest, httpResponse, "/login");
            } else {
                this.redirector.doRedirect(httpRequest, httpResponse, "/login#noauth");
            }
            return;
        }
        this.redirector.doForward(httpRequest, httpResponse, "/index.html");
    }

    AuthenticateResult.Type tryAuthenticateRequest(HttpServletRequest request, HttpSession session) {
        AuthenticateResult result = new Authenticator(request, this.authConfiguration).authenticate(subject -> {
            String username = AuthHelpers.getUsername(subject);
            LOG.info("Logging in user: {}", (Object)username);
            AuthSessionHelpers.setup(session != null ? session : request.getSession(true), subject, username, this.timeout);
        });
        return result.getType();
    }

    boolean isSecuredPath(String path) {
        return Arrays.stream(this.unsecuredPaths).noneMatch(path::startsWith);
    }

    public void setRedirector(Redirector redirector) {
        this.redirector = redirector;
    }
}

