/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.util.Arrays;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.resource.NotSupportedException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.ra.ActiveMQRABundle;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class ActiveMQRABundle_impl
implements ActiveMQRABundle {
    private final Logger logger;

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    public ActiveMQRABundle_impl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ActiveMQIllegalStateException errorDecodingPassword(Exception e) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ159000: Error decoding password using codec instance", (Object[])new Object[]{e}).getMessage();
        ActiveMQIllegalStateException objReturn_errorDecodingPassword = new ActiveMQIllegalStateException(returnString);
        objReturn_errorDecodingPassword.initCause((Throwable)e);
        ActiveMQRABundle_impl._copyStackTraceMinusOne((Throwable)objReturn_errorDecodingPassword);
        return objReturn_errorDecodingPassword;
    }

    @Override
    public NotSupportedException noActivationSpec() {
        String returnString = "AMQ159001: MDB cannot be deployed as it has no Activation Spec. Please provide an Activation!";
        NotSupportedException objReturn_noActivationSpec = new NotSupportedException(returnString);
        ActiveMQRABundle_impl._copyStackTraceMinusOne((Throwable)objReturn_noActivationSpec);
        return objReturn_noActivationSpec;
    }

    @Override
    public IllegalArgumentException noDestinationName() {
        String returnString = "AMQ159002: Please provide a destination for the MDB";
        IllegalArgumentException objReturn_noDestinationName = new IllegalArgumentException(returnString);
        ActiveMQRABundle_impl._copyStackTraceMinusOne(objReturn_noDestinationName);
        return objReturn_noDestinationName;
    }

    @Override
    public JMSRuntimeException illegalJEEMethod() {
        String returnString = "AMQ159003: This method is not applicable inside the application server. See the JEE spec, e.g. JEE 7 Section 6.7";
        JMSRuntimeException objReturn_illegalJEEMethod = new JMSRuntimeException(returnString);
        ActiveMQRABundle_impl._copyStackTraceMinusOne((Throwable)objReturn_illegalJEEMethod);
        return objReturn_illegalJEEMethod;
    }

    @Override
    public JMSRuntimeException invalidSessionTransactedModeRuntime() {
        String returnString = "AMQ159004: Invalid Session Mode SESSION_TRANSACTED";
        JMSRuntimeException objReturn_invalidSessionTransactedModeRuntime = new JMSRuntimeException(returnString);
        ActiveMQRABundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidSessionTransactedModeRuntime);
        return objReturn_invalidSessionTransactedModeRuntime;
    }

    @Override
    public JMSRuntimeException invalidClientAcknowledgeModeRuntime() {
        String returnString = "AMQ159005: Invalid Session Mode CLIENT_ACKNOWLEDGE";
        JMSRuntimeException objReturn_invalidClientAcknowledgeModeRuntime = new JMSRuntimeException(returnString);
        ActiveMQRABundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidClientAcknowledgeModeRuntime);
        return objReturn_invalidClientAcknowledgeModeRuntime;
    }

    @Override
    public JMSRuntimeException invalidAcknowledgeMode(int sessionMode) {
        String returnString = MessageFormatter.arrayFormat((String)"AMQ159006: Invalid Session Mode {}", (Object[])new Object[]{sessionMode}).getMessage();
        JMSRuntimeException objReturn_invalidAcknowledgeMode = new JMSRuntimeException(returnString);
        ActiveMQRABundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidAcknowledgeMode);
        return objReturn_invalidAcknowledgeMode;
    }

    @Override
    public JMSException invalidSessionTransactedModeRuntimeAllowLocal() {
        String returnString = "AMQ159007: Invalid Session Mode SESSION_TRANSACTED, to enable Local Transacted Sessions you can set the allowLocalTransactions (allow-local-transactions) on the resource adapter";
        JMSException objReturn_invalidSessionTransactedModeRuntimeAllowLocal = new JMSException(returnString);
        ActiveMQRABundle_impl._copyStackTraceMinusOne((Throwable)objReturn_invalidSessionTransactedModeRuntimeAllowLocal);
        return objReturn_invalidSessionTransactedModeRuntimeAllowLocal;
    }
}

