/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.strategy.AdaptiveExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2Connection
extends AbstractConnection
implements Parser.Listener,
Connection.UpgradeTo {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2Connection.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private final HTTP2Producer producer = new HTTP2Producer();
    private final AtomicLong bytesIn = new AtomicLong();
    private final ByteBufferPool bufferPool;
    private final HTTP2Session session;
    private final int bufferSize;
    private final int minBufferSpace;
    private final ExecutionStrategy strategy;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;

    protected HTTP2Connection(ByteBufferPool bufferPool, Executor executor, EndPoint endPoint, HTTP2Session session, int bufferSize) {
        this(bufferPool, executor, endPoint, session, bufferSize, -1);
    }

    protected HTTP2Connection(ByteBufferPool bufferPool, Executor executor, EndPoint endPoint, HTTP2Session session, int bufferSize, int minBufferSpace) {
        super(endPoint, executor);
        this.bufferPool = bufferPool;
        this.session = session;
        this.bufferSize = bufferSize;
        this.minBufferSpace = minBufferSpace < 0 ? Math.min(1500, bufferSize) : minBufferSpace;
        this.strategy = new AdaptiveExecutionStrategy((ExecutionStrategy.Producer)this.producer, executor);
        LifeCycle.start((Object)this.strategy);
    }

    public long getMessagesIn() {
        HTTP2Session session = this.getSession();
        return session.getStreamsOpened();
    }

    public long getMessagesOut() {
        HTTP2Session session = this.getSession();
        return session.getStreamsClosed();
    }

    public long getBytesIn() {
        return this.bytesIn.get();
    }

    public long getBytesOut() {
        return this.session.getBytesWritten();
    }

    public HTTP2Session getSession() {
        return this.session;
    }

    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onUpgradeTo {} {}", (Object)this, (Object)BufferUtil.toDetailString((ByteBuffer)buffer));
        }
        this.producer.setInputBuffer(buffer);
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Open {} ", (Object)this);
        }
        super.onOpen();
    }

    public void onClose(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Close {} ", (Object)this);
        }
        super.onClose(cause);
        LifeCycle.stop((Object)this.strategy);
        this.producer.stop();
    }

    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onFillable {} ", (Object)this);
        }
        this.produce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fill(EndPoint endPoint, ByteBuffer buffer, boolean compact) {
        int padding = 0;
        try {
            if (endPoint.isInputShutdown()) {
                int n = -1;
                return n;
            }
            if (!compact) {
                padding = buffer.limit();
                buffer.position(0);
            }
            int n = endPoint.fill(buffer);
            return n;
        }
        catch (IOException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not read from {}", (Object)endPoint, (Object)x);
            }
            int n = -1;
            return n;
        }
        finally {
            if (!compact && padding > 0) {
                buffer.position(padding);
            }
        }
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        boolean close;
        boolean idle = this.isFillInterested();
        if (idle && (close = this.session.onIdleTimeout())) {
            this.session.close(ErrorCode.NO_ERROR.code, "idle_timeout", Callback.NOOP);
        }
        return false;
    }

    public void offerTask(Runnable task, boolean dispatch) {
        this.offerTask(task);
        if (dispatch) {
            this.dispatch();
        } else {
            this.produce();
        }
    }

    private void offerTask(Runnable task) {
        try (AutoLock ignored = this.lock.lock();){
            this.tasks.offer(task);
        }
    }

    protected void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 produce {} ", (Object)this);
        }
        this.strategy.produce();
    }

    protected void dispatch() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 dispatch {} ", (Object)this);
        }
        this.strategy.dispatch();
    }

    public void close() {
        this.session.close(ErrorCode.NO_ERROR.code, "close", Callback.NOOP);
    }

    private Runnable pollTask() {
        try (AutoLock ignored = this.lock.lock();){
            Runnable runnable = this.tasks.poll();
            return runnable;
        }
    }

    @Override
    public void onHeaders(HeadersFrame frame) {
        this.session.onHeaders(frame);
    }

    @Override
    public void onData(DataFrame frame) {
        this.session.onData(this.producer.newStreamData(frame));
    }

    @Override
    public void onPriority(PriorityFrame frame) {
        this.session.onPriority(frame);
    }

    @Override
    public void onReset(ResetFrame frame) {
        this.session.onReset(frame);
    }

    @Override
    public void onSettings(SettingsFrame frame) {
        this.session.onSettings(frame);
    }

    @Override
    public void onPushPromise(PushPromiseFrame frame) {
        this.session.onPushPromise(frame);
    }

    @Override
    public void onPing(PingFrame frame) {
        this.session.onPing(frame);
    }

    @Override
    public void onGoAway(GoAwayFrame frame) {
        this.session.onGoAway(frame);
    }

    @Override
    public void onWindowUpdate(WindowUpdateFrame frame) {
        this.session.onWindowUpdate(frame);
    }

    @Override
    public void onStreamFailure(int streamId, int error, String reason) {
        this.session.onStreamFailure(streamId, error, reason);
    }

    @Override
    public void onConnectionFailure(int error, String reason) {
        this.producer.failed = true;
        this.session.onConnectionFailure(error, reason);
    }

    public String toConnectionString() {
        return "%s@%x[%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this.strategy);
    }

    protected class HTTP2Producer
    implements ExecutionStrategy.Producer {
        private static final RetainableByteBuffer.Mutable STOPPED = new RetainableByteBuffer.NonRetainableByteBuffer(BufferUtil.EMPTY_BUFFER);
        private static final RetainableByteBuffer.Mutable RELEASE_MARKER = new RetainableByteBuffer.NonRetainableByteBuffer(BufferUtil.EMPTY_BUFFER);
        private final Callback fillableCallback;
        private final AutoLock lock;
        private RetainableByteBuffer.Mutable heldBuffer;
        private RetainableByteBuffer.Mutable networkBuffer;
        private boolean shutdown;
        private boolean failed;

        protected HTTP2Producer() {
            this.fillableCallback = new FillableCallback();
            this.lock = new AutoLock();
        }

        private void setInputBuffer(ByteBuffer byteBuffer) {
            try (AutoLock ignore = this.lock.lock();){
                RetainableByteBuffer.Mutable networkBuffer = this.lockedAcquireBuffer();
                if (!networkBuffer.append(byteBuffer)) {
                    networkBuffer.release();
                    throw new IllegalStateException("overflow");
                }
                this.lockedHoldBuffer(networkBuffer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Runnable produce() {
            int filled;
            RetainableByteBuffer.Mutable networkBuffer;
            Runnable task = HTTP2Connection.this.pollTask();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dequeued task {}", (Object)task);
            }
            if (task != null) {
                return task;
            }
            if (HTTP2Connection.this.isFillInterested()) return null;
            if (this.shutdown) return null;
            if (this.failed) {
                return null;
            }
            boolean interested = false;
            try (AutoLock ignore = this.lock.lock();){
                this.networkBuffer = networkBuffer = this.lockedAcquireBuffer();
            }
            try {
                boolean parse = networkBuffer.hasRemaining();
                while (true) {
                    boolean compact = true;
                    if (parse) {
                        while (networkBuffer.hasRemaining()) {
                            HTTP2Connection.this.session.getParser().parse(networkBuffer.getByteBuffer());
                            if (!this.failed) continue;
                            Runnable runnable = null;
                            return runnable;
                        }
                        task = HTTP2Connection.this.pollTask();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Dequeued new task {}", (Object)task);
                        }
                        if (task != null) {
                            Runnable runnable = task;
                            return runnable;
                        }
                    }
                    if (networkBuffer.isRetained()) {
                        if (HTTP2Connection.this.minBufferSpace > 0 && BufferUtil.space((ByteBuffer)networkBuffer.getByteBuffer()) >= HTTP2Connection.this.minBufferSpace) {
                            compact = false;
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Released retained {}", (Object)networkBuffer);
                            }
                            networkBuffer.release();
                            try (AutoLock ignore = this.lock.lock();){
                                this.networkBuffer = networkBuffer = this.lockedAcquireBuffer();
                            }
                        }
                    }
                    filled = HTTP2Connection.this.fill(HTTP2Connection.this.getEndPoint(), networkBuffer.getByteBuffer(), compact);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Filled {} bytes compacted {} {} in {}", new Object[]{filled, compact, networkBuffer, HTTP2Connection.this});
                    }
                    if (filled <= 0) break;
                    HTTP2Connection.this.bytesIn.addAndGet(filled);
                    parse = true;
                    continue;
                    break;
                }
            }
            catch (Throwable x) {
                LOG.warn("Unexpected exception while producing {}", (Object)this, (Object)x);
                HTTP2Connection.this.session.onConnectionFailure(ErrorCode.INTERNAL_ERROR.code, x.toString());
                Runnable runnable = null;
                return runnable;
            }
            if (filled == 0) {
                return null;
            }
            this.shutdown = true;
            HTTP2Connection.this.session.onShutdown();
            return HTTP2Connection.this.pollTask();
            finally {
                try (AutoLock ignore = this.lock.lock();){
                    if (networkBuffer.isRetained() && this.heldBuffer != RELEASE_MARKER && !this.shutdown) {
                        this.lockedHoldBuffer(networkBuffer);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Released after process {}", (Object)networkBuffer);
                        }
                        networkBuffer.release();
                    }
                    this.networkBuffer = null;
                }
                if (interested) {
                    HTTP2Connection.this.fillInterested(this.fillableCallback);
                }
            }
        }

        private StreamData newStreamData(DataFrame frame) {
            try (AutoLock ignore = this.lock.lock();){
                StreamData streamData = new StreamData(frame, (Retainable)this.networkBuffer, this::releaseHeldBuffer);
                return streamData;
            }
        }

        private void releaseHeldBuffer() {
            try (AutoLock ignore = this.lock.lock();){
                RetainableByteBuffer.Mutable held;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("releaseHeldBuffer networkBuffer={} heldBuffer={}", (Object)this.networkBuffer, (Object)this.heldBuffer);
                }
                if ((held = this.heldBuffer) == null) {
                    this.heldBuffer = RELEASE_MARKER;
                } else {
                    held.release();
                    this.heldBuffer = null;
                }
            }
        }

        private RetainableByteBuffer.Mutable lockedAcquireBuffer() {
            assert (this.lock.isHeldByCurrentThread());
            RetainableByteBuffer.Mutable buffer = this.heldBuffer;
            if (buffer == RELEASE_MARKER) {
                buffer = null;
            }
            this.heldBuffer = null;
            RetainableByteBuffer.Mutable held = buffer;
            if (buffer == null) {
                buffer = HTTP2Connection.this.bufferPool.acquire(HTTP2Connection.this.bufferSize, HTTP2Connection.this.isUseInputDirectByteBuffers()).asMutable();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquired {} {} in {}", new Object[]{held == null ? "new" : "held", buffer, HTTP2Connection.this});
            }
            return buffer;
        }

        private void lockedHoldBuffer(RetainableByteBuffer.Mutable buffer) {
            assert (this.lock.isHeldByCurrentThread());
            if (this.heldBuffer == null) {
                this.heldBuffer = buffer;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Held {} in {}", (Object)buffer, (Object)HTTP2Connection.this);
                }
            } else if (this.heldBuffer == STOPPED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Released instead of holding {}", (Object)buffer);
                }
                buffer.release();
            } else {
                throw new IllegalStateException("Buffer already saved");
            }
        }

        private void stop() {
            try (AutoLock ignore = this.lock.lock();){
                RetainableByteBuffer.Mutable buffer = this.heldBuffer;
                this.heldBuffer = STOPPED;
                if (buffer != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Released in stop {}", (Object)buffer);
                    }
                    buffer.release();
                }
            }
        }

        public String toString() {
            String countState;
            try (AutoLock l = this.lock.tryLock();){
                boolean held = l.isHeldByCurrentThread();
                countState = held ? String.valueOf(HTTP2Connection.this.tasks.size()) : "undefined";
            }
            return "%s@%x[taskQueue=%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), countState);
        }
    }

    private static class StreamData
    extends Stream.Data {
        private final Retainable retainable;
        private final Runnable releaser;

        private StreamData(DataFrame frame, Retainable retainable, Runnable releaser) {
            super(frame);
            this.retainable = retainable;
            this.releaser = releaser;
        }

        public boolean canRetain() {
            return this.retainable.canRetain();
        }

        public boolean isRetained() {
            return this.retainable.isRetained();
        }

        public void retain() {
            this.retainable.retain();
        }

        public boolean release() {
            boolean released = this.retainable.release();
            if (!released && !this.isRetained()) {
                this.releaser.run();
            }
            return released;
        }
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        public void succeeded() {
            HTTP2Connection.this.onFillable();
        }

        public void failed(Throwable x) {
            HTTP2Connection.this.onFillInterestedFailed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.EITHER;
        }
    }
}

