/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import java.util.LinkedList;
import javax.management.AttributeNotFoundException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;

public class CompositeDataExtractor
implements Extractor {
    @Override
    public Class<?> getType() {
        return CompositeData.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Deque<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String pathPart;
        CompositeData cd = (CompositeData)pValue;
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            try {
                return pConverter.extractObject(cd.get(pathPart), pPathParts, jsonify);
            }
            catch (InvalidKeyException exp) {
                return pConverter.getValueFaultHandler().handleException((Throwable)new AttributeNotFoundException("Invalid path '" + pathPart + "'"));
            }
        }
        return jsonify ? this.extractCompleteCdAsJson(pConverter, cd, pPathParts) : cd;
    }

    private Object extractCompleteCdAsJson(ObjectToJsonConverter pConverter, CompositeData pData, Deque<String> pPath) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (String key : pData.getCompositeType().keySet()) {
            LinkedList<String> path = new LinkedList<String>(pPath);
            try {
                ret.put((Object)key, pConverter.extractObject(pData.get(key), path, true));
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {}
        }
        if (ret.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("CompositeData cannot be written to");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

