/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.Collection;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;

public interface LifecycleStrategy {
    default public void onContextInitializing(CamelContext context) throws VetoCamelContextStartException {
    }

    default public void onContextInitialized(CamelContext context) throws VetoCamelContextStartException {
    }

    default public void onContextStarting(CamelContext context) throws VetoCamelContextStartException {
    }

    default public void onContextStarted(CamelContext context) {
    }

    default public void onContextStopping(CamelContext context) {
    }

    default public void onContextStopped(CamelContext context) {
    }

    public void onComponentAdd(String var1, Component var2);

    public void onComponentRemove(String var1, Component var2);

    public void onEndpointAdd(Endpoint var1);

    public void onEndpointRemove(Endpoint var1);

    default public void onDataFormatCreated(String name, DataFormat dataFormat) {
    }

    default public void onLanguageCreated(String name, Language language) {
    }

    public void onServiceAdd(CamelContext var1, Service var2, Route var3);

    public void onServiceRemove(CamelContext var1, Service var2, Route var3);

    default public void onServiceRemove(CamelContext context, Service service, Route route, boolean shutdown) {
        this.onServiceRemove(context, service, route);
    }

    public void onRoutesAdd(Collection<Route> var1);

    public void onRoutesRemove(Collection<Route> var1);

    public void onRouteContextCreate(Route var1);

    public void onThreadPoolAdd(CamelContext var1, ThreadPoolExecutor var2, String var3, String var4, String var5, String var6);

    public void onThreadPoolRemove(CamelContext var1, ThreadPoolExecutor var2);
}

