/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ProcessClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.NoOutputExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.processor.EvaluateExpressionProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;

@Metadata(label="eip,endpoint,routing")
@XmlRootElement(name="recipientList")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RecipientListDefinition<Type extends ProcessorDefinition<Type>>
extends NoOutputExpressionNode
implements ExecutorServiceAwareDefinition<RecipientListDefinition<Type>> {
    @XmlTransient
    private AggregationStrategy aggregationStrategy;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String delimiter;
    @XmlAttribute
    private Boolean parallelProcessing;
    @XmlAttribute
    private String strategyRef;
    @XmlAttribute
    private String strategyMethodName;
    @XmlAttribute
    private Boolean strategyMethodAllowNull;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Boolean stopOnException;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoints;
    @XmlAttribute
    private Boolean streaming;
    @XmlAttribute
    @Metadata(defaultValue="0")
    private Long timeout;
    @XmlAttribute
    private String onPrepareRef;
    @XmlTransient
    private Processor onPrepare;
    @XmlAttribute
    private Boolean shareUnitOfWork;
    @XmlAttribute
    private Integer cacheSize;
    @XmlAttribute
    private Boolean parallelAggregate;
    @XmlAttribute
    private Boolean stopOnAggregateException;

    public RecipientListDefinition() {
    }

    public RecipientListDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public RecipientListDefinition(Expression expression) {
        super(expression);
    }

    public String toString() {
        return "RecipientList[" + this.getExpression() + "]";
    }

    @Override
    public String getShortName() {
        return "recipientList";
    }

    @Override
    public String getLabel() {
        return "recipientList[" + this.getExpression() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        long timeout;
        final Expression expression = this.getExpression().createExpression(routeContext);
        boolean isParallelProcessing = this.getParallelProcessing() != null && this.getParallelProcessing() != false;
        boolean isStreaming = this.getStreaming() != null && this.getStreaming() != false;
        boolean isParallelAggregate = this.getParallelAggregate() != null && this.getParallelAggregate() != false;
        boolean isShareUnitOfWork = this.getShareUnitOfWork() != null && this.getShareUnitOfWork() != false;
        boolean isStopOnException = this.getStopOnException() != null && this.getStopOnException() != false;
        boolean isIgnoreInvalidEndpoints = this.getIgnoreInvalidEndpoints() != null && this.getIgnoreInvalidEndpoints() != false;
        boolean isStopOnAggregateException = this.getStopOnAggregateException() != null && this.getStopOnAggregateException() != false;
        RecipientList answer = this.delimiter != null ? new RecipientList(routeContext.getCamelContext(), expression, this.delimiter) : new RecipientList(routeContext.getCamelContext(), expression);
        answer.setAggregationStrategy(this.createAggregationStrategy(routeContext));
        answer.setParallelProcessing(isParallelProcessing);
        answer.setParallelAggregate(isParallelAggregate);
        answer.setStreaming(isStreaming);
        answer.setShareUnitOfWork(isShareUnitOfWork);
        answer.setStopOnException(isStopOnException);
        answer.setIgnoreInvalidEndpoints(isIgnoreInvalidEndpoints);
        answer.setStopOnAggregateException(isStopOnAggregateException);
        if (this.getCacheSize() != null) {
            answer.setCacheSize(this.getCacheSize());
        }
        if (this.onPrepareRef != null) {
            this.onPrepare = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.onPrepareRef, Processor.class);
        }
        if (this.onPrepare != null) {
            answer.setOnPrepare(this.onPrepare);
        }
        if (this.getTimeout() != null) {
            answer.setTimeout(this.getTimeout());
        }
        boolean shutdownThreadPool = ProcessorDefinitionHelper.willCreateNewThreadPool(routeContext, this, isParallelProcessing);
        ExecutorService threadPool = ProcessorDefinitionHelper.getConfiguredExecutorService(routeContext, "RecipientList", this, isParallelProcessing);
        answer.setExecutorService(threadPool);
        answer.setShutdownExecutorService(shutdownThreadPool);
        long l = timeout = this.getTimeout() != null ? this.getTimeout() : 0L;
        if (timeout > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        ArrayList<AsyncProcessor> pipe = new ArrayList<AsyncProcessor>(2);
        Processor evalProcessor = new EvaluateExpressionProcessor(expression);
        evalProcessor = super.wrapInErrorHandler(routeContext, evalProcessor);
        pipe.add((AsyncProcessor)evalProcessor);
        pipe.add(answer);
        return new Pipeline(routeContext.getCamelContext(), pipe){

            @Override
            public String toString() {
                return "RecipientList[" + expression + "]";
            }
        };
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.strategyRef != null) {
            Object aggStrategy = routeContext.lookup(this.strategyRef, Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.getStrategyMethodName());
                if (this.getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.getStrategyMethodAllowNull());
                    adapter.setAllowNullOldExchange(this.getStrategyMethodAllowNull());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + this.strategyRef);
            }
        }
        if (strategy == null) {
            strategy = new UseLatestAggregationStrategy();
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)strategy)).setCamelContext(routeContext.getCamelContext());
        }
        if (this.shareUnitOfWork != null && this.shareUnitOfWork.booleanValue()) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }

    public Type end() {
        return (Type)super.end();
    }

    public RecipientListDefinition<Type> delimiter(String delimiter) {
        this.setDelimiter(delimiter);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategyRef(String aggregationStrategyRef) {
        this.setStrategyRef(aggregationStrategyRef);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategyMethodName(String methodName) {
        this.setStrategyMethodName(methodName);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategyMethodAllowNull() {
        this.setStrategyMethodAllowNull(true);
        return this;
    }

    public RecipientListDefinition<Type> ignoreInvalidEndpoints() {
        this.setIgnoreInvalidEndpoints(true);
        return this;
    }

    public RecipientListDefinition<Type> parallelProcessing() {
        this.setParallelProcessing(true);
        return this;
    }

    public RecipientListDefinition<Type> parallelProcessing(boolean parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public RecipientListDefinition<Type> parallelAggregate() {
        this.setParallelAggregate(true);
        return this;
    }

    public RecipientListDefinition<Type> stopOnAggregateException() {
        this.setStopOnAggregateException(true);
        return this;
    }

    public RecipientListDefinition<Type> streaming() {
        this.setStreaming(true);
        return this;
    }

    public RecipientListDefinition<Type> stopOnException() {
        this.setStopOnException(true);
        return this;
    }

    @Override
    public RecipientListDefinition<Type> executorService(ExecutorService executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    @Override
    public RecipientListDefinition<Type> executorServiceRef(String executorServiceRef) {
        this.setExecutorServiceRef(executorServiceRef);
        return this;
    }

    public RecipientListDefinition<Type> onPrepare(Processor onPrepare) {
        this.setOnPrepare(onPrepare);
        return this;
    }

    public ProcessClause<RecipientListDefinition<Type>> onPrepare() {
        ProcessClause<RecipientListDefinition<Type>> clause = new ProcessClause<RecipientListDefinition<Type>>(this);
        this.setOnPrepare(clause);
        return clause;
    }

    public RecipientListDefinition<Type> onPrepareRef(String onPrepareRef) {
        this.setOnPrepareRef(onPrepareRef);
        return this;
    }

    public RecipientListDefinition<Type> timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public RecipientListDefinition<Type> shareUnitOfWork() {
        this.setShareUnitOfWork(true);
        return this;
    }

    public RecipientListDefinition<Type> cacheSize(int cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Boolean getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(Boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getStrategyRef() {
        return this.strategyRef;
    }

    public void setStrategyRef(String strategyRef) {
        this.strategyRef = strategyRef;
    }

    public String getStrategyMethodName() {
        return this.strategyMethodName;
    }

    public void setStrategyMethodName(String strategyMethodName) {
        this.strategyMethodName = strategyMethodName;
    }

    public Boolean getStrategyMethodAllowNull() {
        return this.strategyMethodAllowNull;
    }

    public void setStrategyMethodAllowNull(Boolean strategyMethodAllowNull) {
        this.strategyMethodAllowNull = strategyMethodAllowNull;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public Boolean getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(Boolean stopOnException) {
        this.stopOnException = stopOnException;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public Boolean getStreaming() {
        return this.streaming;
    }

    public void setStreaming(Boolean streaming) {
        this.streaming = streaming;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getOnPrepareRef() {
        return this.onPrepareRef;
    }

    public void setOnPrepareRef(String onPrepareRef) {
        this.onPrepareRef = onPrepareRef;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    public Boolean getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(Boolean shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Boolean getParallelAggregate() {
        return this.parallelAggregate;
    }

    public void setParallelAggregate(Boolean parallelAggregate) {
        this.parallelAggregate = parallelAggregate;
    }

    public Boolean getStopOnAggregateException() {
        return this.stopOnAggregateException;
    }

    public void setStopOnAggregateException(Boolean stopOnAggregateException) {
        this.stopOnAggregateException = stopOnAggregateException;
    }
}

