/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.fill;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.fill.JRFillXySeries;
import net.sf.jasperreports.charts.util.XYDatasetLabelGenerator;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillChartDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class JRFillXyDataset
extends JRFillChartDataset
implements JRXyDataset {
    protected JRFillXySeries[] xySeries = null;
    private List seriesNames = null;
    private Map seriesMap = null;
    private Map labelsMap = null;

    public JRFillXyDataset(JRXyDataset xyDataset, JRFillObjectFactory factory) {
        super(xyDataset, factory);
        JRXySeries[] srcXySeries = xyDataset.getSeries();
        if (srcXySeries != null && srcXySeries.length > 0) {
            this.xySeries = new JRFillXySeries[srcXySeries.length];
            for (int i = 0; i < this.xySeries.length; ++i) {
                this.xySeries[i] = (JRFillXySeries)factory.getXySeries(srcXySeries[i]);
            }
        }
    }

    public JRXySeries[] getSeries() {
        return this.xySeries;
    }

    protected void customInitialize() {
        this.seriesNames = null;
        this.seriesMap = null;
        this.labelsMap = null;
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        if (this.xySeries != null && this.xySeries.length > 0) {
            for (int i = 0; i < this.xySeries.length; ++i) {
                this.xySeries[i].evaluate(calculator);
            }
        }
    }

    protected void customIncrement() {
        if (this.xySeries != null && this.xySeries.length > 0) {
            if (this.seriesNames == null) {
                this.seriesNames = new ArrayList();
                this.seriesMap = new HashMap();
                this.labelsMap = new HashMap();
            }
            for (int i = 0; i < this.xySeries.length; ++i) {
                JRFillXySeries crtXySeries = this.xySeries[i];
                Comparable seriesName = crtXySeries.getSeries();
                XYSeries xySrs = (XYSeries)this.seriesMap.get(seriesName);
                if (xySrs == null) {
                    xySrs = new XYSeries(seriesName);
                    this.seriesNames.add(seriesName);
                    this.seriesMap.put(seriesName, xySrs);
                }
                xySrs.addOrUpdate(crtXySeries.getXValue(), crtXySeries.getYValue());
                if (crtXySeries.getLabelExpression() == null) continue;
                HashMap<Number, String> seriesLabels = (HashMap<Number, String>)this.labelsMap.get(seriesName);
                if (seriesLabels == null) {
                    seriesLabels = new HashMap<Number, String>();
                    this.labelsMap.put(seriesName, seriesLabels);
                }
                seriesLabels.put(crtXySeries.getXValue(), crtXySeries.getLabel());
            }
        }
    }

    public Dataset getCustomDataset() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        if (this.seriesNames != null) {
            for (int i = 0; i < this.seriesNames.size(); ++i) {
                Comparable seriesName = (Comparable)this.seriesNames.get(i);
                dataset.addSeries((XYSeries)this.seriesMap.get(seriesName));
            }
        }
        return dataset;
    }

    public byte getDatasetType() {
        return 3;
    }

    public XYDatasetLabelGenerator getLabelGenerator() {
        return new XYDatasetLabelGenerator(this.labelsMap);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }
}

