/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.phoenix;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.TimeUnit;

public final class DatatypeConverter {
    private static final Map<String, ResourceType> STRING_TO_RESOURCE_TYPE_MAP = new HashMap<String, ResourceType>();
    private static final Map<ResourceType, String> RESOURCE_TYPE_TO_STRING_MAP;
    private static final Map<String, TimeUnit> STRING_TO_TIME_UNITS_MAP;
    private static final Map<TimeUnit, String> TIME_UNITS_TO_STRING_MAP;
    private static Map<String, RelationType> NAME_TO_RELATION_TYPE;
    private static Map<RelationType, String> RELATION_TYPE_TO_NAME;
    private static Map<String, Day> NAME_TO_DAY;
    private static Map<Day, String> DAY_TO_NAME;
    private static final ThreadLocal<DateFormat> DATE_FORMAT;

    public static final UUID parseUUID(String string) {
        return UUID.fromString(string);
    }

    public static String printUUID(UUID uUID) {
        return uUID.toString();
    }

    public static final String printInteger(Integer n) {
        return n == null ? null : n.toString();
    }

    public static final Integer parseInteger(String string) {
        return Integer.valueOf(string);
    }

    public static final ResourceType parseResourceType(String string) {
        return STRING_TO_RESOURCE_TYPE_MAP.get(string);
    }

    public static final String printResourceType(ResourceType resourceType) {
        return RESOURCE_TYPE_TO_STRING_MAP.get(resourceType);
    }

    public static final RelationType parseRelationType(String string) {
        return NAME_TO_RELATION_TYPE.get(string);
    }

    public static final String printRelationType(RelationType relationType) {
        return RELATION_TYPE_TO_NAME.get(relationType);
    }

    public static final TimeUnit parseTimeUnits(String string) {
        return STRING_TO_TIME_UNITS_MAP.get(string);
    }

    public static final String printTimeUnits(TimeUnit timeUnit) {
        return TIME_UNITS_TO_STRING_MAP.get(timeUnit);
    }

    public static final String printDateTime(Date date) {
        return date == null ? null : DatatypeConverter.getDateFormat().format(date);
    }

    public static final Date parseDateTime(String string) {
        Date date = null;
        if (string != null && string.length() != 0) {
            try {
                date = DatatypeConverter.getDateFormat().parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }

    private static final DateFormat getDateFormat() {
        DateFormat dateFormat = DATE_FORMAT.get();
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
            dateFormat.setLenient(false);
            DATE_FORMAT.set(dateFormat);
        }
        return dateFormat;
    }

    public static final Duration parseDuration(String string) {
        int n;
        Duration duration = null;
        if (string != null && (n = string.indexOf(32)) != -1) {
            double d = Double.parseDouble(string.substring(0, n));
            TimeUnit timeUnit = DatatypeConverter.parseTimeUnits(string.substring(n + 1));
            duration = Duration.getInstance(d, timeUnit);
        }
        return duration;
    }

    public static final String printDuration(Duration duration) {
        String string = null;
        if (duration != null) {
            string = duration.getDuration() + " " + DatatypeConverter.printTimeUnits(duration.getUnits());
        }
        return string;
    }

    public static final Day parseDay(String string) {
        return NAME_TO_DAY.get(string);
    }

    public static final String printFinishDateTime(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(6, 1);
            date = calendar.getTime();
        }
        return date == null ? null : DatatypeConverter.getDateFormat().format(date);
    }

    public static final Date parseFinishDateTime(String string) {
        Date date = DatatypeConverter.parseDateTime(string);
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(6, -1);
            date = calendar.getTime();
        }
        return date;
    }

    public static final String printDay(Day day) {
        return DAY_TO_NAME.get(day);
    }

    static {
        STRING_TO_RESOURCE_TYPE_MAP.put("Labor", ResourceType.WORK);
        STRING_TO_RESOURCE_TYPE_MAP.put("Non-Labor", ResourceType.MATERIAL);
        RESOURCE_TYPE_TO_STRING_MAP = new EnumMap<ResourceType, String>(ResourceType.class);
        RESOURCE_TYPE_TO_STRING_MAP.put(ResourceType.WORK, "Labor");
        RESOURCE_TYPE_TO_STRING_MAP.put(ResourceType.MATERIAL, "Non-Labor");
        RESOURCE_TYPE_TO_STRING_MAP.put(ResourceType.COST, "Non-Labor");
        STRING_TO_TIME_UNITS_MAP = new HashMap<String, TimeUnit>();
        STRING_TO_TIME_UNITS_MAP.put("Days", TimeUnit.DAYS);
        STRING_TO_TIME_UNITS_MAP.put("days", TimeUnit.DAYS);
        STRING_TO_TIME_UNITS_MAP.put("day", TimeUnit.DAYS);
        TIME_UNITS_TO_STRING_MAP = new EnumMap<TimeUnit, String>(TimeUnit.class);
        TIME_UNITS_TO_STRING_MAP.put(TimeUnit.DAYS, "Days");
        NAME_TO_RELATION_TYPE = new HashMap<String, RelationType>();
        NAME_TO_RELATION_TYPE.put("FinishToFinish", RelationType.FINISH_FINISH);
        NAME_TO_RELATION_TYPE.put("FinishToStart", RelationType.FINISH_START);
        NAME_TO_RELATION_TYPE.put("StartToFinish", RelationType.START_FINISH);
        NAME_TO_RELATION_TYPE.put("StartToStart", RelationType.START_START);
        RELATION_TYPE_TO_NAME = new HashMap<RelationType, String>();
        RELATION_TYPE_TO_NAME.put(RelationType.FINISH_FINISH, "FinishToFinish");
        RELATION_TYPE_TO_NAME.put(RelationType.FINISH_START, "FinishToStart");
        RELATION_TYPE_TO_NAME.put(RelationType.START_FINISH, "StartToFinish");
        RELATION_TYPE_TO_NAME.put(RelationType.START_START, "StartToStart");
        NAME_TO_DAY = new HashMap<String, Day>();
        NAME_TO_DAY.put("Mon", Day.MONDAY);
        NAME_TO_DAY.put("Tue", Day.TUESDAY);
        NAME_TO_DAY.put("Wed", Day.WEDNESDAY);
        NAME_TO_DAY.put("Thu", Day.THURSDAY);
        NAME_TO_DAY.put("Fri", Day.FRIDAY);
        NAME_TO_DAY.put("Sat", Day.SATURDAY);
        NAME_TO_DAY.put("Sun", Day.SUNDAY);
        DAY_TO_NAME = new HashMap<Day, String>();
        DAY_TO_NAME.put(Day.MONDAY, "Mon");
        DAY_TO_NAME.put(Day.TUESDAY, "Tue");
        DAY_TO_NAME.put(Day.WEDNESDAY, "Wed");
        DAY_TO_NAME.put(Day.THURSDAY, "Thu");
        DAY_TO_NAME.put(Day.FRIDAY, "Fri");
        DAY_TO_NAME.put(Day.SATURDAY, "Sat");
        DAY_TO_NAME.put(Day.SUNDAY, "Sun");
        DATE_FORMAT = new ThreadLocal();
    }
}

