/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.android;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import processing.app.Base;
import processing.app.EditorToolbar;
import processing.app.Mode;
import processing.app.SketchException;
import processing.core.PApplet;
import processing.mode.android.AndroidBuild;
import processing.mode.android.AndroidMode;
import processing.mode.android.AndroidSDK;
import processing.mode.android.AndroidToolbar;
import processing.mode.android.Devices;
import processing.mode.android.Keys;
import processing.mode.android.Permissions;
import processing.mode.java.JavaEditor;

public class AndroidEditor
extends JavaEditor {
    private AndroidMode amode;

    protected AndroidEditor(Base base, String path, int[] location, Mode mode) throws Exception {
        super(base, path, location, mode);
        this.amode = (AndroidMode)mode;
        AndroidSDK sdk = this.amode.loadSDK();
        if (sdk == null) {
            sdk = AndroidSDK.locate(this);
        }
    }

    public EditorToolbar createToolbar() {
        return new AndroidToolbar(this, this.base);
    }

    public JMenu buildFileMenu() {
        String exportTitle = AndroidToolbar.getTitle(5, false);
        JMenuItem exportProject = Base.newJMenuItem(exportTitle, 69);
        exportProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AndroidEditor.this.handleExportProject();
            }
        });
        exportTitle = AndroidToolbar.getTitle(5, true);
        JMenuItem exportPackage = Base.newJMenuItemShift(exportTitle, 69);
        exportPackage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AndroidEditor.this.handleExportApplication();
            }
        });
        return this.buildFileMenu(new JMenuItem[]{exportProject, exportPackage});
    }

    public JMenu buildSketchMenu() {
        JMenuItem runItem = Base.newJMenuItem(AndroidToolbar.getTitle(0, false), 82);
        runItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AndroidEditor.this.handleRunEmulator();
            }
        });
        JMenuItem presentItem = Base.newJMenuItemShift(AndroidToolbar.getTitle(0, true), 82);
        presentItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AndroidEditor.this.handleRunDevice();
            }
        });
        JMenuItem stopItem = new JMenuItem(AndroidToolbar.getTitle(1, false));
        stopItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AndroidEditor.this.handleStop();
            }
        });
        return this.buildSketchMenu(new JMenuItem[]{runItem, presentItem, stopItem});
    }

    public JMenu buildModeMenu() {
        JMenu menu = new JMenu("Android");
        JMenuItem item = new JMenuItem("Sketch Permissions");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Permissions(AndroidEditor.this.sketch);
            }
        });
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Signing Key Setup");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new Keys(AndroidEditor.this);
            }
        });
        item.setEnabled(false);
        menu.add(item);
        item = new JMenuItem("Android SDK & AVD Manager");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File file = AndroidEditor.this.amode.getSDK().getAndroidTool();
                PApplet.exec((String[])new String[]{file.getAbsolutePath()});
            }
        });
        menu.add(item);
        item = new JMenuItem("Reset Connections");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Devices.killAdbServer();
            }
        });
        menu.add(item);
        return menu;
    }

    public JMenu buildHelpMenu() {
        JMenu menu = super.buildHelpMenu();
        menu.addSeparator();
        JMenuItem item = new JMenuItem("Processing for Android Wiki");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://wiki.processing.org/w/Android");
            }
        });
        menu.add(item);
        item = new JMenuItem("Android Developers Site");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.openURL("http://developer.android.com/index.html");
            }
        });
        menu.add(item);
        return menu;
    }

    public void showReference(String filename) {
        File javaReferenceFolder = Base.getContentFile("modes/java/reference");
        File file = new File(javaReferenceFolder, filename);
        Base.openURL(file.getAbsolutePath());
    }

    public void statusError(String what) {
        super.statusError(what);
        this.toolbar.deactivate(0);
    }

    public void sketchStopped() {
        this.deactivateRun();
        this.statusEmpty();
    }

    public void handleRunEmulator() {
        new Thread(){

            public void run() {
                AndroidEditor.this.toolbar.activate(0);
                AndroidEditor.this.startIndeterminate();
                AndroidEditor.this.prepareRun();
                try {
                    AndroidEditor.this.amode.handleRunEmulator(AndroidEditor.this.sketch, AndroidEditor.this);
                }
                catch (SketchException e) {
                    AndroidEditor.this.statusError(e);
                }
                catch (IOException e) {
                    AndroidEditor.this.statusError(e);
                }
                AndroidEditor.this.stopIndeterminate();
            }
        }.start();
    }

    public void handleRunDevice() {
        new Thread(){

            public void run() {
                AndroidEditor.this.toolbar.activate(0);
                AndroidEditor.this.startIndeterminate();
                AndroidEditor.this.prepareRun();
                try {
                    AndroidEditor.this.amode.handleRunDevice(AndroidEditor.this.sketch, AndroidEditor.this);
                }
                catch (SketchException e) {
                    AndroidEditor.this.statusError(e);
                }
                catch (IOException e) {
                    AndroidEditor.this.statusError(e);
                }
                AndroidEditor.this.stopIndeterminate();
            }
        }.start();
    }

    public void handleStop() {
        this.toolbar.deactivate(0);
        this.stopIndeterminate();
        this.amode.handleStop(this);
    }

    public void handleExportProject() {
        if (this.handleExportCheckModified()) {
            new Thread(){

                public void run() {
                    AndroidEditor.this.toolbar.activate(5);
                    AndroidEditor.this.startIndeterminate();
                    AndroidEditor.this.statusNotice("Exporting a debug version of the sketch...");
                    AndroidBuild build = new AndroidBuild(AndroidEditor.this.sketch, AndroidEditor.this.amode);
                    try {
                        File exportFolder = build.exportProject();
                        if (exportFolder != null) {
                            Base.openFolder(exportFolder);
                            AndroidEditor.this.statusNotice("Done with export.");
                        }
                    }
                    catch (IOException e) {
                        AndroidEditor.this.statusError(e);
                    }
                    catch (SketchException e) {
                        AndroidEditor.this.statusError(e);
                    }
                    AndroidEditor.this.stopIndeterminate();
                    AndroidEditor.this.toolbar.deactivate(5);
                }
            }.start();
        }
    }

    public void handleExportPackage() {
        this.statusError("Exporting signed packages is not yet implemented.");
        this.deactivateExport();
    }
}

