/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp.user;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.guacamole.form.BooleanField;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.net.auth.DelegatingUser;
import org.apache.guacamole.net.auth.User;

public class TOTPUser
extends DelegatingUser {
    public static final String TOTP_KEY_SECRET_ATTRIBUTE_NAME = "guac-totp-key-secret";
    public static final String TOTP_KEY_CONFIRMED_ATTRIBUTE_NAME = "guac-totp-key-confirmed";
    public static final String TOTP_KEY_SECRET_RESET_FIELD = "guac-totp-reset";
    public static final Form TOTP_CONFIG_FORM = new Form("totp-config-form", Arrays.asList(new BooleanField("guac-totp-reset", "true"), new BooleanField("guac-totp-key-confirmed", "true")));

    public TOTPUser(User user) {
        super(user);
    }

    public User getUndecorated() {
        return this.getDelegateUser();
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>(super.getAttributes());
        String secret = (String)attributes.remove(TOTP_KEY_SECRET_ATTRIBUTE_NAME);
        if (secret == null || secret.isEmpty()) {
            attributes.put(TOTP_KEY_SECRET_RESET_FIELD, "true");
        } else {
            attributes.put(TOTP_KEY_SECRET_RESET_FIELD, "false");
        }
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        attributes = new HashMap<String, String>(attributes);
        attributes.remove(TOTP_KEY_SECRET_ATTRIBUTE_NAME);
        String reset = attributes.remove(TOTP_KEY_SECRET_RESET_FIELD);
        if (reset != null && reset.equals("true")) {
            attributes.put(TOTP_KEY_SECRET_ATTRIBUTE_NAME, null);
            attributes.put(TOTP_KEY_CONFIRMED_ATTRIBUTE_NAME, null);
        }
        super.setAttributes(attributes);
    }
}

