// Generated by gmmproc 2.78.0 -- DO NOT MODIFY!
#ifndef _ATKMM_OBJECT_H
#define _ATKMM_OBJECT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <glibmm/object.h>
#include <atkmm/component.h>
#include <atkmm/relation.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef struct _AtkPropertyValues AtkPropertyValues; }
#endif


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using AtkObject = struct _AtkObject;
using AtkObjectClass = struct _AtkObjectClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Atk
{ class ATKMM_API Object_Class; } // namespace Atk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Atk
{


/** @addtogroup atkmmEnums atkmm Enums and Flags */

/** 
 *  @var Role INVALID
 * Invalid role.
 * 
 *  @var Role ACCEL_LABEL
 * A label which represents an accelerator.
 * 
 *  @var Role ALERT
 * An object which is an alert to the user. Assistive Technologies typically respond to ATK_ROLE_ALERT by reading the entire onscreen contents of containers advertising this role.  Should be used for warning dialogs, etc.
 * 
 *  @var Role ANIMATION
 * An object which is an animated image.
 * 
 *  @var Role ARROW
 * An arrow in one of the four cardinal directions.
 * 
 *  @var Role CALENDAR
 * An object that displays a calendar and allows the user to select a date.
 * 
 *  @var Role CANVAS
 * An object that can be drawn into and is used to trap events.
 * 
 *  @var Role CHECK_BOX
 * A choice that can be checked or unchecked and provides a separate indicator for the current state.
 * 
 *  @var Role CHECK_MENU_ITEM
 * A menu item with a check box.
 * 
 *  @var Role COLOR_CHOOSER
 * A specialized dialog that lets the user choose a color.
 * 
 *  @var Role COLUMN_HEADER
 * The header for a column of data.
 * 
 *  @var Role COMBO_BOX
 * A collapsible list of choices the user can select from.
 * 
 *  @var Role DATE_EDITOR
 * An object whose purpose is to allow a user to edit a date.
 * 
 *  @var Role DESKTOP_ICON
 * An inconifed internal frame within a DESKTOP_PANE.
 * 
 *  @var Role DESKTOP_FRAME
 * A pane that supports internal frames and iconified versions of those internal frames.
 * 
 *  @var Role DIAL
 * An object whose purpose is to allow a user to set a value.
 * 
 *  @var Role DIALOG
 * A top level window with title bar and a border.
 * 
 *  @var Role DIRECTORY_PANE
 * A pane that allows the user to navigate through and select the contents of a directory.
 * 
 *  @var Role DRAWING_AREA
 * An object used for drawing custom user interface elements.
 * 
 *  @var Role FILE_CHOOSER
 * A specialized dialog that lets the user choose a file.
 * 
 *  @var Role FILLER
 * A object that fills up space in a user interface.
 * 
 *  @var Role FONT_CHOOSER
 * A specialized dialog that lets the user choose a font.
 * 
 *  @var Role FRAME
 * A top level window with a title bar, border, menubar, etc.
 * 
 *  @var Role GLASS_PANE
 * A pane that is guaranteed to be painted on top of all panes beneath it.
 * 
 *  @var Role HTML_CONTAINER
 * A document container for HTML, whose children represent the document content.
 * 
 *  @var Role ICON
 * A small fixed size picture, typically used to decorate components.
 * 
 *  @var Role IMAGE
 * An object whose primary purpose is to display an image.
 * 
 *  @var Role INTERNAL_FRAME
 * A frame-like object that is clipped by a desktop pane.
 * 
 *  @var Role LABEL
 * An object used to present an icon or short string in an interface.
 * 
 *  @var Role LAYERED_PANE
 * A specialized pane that allows its children to be drawn in layers, providing a form of stacking order.
 * 
 *  @var Role LIST
 * An object that presents a list of objects to the user and allows the user to select one or more of them.
 * 
 *  @var Role LIST_ITEM
 * An object that represents an element of a list.
 * 
 *  @var Role MENU
 * An object usually found inside a menu bar that contains a list of actions the user can choose from.
 * 
 *  @var Role MENU_BAR
 * An object usually drawn at the top of the primary dialog box of an application that contains a list of menus the user can choose from.
 * 
 *  @var Role MENU_ITEM
 * An object usually contained in a menu that presents an action the user can choose.
 * 
 *  @var Role OPTION_PANE
 * A specialized pane whose primary use is inside a DIALOG.
 * 
 *  @var Role PAGE_TAB
 * An object that is a child of a page tab list.
 * 
 *  @var Role PAGE_TAB_LIST
 * An object that presents a series of panels (or page tabs), one at a time, through some mechanism provided by the object.
 * 
 *  @var Role PANEL
 * A generic container that is often used to group objects.
 * 
 *  @var Role PASSWORD_TEXT
 * A text object uses for passwords, or other places where the text content is not shown visibly to the user.
 * 
 *  @var Role POPUP_MENU
 * A temporary window that is usually used to offer the user a list of choices, and then hides when the user selects one of those choices.
 * 
 *  @var Role PROGRESS_BAR
 * An object used to indicate how much of a task has been completed.
 * 
 *  @var Role PUSH_BUTTON
 * An object the user can manipulate to tell the application to do something.
 * 
 *  @var Role RADIO_BUTTON
 * A specialized check box that will cause other radio buttons in the same group to become unchecked when this one is checked.
 * 
 *  @var Role RADIO_MENU_ITEM
 * A check menu item which belongs to a group. At each instant exactly one of the radio menu items from a group is selected.
 * 
 *  @var Role ROOT_PANE
 * A specialized pane that has a glass pane and a layered pane as its children.
 * 
 *  @var Role ROW_HEADER
 * The header for a row of data.
 * 
 *  @var Role SCROLL_BAR
 * An object usually used to allow a user to incrementally view a large amount of data.
 * 
 *  @var Role SCROLL_PANE
 * An object that allows a user to incrementally view a large amount of information.
 * 
 *  @var Role SEPARATOR
 * An object usually contained in a menu to provide a visible and logical separation of the contents in a menu.
 * 
 *  @var Role SLIDER
 * An object that allows the user to select from a bounded range.
 * 
 *  @var Role SPLIT_PANE
 * A specialized panel that presents two other panels at the same time.
 * 
 *  @var Role SPIN_BUTTON
 * An object used to get an integer or floating point number from the user.
 * 
 *  @var Role STATUSBAR
 * An object which reports messages of minor importance to the user.
 * 
 *  @var Role TABLE
 * An object used to represent information in terms of rows and columns.
 * 
 *  @var Role TABLE_CELL
 * A cell in a table.
 * 
 *  @var Role TABLE_COLUMN_HEADER
 * The header for a column of a table.
 * 
 *  @var Role TABLE_ROW_HEADER
 * The header for a row of a table.
 * 
 *  @var Role TEAR_OFF_MENU_ITEM
 * A menu item used to tear off and reattach its menu.
 * 
 *  @var Role TERMINAL
 * An object that represents an accessible terminal.  (Since: 0.6).
 * 
 *  @var Role TEXT
 * An interactive widget that supports multiple lines of text and
 * optionally accepts user input, but whose purpose is not to solicit user input.
 * Thus ATK_ROLE_TEXT is appropriate for the text view in a plain text editor
 * but inappropriate for an input field in a dialog box or web form. For widgets
 * whose purpose is to solicit input from the user, see ATK_ROLE_ENTRY and
 * ATK_ROLE_PASSWORD_TEXT. For generic objects which display a brief amount of
 * textual information, see ATK_ROLE_STATIC.
 * 
 *  @var Role TOGGLE_BUTTON
 * A specialized push button that can be checked or unchecked, but does not provide a separate indicator for the current state.
 * 
 *  @var Role TOOL_BAR
 * A bar or palette usually composed of push buttons or toggle buttons.
 * 
 *  @var Role TOOL_TIP
 * An object that provides information about another object.
 * 
 *  @var Role TREE
 * An object used to represent hierarchical information to the user.
 * 
 *  @var Role TREE_TABLE
 * An object capable of expanding and collapsing rows as well as showing multiple columns of data.   (Since: 0.7).
 * 
 *  @var Role UNKNOWN
 * The object contains some Accessible information, but its role is not known.
 * 
 *  @var Role VIEWPORT
 * An object usually used in a scroll pane.
 * 
 *  @var Role WINDOW
 * A top level window with no title or border.
 * 
 *  @var Role HEADER
 * An object that serves as a document header. (Since: 1.1.1).
 * 
 *  @var Role FOOTER
 * An object that serves as a document footer.  (Since: 1.1.1).
 * 
 *  @var Role PARAGRAPH
 * An object which is contains a paragraph of text content.   (Since: 1.1.1).
 * 
 *  @var Role RULER
 * An object which describes margins and tab stops, etc. for text objects which it controls (should have CONTROLLER_FOR relation to such).   (Since: 1.1.1).
 * 
 *  @var Role APPLICATION
 * The object is an application object, which may contain @a ATK_ROLE_FRAME objects or other types of accessibles.  The root accessible of any application's ATK hierarchy should have ATK_ROLE_APPLICATION.   (Since: 1.1.4).
 * 
 *  @var Role AUTOCOMPLETE
 * The object is a dialog or list containing items for insertion into an entry widget, for instance a list of words for completion of a text entry.   (Since: 1.3).
 * 
 *  @var Role EDITBAR
 * The object is an editable text object in a toolbar.  (Since: 1.5).
 * 
 *  @var Role EMBEDDED
 * The object is an embedded container within a document or panel.  This role is a grouping "hint" indicating that the contained objects share a context.  (Since: 1.7.2).
 * 
 *  @var Role ENTRY
 * The object is a component whose textual content may be entered or modified by the user, provided @a ATK_STATE_EDITABLE is present.   (Since: 1.11).
 * 
 *  @var Role CHART
 * The object is a graphical depiction of quantitative data. It may contain multiple subelements whose attributes and/or description may be queried to obtain both the quantitative data and information about how the data is being presented. The LABELLED_BY relation is particularly important in interpreting objects of this type, as is the accessible-description property.  (Since: 1.11).
 * 
 *  @var Role CAPTION
 * The object contains descriptive information, usually textual, about another user interface element such as a table, chart, or image.  (Since: 1.11).
 * 
 *  @var Role DOCUMENT_FRAME
 * The object is a visual frame or container which contains a view of document content. Document frames may occur within another Document instance, in which case the second document may be said to be embedded in the containing instance. HTML frames are often ROLE_DOCUMENT_FRAME. Either this object, or a singleton descendant, should implement the Document interface.  (Since: 1.11).
 * 
 *  @var Role HEADING
 * The object serves as a heading for content which follows it in a document. The 'heading level' of the heading, if availabe, may be obtained by querying the object's attributes.
 * 
 *  @var Role PAGE
 * The object is a containing instance which encapsulates a page of information. @a ATK_ROLE_PAGE is used in documents and content which support a paginated navigation model.  (Since: 1.11).
 * 
 *  @var Role SECTION
 * The object is a containing instance of document content which constitutes a particular 'logical' section of the document. The type of content within a section, and the nature of the section division itself, may be obtained by querying the object's attributes. Sections may be nested. (Since: 1.11).
 * 
 *  @var Role REDUNDANT_OBJECT
 * The object is redundant with another object in the hierarchy, and is exposed for purely technical reasons.  Objects of this role should normally be ignored by clients. (Since: 1.11).
 * 
 *  @var Role FORM
 * The object is a container for form controls, for instance as part of a 
 * web form or user-input form within a document.  This role is primarily a tag/convenience for 
 * clients when navigating complex documents, it is not expected that ordinary GUI containers will 
 * always have ATK_ROLE_FORM. (Since: 1.12.0).
 * 
 *  @var Role LINK
 * The object is a hypertext anchor, i.e. a "link" in a
 * hypertext document.  Such objects are distinct from 'inline'
 * content which may also use the Hypertext/Hyperlink interfaces
 * to indicate the range/location within a text object where
 * an inline or embedded object lies.  (Since: 1.12.1).
 * 
 *  @var Role INPUT_METHOD_WINDOW
 * The object is a window or similar viewport 
 * which is used to allow composition or input of a 'complex character',
 * in other words it is an "input method window." (Since: 1.12.1).
 * 
 *  @var Role TABLE_ROW
 * A row in a table.  (Since: 2.1.0).
 * 
 *  @var Role TREE_ITEM
 * An object that represents an element of a tree.  (Since: 2.1.0).
 * 
 *  @var Role DOCUMENT_SPREADSHEET
 * A document frame which contains a spreadsheet.  (Since: 2.1.0).
 * 
 *  @var Role DOCUMENT_PRESENTATION
 * A document frame which contains a presentation or slide content.  (Since: 2.1.0).
 * 
 *  @var Role DOCUMENT_TEXT
 * A document frame which contains textual content, such as found in a word processing application.  (Since: 2.1.0).
 * 
 *  @var Role DOCUMENT_WEB
 * A document frame which contains HTML or other markup suitable for display in a web browser.  (Since: 2.1.0).
 * 
 *  @var Role DOCUMENT_EMAIL
 * A document frame which contains email content to be displayed or composed either in plain text or HTML.  (Since: 2.1.0).
 * 
 *  @var Role COMMENT
 * An object found within a document and designed to present a comment, note, or other annotation. In some cases, this object might not be visible until activated.  (Since: 2.1.0).
 * 
 *  @var Role LIST_BOX
 * A non-collapsible list of choices the user can select from. (Since: 2.1.0).
 * 
 *  @var Role GROUPING
 * A group of related widgets. This group typically has a label. (Since: 2.1.0).
 * 
 *  @var Role IMAGE_MAP
 * An image map object. Usually a graphic with multiple hotspots, where each hotspot can be activated resulting in the loading of another document or section of a document. (Since: 2.1.0).
 * 
 *  @var Role NOTIFICATION
 * A transitory object designed to present a message to the user, typically at the desktop level rather than inside a particular application.  (Since: 2.1.0).
 * 
 *  @var Role INFO_BAR
 * An object designed to present a message to the user within an existing window. (Since: 2.1.0).
 * 
 *  @var Role LEVEL_BAR
 * A bar that serves as a level indicator to, for instance, show the strength of a password or the state of a battery.  (Since: 2.7.3).
 * 
 *  @var Role TITLE_BAR
 * A bar that serves as the title of a window or a
 * dialog. (Since: 2.12).
 * 
 *  @var Role BLOCK_QUOTE
 * An object which contains a text section
 * that is quoted from another source. (Since: 2.12).
 * 
 *  @var Role AUDIO
 * An object which represents an audio element. (Since: 2.12).
 * 
 *  @var Role VIDEO
 * An object which represents a video element. (Since: 2.12).
 * 
 *  @var Role DEFINITION
 * A definition of a term or concept. (Since: 2.12).
 * 
 *  @var Role ARTICLE
 * A section of a page that consists of a
 * composition that forms an independent part of a document, page, or
 * site. Examples: A blog entry, a news story, a forum post. (Since: 2.12).
 * 
 *  @var Role LANDMARK
 * A region of a web page intended as a
 * navigational landmark. This is designed to allow Assistive
 * Technologies to provide quick navigation among key regions within a
 * document. (Since: 2.12).
 * 
 *  @var Role LOG
 * A text widget or container holding log content, such
 * as chat history and error logs. In this role there is a
 * relationship between the arrival of new items in the log and the
 * reading order. The log contains a meaningful sequence and new
 * information is added only to the end of the log, not at arbitrary
 * points. (Since: 2.12).
 * 
 *  @var Role MARQUEE
 * A container where non-essential information
 * changes frequently. Common usages of marquee include stock tickers
 * and ad banners. The primary difference between a marquee and a log
 * is that logs usually have a meaningful order or sequence of
 * important content changes. (Since: 2.12).
 * 
 *  @var Role MATH
 * A text widget or container that holds a mathematical
 * expression. (Since: 2.12).
 * 
 *  @var Role RATING
 * A widget whose purpose is to display a rating,
 * such as the number of stars associated with a song in a media
 * player. Objects of this role should also implement
 * AtkValue. (Since: 2.12).
 * 
 *  @var Role TIMER
 * An object containing a numerical counter which
 * indicates an amount of elapsed time from a start point, or the time
 * remaining until an end point. (Since: 2.12).
 * 
 *  @var Role DESCRIPTION_LIST
 * An object that represents a list of
 * term-value groups. A term-value group represents a individual
 * description and consist of one or more names
 * (ATK_ROLE_DESCRIPTION_TERM) followed by one or more values
 * (ATK_ROLE_DESCRIPTION_VALUE). For each list, there should not be
 * more than one group with the same term name. (Since: 2.12).
 * 
 *  @var Role DESCRIPTION_TERM
 * An object that represents a term or phrase
 * with a corresponding definition. (Since: 2.12).
 * 
 *  @var Role DESCRIPTION_VALUE
 * An object that represents the
 * description, definition or value of a term. (Since: 2.12).
 * 
 *  @var Role STATIC
 * A generic non-container object whose purpose is to display a
 * brief amount of information to the user and whose role is known by the
 * implementor but lacks semantic value for the user. Examples in which
 * Atk::Role::STATIC is appropriate include the message displayed in a message box
 * and an image used as an alternative means to display text. Atk::Role::STATIC
 * should not be applied to widgets which are traditionally interactive, objects
 * which display a significant amount of content, or any object which has an
 * accessible relation pointing to another object. Implementors should expose the
 * displayed information through the accessible name of the object. If doing so seems
 * inappropriate, it may indicate that a different role should be used. For
 * labels which describe another widget, see Atk::Role::LABEL. For text views, see
 * Atk::Role::TEXT. For generic containers, see Atk::Role::PANEL. For objects whose
 * role is not known by the implementor, see Atk::Role::UNKNOWN. (Since: 2.16).
 * 
 *  @var Role MATH_FRACTION
 * An object that represents a mathematical fraction.
 * (Since: 2.16).
 * 
 *  @var Role MATH_ROOT
 * An object that represents a mathematical expression
 * displayed with a radical. (Since: 2.16).
 * 
 *  @var Role SUBSCRIPT
 * An object that contains text that is displayed as a
 * subscript. (Since: 2.16).
 * 
 *  @var Role SUPERSCRIPT
 * An object that contains text that is displayed as a
 * superscript. (Since: 2.16).
 * 
 *  @var Role FOOTNOTE
 * An object that contains the text of a footnote. (Since: 2.26).
 * 
 *  @var Role CONTENT_DELETION
 * Content previously deleted or proposed to be
 * deleted, e.g. in revision history or a content view providing suggestions
 * from reviewers. (Since: 2.34).
 * 
 *  @var Role CONTENT_INSERTION
 * Content previously inserted or proposed to be
 * inserted, e.g. in revision history or a content view providing suggestions
 * from reviewers. (Since: 2.34).
 * 
 *  @var Role MARK
 * A run of content that is marked or highlighted, such as for
 * reference purposes, or to call it out as having a special purpose. If the
 * marked content has an associated section in the document elaborating on the
 * reason for the mark, then Atk::Relation::Type::DETAILS should be used on the mark
 * to point to that associated section. In addition, the reciprocal relation
 * Atk::Relation::Type::DETAILS_FOR should be used on the associated content section
 * to point back to the mark. (Since: 2.36).
 * 
 *  @var Role SUGGESTION
 * A container for content that is called out as a proposed
 * change from the current version of the document, such as by a reviewer of the
 * content. This role should include either Atk::Role::CONTENT_DELETION and/or
 * Atk::Role::CONTENT_INSERTION children, in any order, to indicate what the
 * actual change is. (Since: 2.36).
 * 
 *  @var Role LAST_DEFINED
 * Not a valid role, used for finding end of the enumeration.
 * 
 *  @enum Role
 * 
 * Describes the role of an object
 * 
 * These are the built-in enumerated roles that UI components can have
 * in ATK.  Other roles may be added at runtime, so an AtkRole >=
 * Atk::Role::LAST_DEFINED is not necessarily an error.
 *
 * @ingroup atkmmEnums
 */
enum class Role
{
  INVALID,
  ACCEL_LABEL,
  ALERT,
  ANIMATION,
  ARROW,
  CALENDAR,
  CANVAS,
  CHECK_BOX,
  CHECK_MENU_ITEM,
  COLOR_CHOOSER,
  COLUMN_HEADER,
  COMBO_BOX,
  DATE_EDITOR,
  DESKTOP_ICON,
  DESKTOP_FRAME,
  DIAL,
  DIALOG,
  DIRECTORY_PANE,
  DRAWING_AREA,
  FILE_CHOOSER,
  FILLER,
  FONT_CHOOSER,
  FRAME,
  GLASS_PANE,
  HTML_CONTAINER,
  ICON,
  IMAGE,
  INTERNAL_FRAME,
  LABEL,
  LAYERED_PANE,
  LIST,
  LIST_ITEM,
  MENU,
  MENU_BAR,
  MENU_ITEM,
  OPTION_PANE,
  PAGE_TAB,
  PAGE_TAB_LIST,
  PANEL,
  PASSWORD_TEXT,
  POPUP_MENU,
  PROGRESS_BAR,
  PUSH_BUTTON,
  RADIO_BUTTON,
  RADIO_MENU_ITEM,
  ROOT_PANE,
  ROW_HEADER,
  SCROLL_BAR,
  SCROLL_PANE,
  SEPARATOR,
  SLIDER,
  SPLIT_PANE,
  SPIN_BUTTON,
  STATUSBAR,
  TABLE,
  TABLE_CELL,
  TABLE_COLUMN_HEADER,
  TABLE_ROW_HEADER,
  TEAR_OFF_MENU_ITEM,
  TERMINAL,
  TEXT,
  TOGGLE_BUTTON,
  TOOL_BAR,
  TOOL_TIP,
  TREE,
  TREE_TABLE,
  UNKNOWN,
  VIEWPORT,
  WINDOW,
  HEADER,
  FOOTER,
  PARAGRAPH,
  RULER,
  APPLICATION,
  AUTOCOMPLETE,
  EDITBAR,
  EMBEDDED,
  ENTRY,
  CHART,
  CAPTION,
  DOCUMENT_FRAME,
  HEADING,
  PAGE,
  SECTION,
  REDUNDANT_OBJECT,
  FORM,
  LINK,
  INPUT_METHOD_WINDOW,
  TABLE_ROW,
  TREE_ITEM,
  DOCUMENT_SPREADSHEET,
  DOCUMENT_PRESENTATION,
  DOCUMENT_TEXT,
  DOCUMENT_WEB,
  DOCUMENT_EMAIL,
  COMMENT,
  LIST_BOX,
  GROUPING,
  IMAGE_MAP,
  NOTIFICATION,
  INFO_BAR,
  LEVEL_BAR,
  TITLE_BAR,
  BLOCK_QUOTE,
  AUDIO,
  VIDEO,
  DEFINITION,
  ARTICLE,
  LANDMARK,
  LOG,
  MARQUEE,
  MATH,
  RATING,
  TIMER,
  DESCRIPTION_LIST,
  DESCRIPTION_TERM,
  DESCRIPTION_VALUE,
  STATIC,
  MATH_FRACTION,
  MATH_ROOT,
  SUBSCRIPT,
  SUPERSCRIPT,
  FOOTNOTE,
  CONTENT_DELETION,
  CONTENT_INSERTION,
  MARK,
  SUGGESTION,
  LAST_DEFINED
};


} // namespace Atk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class ATKMM_API Value<Atk::Role> : public Glib::Value_Enum<Atk::Role>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Atk
{


class ATKMM_API RelationSet;
class ATKMM_API Relation;
class ATKMM_API StateSet;

typedef guint64 State;

/** The base object class for the Accessibility Toolkit API.
 * This class is the primary class for accessibility support via the Accessibility ToolKit (ATK). Objects which are
 * instances of Atk::Object (or instances of Atk::Object-derived types) are queried for properties which relate basic
 * (and generic) properties of a UI component such as name and description. Instances of Atk::Object may also be queried
 * as to whether they implement other ATK interfaces (e.g. Atk::Action, Atk::Component, etc.), as appropriate to the role
 * which a given UI component plays in a user interface.
 *
 * All UI components in an application which provide useful information or services to the user must provide corresponding
 * Atk::Object instances on request (in GTK+, for instance, usually on a call to Gtk::Widget::get_accessible()), either via
 * ATK support built into the toolkit for the widget class or ancestor class, or in the case of custom widgets, if the
 * inherited Atk::Object implementation is insufficient, via instances of a new Atk::Object subclass. 
 */

class ATKMM_API Object : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = Object;
  using CppClassType = Object_Class;
  using BaseObjectType = AtkObject;
  using BaseClassType = AtkObjectClass;

  // noncopyable
  Object(const Object&) = delete;
  Object& operator=(const Object&) = delete;

private:  friend class Object_Class;
  static CppClassType object_class_;

protected:
  explicit Object(const Glib::ConstructParams& construct_params);
  explicit Object(AtkObject* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Object(Object&& src) noexcept;
  Object& operator=(Object&& src) noexcept;

  ~Object() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  AtkObject*       gobj()       { return reinterpret_cast<AtkObject*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const AtkObject* gobj() const { return reinterpret_cast<AtkObject*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  AtkObject* gobj_copy();

private:

   // see wrap_new() implementation in object.ccg
  
public:

  
  /** Gets the accessible name of the accessible.
   * 
   * @return A character string representing the accessible name of the object.
   */
  Glib::ustring get_name() const;
  
  /** Gets the accessible description of the accessible.
   * 
   * @return A character string representing the accessible description
   * of the accessible.
   */
  Glib::ustring get_description() const;
  
  /** Gets the accessible parent of the accessible. By default this is
   * the one assigned with set_parent(), but it is assumed
   * that ATK implementors have ways to get the parent of the object
   * without the need of assigning it manually with
   * set_parent(), and will return it with this method.
   * 
   * If you are only interested on the parent assigned with
   * set_parent(), use peek_parent().
   * 
   * @return An Atk::Object representing the accessible
   * parent of the accessible.
   */
  Glib::RefPtr<Atk::Object> get_parent();
  
  /** Gets the number of accessible children of the accessible.
   * 
   * @return An integer representing the number of accessible children
   * of the accessible.
   */
  int get_n_accessible_children() const;
  
  /** Gets a reference to the specified accessible child of the object.
   * The accessible children are 0-based so the first accessible child is
   * at index 0, the second at index 1 and so on.
   * 
   * @param i A <tt>int</tt> representing the position of the child, starting from 0.
   * @return An Atk::Object representing the specified
   * accessible child of the accessible.
   */
  Glib::RefPtr<Atk::Object> get_accessible_child(int i);
  
  /** Gets the Atk::RelationSet associated with the object.
   * 
   * @return An Atk::RelationSet representing the relation set
   * of the object.
   */
  Glib::RefPtr<RelationSet> get_relation_set();
  
  /** Gets the role of the accessible.
   * 
   * @return An Atk::Role which is the role of the accessible.
   */
  Role get_role() const;
  
  /** Gets a reference to the state set of the accessible; the caller must
   * unreference it when it is no longer needed.
   * 
   * @return A reference to an Atk::StateSet which is the state
   * set of the accessible.
   */
  Glib::RefPtr<StateSet> get_state_set();
  
  /** Gets the 0-based index of this accessible in its parent; returns -1 if the
   * accessible does not have an accessible parent.
   * 
   * @return An integer which is the index of the accessible in its parent.
   */
  int get_index_in_parent();
  
  /** Sets the accessible name of the accessible. You can't set the name
   * to <tt>nullptr</tt>. This is reserved for the initial value. In this aspect
   * <tt>nullptr</tt> is similar to ATK_ROLE_UNKNOWN. If you want to set the name to
   * a empty value you can use "".
   * 
   * @param name A character string to be set as the accessible name.
   */
  void set_name(const Glib::ustring& name);
  
  /** Sets the accessible description of the accessible. You can't set
   * the description to <tt>nullptr</tt>. This is reserved for the initial value. In
   * this aspect <tt>nullptr</tt> is similar to ATK_ROLE_UNKNOWN. If you want to set
   * the name to a empty value you can use "".
   * 
   * @param description A character string to be set as the accessible description.
   */
  void set_description(const Glib::ustring& description);
  
  /** Sets the accessible parent of the accessible. @a parent can be <tt>nullptr</tt>.
   * 
   * @param parent An Atk::Object to be set as the accessible parent.
   */
  void set_parent(const Glib::RefPtr<Atk::Object>& parent);
  
  /** Sets the role of the accessible.
   * 
   * @param role An Atk::Role to be set as the role.
   */
  void set_role(Role role);
  
  /** Emits a state-change signal for the specified state.
   * 
   * Note that as a general rule when the state of an existing object changes,
   * emitting a notification is expected.
   * 
   * @param state An Atk::State whose state is changed.
   * @param value A <tt>bool</tt> which indicates whether the state is being set on or off.
   */
  void notify_state_change(State state, bool value);
  
  
  /** Adds a relationship of the specified type with the specified target.
   * 
   * @param relationship The Atk::RelationType of the relation.
   * @param target The Atk::Object which is to be the target of the relation.
   * @return <tt>true</tt> if the relationship is added.
   */
  bool add_relationship(Relation::Type relationship, const Glib::RefPtr<Object>& target);
  
  /** Removes a relationship of the specified type with the specified target.
   * 
   * @param relationship The Atk::RelationType of the relation.
   * @param target The Atk::Object which is the target of the relation to be removed.
   * @return <tt>true</tt> if the relationship is removed.
   */
  bool remove_relationship(Relation::Type relationship, const Glib::RefPtr<Object>& target);

  
  /** Gets a UTF-8 string indicating the POSIX-style LC_MESSAGES locale
   * of @a accessible.
   * 
   * @newin{2,8}
   * 
   * @return A UTF-8 string indicating the POSIX-style LC_MESSAGES
   * locale of @a accessible.
   */
  Glib::ustring get_object_locale() const;
  
  /** Gets the accessible id of the accessible.
   * 
   * @newin{2,34}
   * 
   * @return A character string representing the accessible id of the object, or
   * <tt>nullptr</tt> if no such string was set.
   */
  Glib::ustring get_accessible_id() const;
  
  /** Sets the accessible ID of the accessible.  This is not meant to be presented
   * to the user, but to be an ID which is stable over application development.
   * Typically, this is the gtkbuilder ID. Such an ID will be available for
   * instance to identify a given well-known accessible object for tailored screen
   * reading, or for automatic regression testing.
   * 
   * @newin{2,34}
   * 
   * @param name A character string to be set as the accessible id.
   */
  void set_accessible_id(const Glib::ustring& name);

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%children_changed(guint change_index, gpointer changed_child)</tt>
   *
   * Flags: Run Last
   *
   * The signal "children-changed" is emitted when a child is added or
   * removed form an object. It supports two details: "add" and
   * "remove"
   * 
   * @param change_index The index of the added or removed child. The value can be
   * -1. This is used if the value is not known by the implementor
   * when the child is added/removed or irrelevant.
   * @param changed_child A gpointer to the child AtkObject which was added or
   * removed. If the child was removed, it is possible that it is not
   * available for the implementor. In that case this pointer can be
   * <tt>nullptr</tt>.
   */

  Glib::SignalProxyDetailed<void(guint, gpointer)> signal_children_changed(const Glib::ustring& add_or_remove = {});


  // AtkObject::focus-event is deprecated in favor of state-change,
  // but deprecation of a signal probably means "don't emit" rather than
  // "don't listen", so let's keep it here.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%focus_event(bool focus_in)</tt>
   *
   * Flags: Run Last
   *
   * The signal "focus-event" is emitted when an object gained or lost
   * focus.
   * 
   * Deprecated: 2.9.4: Use the Atk::Object::signal_state_change() signal instead.
   * 
   * @param focus_in A boolean value which indicates whether the object gained
   * or lost focus.
   */

  Glib::SignalProxy<void(bool)> signal_focus_event();

  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%property_change(AtkPropertyValues* values)</tt>
   *
   * Flags: Run Last
   *
   * The signal "property-change" is emitted when an object's property
   * value changes. @a values contains an Atk::PropertyValues with the name
   * and the new value of the property whose value has changed. Note
   * that, as with GObject notify, getting this signal does not
   * guarantee that the value of the property has actually changed; it
   * may also be emitted when the setter of the property is called to
   * reinstate the previous value.
   * 
   * Toolkit implementor note: ATK implementors should use
   * Glib::object_notify() to emit property-changed
   * notifications. Atk::Object::signal_property_changed() is needed by the
   * implementation of atk_add_global_event_listener() because GObject
   * notify doesn't support emission hooks.
   * 
   * @param values An Atk::PropertyValues containing the new
   * value of the property which changed.
   */

  Glib::SignalProxyDetailed<void(AtkPropertyValues*)> signal_property_change(const Glib::ustring& property_name = {});


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%state_change(const Glib::ustring& name, bool state_set)</tt>
   *
   * Flags: Run Last
   *
   * The "state-change" signal is emitted when an object's state
   * changes.  The detail value identifies the state type which has
   * changed.
   * 
   * @param name The name of the state which has changed.
   * @param state_set A boolean which indicates whether the state has been set or unset.
   */

  Glib::SignalProxyDetailed<void(const Glib::ustring&, bool)> signal_state_change(const Glib::ustring& state_name = {});


  /**
   * @par Slot Prototype:
   * <tt>void on_my_%visible_data_changed()</tt>
   *
   * Flags: Run Last
   *
   * The "visible-data-changed" signal is emitted when the visual
   * appearance of the object changed.
   */

  Glib::SignalProxy<void()> signal_visible_data_changed();

  // AtkObject::active-descendant-changed supports a ::detail signal name, but it's
  // not clear what that detail means, and it's not used in gtk+.
  
  /**
   * @par Slot Prototype:
   * <tt>void on_my_%active_descendant_changed(void** child)</tt>
   *
   * Flags: Run Last
   *
   * The "active-descendant-changed" signal is emitted by an object
   * which has the state ATK_STATE_MANAGES_DESCENDANTS when the focus
   * object in the object changes. For instance, a table will emit the
   * signal when the cell in the table which has focus changes.
   * 
   * @param child The newly focused object.
   */

  Glib::SignalProxy<void(void**)> signal_active_descendant_changed();


  /** Object instance’s name formatted for assistive technology access.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_accessible_name() ;

/** Object instance’s name formatted for assistive technology access.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_accessible_name() const;

  /** Description of an object, formatted for assistive technology access.
   *
   * Default value: ""
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_accessible_description() ;

/** Description of an object, formatted for assistive technology access.
   *
   * Default value: ""
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_accessible_description() const;

  /** Parent of the current accessible as returned by Atk::Object::get_parent().
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Atk::Object> > property_accessible_parent() ;

/** Parent of the current accessible as returned by Atk::Object::get_parent().
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Atk::Object> > property_accessible_parent() const;

  /** The accessible role of this object.
   *
   * Default value: Atk::Role::UNKNOWN
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Role > property_accessible_role() ;

/** The accessible role of this object.
   *
   * Default value: Atk::Role::UNKNOWN
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Role > property_accessible_role() const;

  /** The accessible layer of this object.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_accessible_component_layer() const;


  /** The accessible MDI value of this object.
   *
   * Default value: -2147483648
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_accessible_component_mdi_zorder() const;


  /** Is used to notify that the table summary has changed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Atk::Object> > property_accessible_table_summary() ;

/** Is used to notify that the table summary has changed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Atk::Object> > property_accessible_table_summary() const;

  /** Is used to notify that the table caption has changed.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<Atk::Object> > property_accessible_table_caption_object() ;

/** Is used to notify that the table caption has changed.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Atk::Object> > property_accessible_table_caption_object() const;

  /** The number of links which the current AtkHypertext has.
   *
   * Default value: 0
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_accessible_hypertext_nlinks() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_children_changed().
  virtual void on_children_changed(guint change_index, gpointer changed_child);
  /// This is a default handler for the signal signal_focus_event().
  virtual void on_focus_event(bool focus_in);
  /// This is a default handler for the signal signal_property_change().
  virtual void on_property_change(AtkPropertyValues* values);
  /// This is a default handler for the signal signal_state_change().
  virtual void on_state_change(const Glib::ustring& name, bool state_set);
  /// This is a default handler for the signal signal_visible_data_changed().
  virtual void on_visible_data_changed();
  /// This is a default handler for the signal signal_active_descendant_changed().
  virtual void on_active_descendant_changed(void** child);


};

} // namespace Atk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Atk::Object
   */
  ATKMM_API
  Glib::RefPtr<Atk::Object> wrap(AtkObject* object, bool take_copy = false);
}


#endif /* _ATKMM_OBJECT_H */

