/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadReferrersTask;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadReferrersAction
extends JosmAction {
    public DownloadReferrersAction() {
        super(I18n.tr("Download parent ways/relations...", new Object[0]), "download", I18n.tr("Download objects referring to one of the selected objects", new Object[0]), Shortcut.registerShortcut("file:downloadreferrers", I18n.tr("File: {0}", I18n.tr("Download parent ways/relations...", new Object[0])), 68, 5008), true, "downloadreferrers", true);
        this.setHelpId(HelpUtil.ht("/Action/DownloadParentWaysAndRelation"));
    }

    public static void downloadReferrers(OsmDataLayer targetLayer, Collection<OsmPrimitive> children) {
        if (children == null || children.isEmpty()) {
            return;
        }
        MainApplication.worker.submit(new DownloadReferrersTask(targetLayer, children));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        OsmDataLayer layer = this.getLayerManager().getEditLayer();
        if (layer == null) {
            return;
        }
        Collection<OsmPrimitive> primitives = layer.data.getSelected();
        DownloadReferrersAction.downloadReferrers(layer, primitives);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
        if (this.isEnabled() && selection != null && !selection.isEmpty() && DownloadPolicy.BLOCKED.equals((Object)selection.iterator().next().getDataSet().getDownloadPolicy())) {
            this.setEnabled(false);
        }
    }
}

