/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.rest.jersey;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.client.core.spi.SubsystemProvider;

@Named
@Singleton
public class GuiceSubsystemProvider
implements SubsystemProvider {
    private final Injector injector;

    @Inject
    public GuiceSubsystemProvider(Injector injector) {
        this.injector = injector;
    }

    @Override
    public Object get(Class type, final Map<Object, Object> context) {
        Preconditions.checkNotNull((Object)type, (Object)"type cannot be null");
        Preconditions.checkNotNull(context, (Object)"context cannot be null");
        try {
            return this.injector.createChildInjector(new Module[]{new AbstractModule(){

                protected void configure() {
                    for (Map.Entry contextEntry : context.entrySet()) {
                        if (!(contextEntry.getKey() instanceof Class)) continue;
                        final Object contextValue = contextEntry.getValue();
                        if (contextValue instanceof Provider) {
                            this.bind((Class)contextEntry.getKey()).toProvider(new com.google.inject.Provider(){

                                public Object get() {
                                    return ((Provider)contextValue).get();
                                }
                            });
                            continue;
                        }
                        this.bind((Class)contextEntry.getKey()).toInstance(contextValue);
                    }
                }
            }}).getInstance(type);
        }
        catch (ConfigurationException configurationException) {
            return null;
        }
    }
}

