/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.core.subsystem.artifact;

import org.sonatype.nexus.client.internal.util.Check;

public class ResolveRequest {
    public static final String VERSION_LATEST = "LATEST";
    public static final String VERSION_RELEASE = "RELEASE";
    private final String repositoryId;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String packaging;
    private final String classifier;
    private final String extension;
    private final Boolean isLocal;

    public ResolveRequest(String repositoryId, String groupId, String artifactId, String version) {
        this(repositoryId, groupId, artifactId, version, null, null, null, null);
    }

    public ResolveRequest(String repositoryId, String groupId, String artifactId, String version, String packaging, String classifier, String extension, Boolean isLocal) {
        this.repositoryId = Check.notBlank(repositoryId, "repositoryId");
        this.groupId = Check.notBlank(groupId, "groupId");
        this.artifactId = Check.notBlank(artifactId, "artifactId");
        this.version = Check.notBlank(version, "version");
        this.packaging = packaging;
        this.classifier = classifier;
        this.extension = extension;
        this.isLocal = isLocal;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getExtension() {
        return this.extension;
    }

    public Boolean getIsLocal() {
        return this.isLocal;
    }
}

