/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.hash;

import java.util.Arrays;
import org.sonatype.spice.zapper.hash.HashAlgorithmIdentifier;
import org.sonatype.spice.zapper.hash.HashUtils;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.StringIdentifier;

public class Hash
extends StringIdentifier {
    private final HashAlgorithmIdentifier algorithm;
    private final byte[] hash;

    public Hash(HashAlgorithmIdentifier algorithm, byte[] hash) {
        super(HashUtils.encodeHexString(Check.notNull(hash, "Hash byte array is null!")));
        this.algorithm = Check.notNull(algorithm, "Algorithm is null!");
        this.hash = Check.argument(hash.length == algorithm.getHashSize(), hash, "Hash array contains wrong count of bytes!");
    }

    public HashAlgorithmIdentifier getHashAlgorithmIdentifier() {
        return this.algorithm;
    }

    public byte[] byteValue() {
        return org.sonatype.spice.zapper.internal.Arrays.copyOf(this.hash, this.hash.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.algorithm.hashCode();
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hash other = (Hash)obj;
        if (!this.getHashAlgorithmIdentifier().equals(other.getHashAlgorithmIdentifier())) {
            return false;
        }
        return Arrays.equals(this.byteValue(), other.byteValue());
    }

    public String toString() {
        return "Hash [algorithm=" + this.algorithm + ", hash=" + this.stringValue() + "]";
    }
}

