/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging.workflow;

import com.sonatype.nexus.staging.client.StagingRuleFailures;
import com.sonatype.nexus.staging.client.StagingRuleFailuresException;
import com.sonatype.nexus.staging.client.StagingWorkflowV2Service;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.sonatype.nexus.maven.staging.ErrorDumper;
import org.sonatype.nexus.maven.staging.StagingAction;
import org.sonatype.nexus.maven.staging.workflow.AbstractStagingBuildActionMojo;

@Mojo(name="close", requiresOnline=true)
public class CloseStageRepositoryMojo
extends AbstractStagingBuildActionMojo {
    @Override
    public void doExecute(StagingWorkflowV2Service stagingWorkflow) throws MojoExecutionException, MojoFailureException {
        String[] stagingRepositoryIds = this.getStagingRepositoryIds();
        try {
            this.getLog().info((CharSequence)("Closing staging repository with IDs=" + Arrays.toString(this.getStagingRepositoryIds())));
            stagingWorkflow.finishStagingRepositories(this.getDescriptionWithDefaultsForAction(StagingAction.FINISH), stagingRepositoryIds);
            this.getLog().info((CharSequence)"Closed");
        }
        catch (StagingRuleFailuresException e) {
            ErrorDumper.dumpErrors(this.getLog(), e);
            if (!this.isKeepStagingRepositoryOnCloseRuleFailure()) {
                ArrayList<String> failedRepositories = new ArrayList<String>();
                for (StagingRuleFailures failures : e.getFailures()) {
                    failedRepositories.add(failures.getRepositoryId());
                }
                String msg = "Rule failure during close of staging repositories: " + failedRepositories;
                this.getLog().error((CharSequence)("Cleaning up remote stage repositories after a " + msg));
                stagingWorkflow.dropStagingRepositories(this.getDescriptionWithDefaultsForAction(StagingAction.DROP) + " (" + msg + ").", stagingRepositoryIds);
            }
            throw new MojoExecutionException("Could not perform action: there are failing staging rules!", (Exception)((Object)e));
        }
    }
}

