/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.invoker;

import java.io.File;
import java.io.InputStream;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationResult;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutHandler;
import org.apache.maven.shared.invoker.SystemOutLogger;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class DefaultInvoker
implements Invoker {
    public static final String ROLE_HINT = "default";
    private static final InvokerLogger DEFAULT_LOGGER = new SystemOutLogger();
    private static final InvocationOutputHandler DEFAULT_OUTPUT_HANDLER = new SystemOutHandler();
    private File localRepositoryDirectory;
    private InvokerLogger logger = DEFAULT_LOGGER;
    private File workingDirectory;
    private File mavenHome;
    private InvocationOutputHandler outputHandler = DEFAULT_OUTPUT_HANDLER;
    private InputStream inputStream;
    private InvocationOutputHandler errorHandler = DEFAULT_OUTPUT_HANDLER;

    public InvocationResult execute(InvocationRequest request) throws MavenInvocationException {
        Commandline cli;
        File workingDirectory;
        File mavenHome;
        File localRepo;
        MavenCommandLineBuilder cliBuilder = new MavenCommandLineBuilder();
        InvokerLogger logger = this.getLogger();
        if (logger != null) {
            cliBuilder.setLogger(this.getLogger());
        }
        if ((localRepo = this.getLocalRepositoryDirectory()) != null) {
            cliBuilder.setLocalRepositoryDirectory(this.getLocalRepositoryDirectory());
        }
        if ((mavenHome = this.getMavenHome()) != null) {
            cliBuilder.setMavenHome(this.getMavenHome());
        }
        if ((workingDirectory = this.getWorkingDirectory()) != null) {
            cliBuilder.setWorkingDirectory(this.getWorkingDirectory());
        }
        try {
            cli = cliBuilder.build(request);
        }
        catch (CommandLineConfigurationException e) {
            throw new MavenInvocationException("Error configuring command-line. Reason: " + e.getMessage(), e);
        }
        DefaultInvocationResult result = new DefaultInvocationResult();
        try {
            int exitCode = this.executeCommandLine(cli, request);
            result.setExitCode(exitCode);
        }
        catch (CommandLineException e) {
            result.setExecutionException(e);
        }
        return result;
    }

    private int executeCommandLine(Commandline cli, InvocationRequest request) throws CommandLineException {
        int result = Integer.MIN_VALUE;
        InputStream inputStream = request.getInputStream(this.inputStream);
        InvocationOutputHandler outputHandler = request.getOutputHandler(this.outputHandler);
        InvocationOutputHandler errorHandler = request.getErrorHandler(this.errorHandler);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cli);
        }
        if (request.isInteractive()) {
            if (inputStream == null) {
                this.getLogger().warn("Maven will be executed in interactive mode, but no input stream has been configured for this MavenInvoker instance.");
                result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)outputHandler, (StreamConsumer)errorHandler);
            } else {
                result = CommandLineUtils.executeCommandLine((Commandline)cli, (InputStream)inputStream, (StreamConsumer)outputHandler, (StreamConsumer)errorHandler);
            }
        } else {
            if (inputStream != null) {
                this.getLogger().info("Executing in batch mode. The configured input stream will be ignored.");
            }
            result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)outputHandler, (StreamConsumer)errorHandler);
        }
        return result;
    }

    public File getLocalRepositoryDirectory() {
        return this.localRepositoryDirectory;
    }

    public InvokerLogger getLogger() {
        return this.logger;
    }

    public Invoker setLocalRepositoryDirectory(File localRepositoryDirectory) {
        this.localRepositoryDirectory = localRepositoryDirectory;
        return this;
    }

    public Invoker setLogger(InvokerLogger logger) {
        this.logger = logger != null ? logger : DEFAULT_LOGGER;
        return this;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Invoker setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public File getMavenHome() {
        return this.mavenHome;
    }

    public Invoker setMavenHome(File mavenHome) {
        this.mavenHome = mavenHome;
        return this;
    }

    public Invoker setErrorHandler(InvocationOutputHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this;
    }

    public Invoker setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public Invoker setOutputHandler(InvocationOutputHandler outputHandler) {
        this.outputHandler = outputHandler;
        return this;
    }
}

