/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.zip.CRC32;
import org.codehaus.plexus.archiver.AbstractArchiver;
import org.codehaus.plexus.archiver.ArchiveEntry;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.util.ResourceUtils;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;
import org.codehaus.plexus.components.io.resources.PlexusIoFileResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractZipArchiver
extends AbstractArchiver {
    private String comment;
    private String encoding;
    private boolean doCompress = true;
    private boolean recompressAddedZips = true;
    private boolean doUpdate = false;
    private boolean savedDoUpdate = false;
    protected String archiveType = "zip";
    private boolean doFilesonly = false;
    protected Hashtable<String, String> entries = new Hashtable();
    protected Hashtable<String, String> addedDirs = new Hashtable();
    private static final long EMPTY_CRC = new CRC32().getValue();
    protected boolean doubleFilePass = false;
    protected boolean skipWriting = false;
    protected String duplicate = "skip";
    protected boolean addingNewFiles = false;
    private boolean roundUp = true;
    private File renamedFile = null;
    private File zipFile;
    private boolean success;
    private ZipOutputStream zOut;

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public boolean isCompress() {
        return this.doCompress;
    }

    public boolean isRecompressAddedZips() {
        return this.recompressAddedZips;
    }

    public void setRecompressAddedZips(boolean recompressAddedZips) {
        this.recompressAddedZips = recompressAddedZips;
    }

    public void setUpdateMode(boolean update) {
        this.savedDoUpdate = this.doUpdate = update;
    }

    public boolean isInUpdateMode() {
        return this.doUpdate;
    }

    public void setFilesonly(boolean f) {
        this.doFilesonly = f;
    }

    public boolean isFilesonly() {
        return this.doFilesonly;
    }

    public void setRoundUp(boolean r) {
        this.roundUp = r;
    }

    public boolean isRoundUp() {
        return this.roundUp;
    }

    @Override
    protected void execute() throws ArchiverException, IOException {
        if (!this.checkForced()) {
            return;
        }
        if (this.doubleFilePass) {
            this.skipWriting = true;
            this.createArchiveMain();
            this.skipWriting = false;
            this.createArchiveMain();
        } else {
            this.createArchiveMain();
        }
        this.finalizeZipOutputStream(this.zOut);
    }

    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
    }

    private void createArchiveMain() throws ArchiverException, IOException {
        ResourceIterator iter;
        if (!"skip".equals(this.duplicate)) {
            this.setDuplicateBehavior(this.duplicate);
        }
        if (!(iter = this.getResources()).hasNext() && !this.hasVirtualFiles()) {
            throw new ArchiverException("You must set at least one file.");
        }
        this.zipFile = this.getDestFile();
        if (this.zipFile == null) {
            throw new ArchiverException("You must set the destination " + this.archiveType + "file.");
        }
        if (this.zipFile.exists() && !this.zipFile.isFile()) {
            throw new ArchiverException(this.zipFile + " isn't a file.");
        }
        if (this.zipFile.exists() && !this.zipFile.canWrite()) {
            throw new ArchiverException(this.zipFile + " is read-only.");
        }
        this.addingNewFiles = true;
        if (this.doUpdate && !this.zipFile.exists()) {
            this.doUpdate = false;
            this.getLogger().debug("ignoring update attribute as " + this.archiveType + " doesn't exist.");
        }
        this.success = false;
        if (this.doUpdate) {
            this.renamedFile = FileUtils.createTempFile((String)"zip", (String)".tmp", (File)this.zipFile.getParentFile());
            this.renamedFile.deleteOnExit();
            try {
                FileUtils.rename((File)this.zipFile, (File)this.renamedFile);
            }
            catch (SecurityException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Not allowed to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
            catch (IOException e) {
                this.getLogger().debug(e.toString());
                throw new ArchiverException("Unable to rename old file (" + this.zipFile.getAbsolutePath() + ") to temporary file", e);
            }
        }
        String action = this.doUpdate ? "Updating " : "Building ";
        this.getLogger().info(action + this.archiveType + ": " + this.zipFile.getAbsolutePath());
        if (!this.skipWriting) {
            this.zOut = new ZipOutputStream(this.zipFile);
            this.zOut.setEncoding(this.encoding);
            if (this.doCompress) {
                this.zOut.setMethod(8);
            } else {
                this.zOut.setMethod(0);
            }
        }
        this.initZipOutputStream(this.zOut);
        this.addResources(iter, this.zOut);
        if (this.doUpdate && !this.renamedFile.delete()) {
            this.getLogger().warn("Warning: unable to delete temporary file " + this.renamedFile.getName());
        }
        this.success = true;
    }

    protected Map<String, Long> getZipEntryNames(File file) throws IOException {
        if (!file.exists() || !this.doUpdate) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Long> entries = new HashMap<String, Long>();
        ZipFile zipFile = new ZipFile(file);
        Enumeration<ZipEntry> en = zipFile.getEntries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            entries.put(ze.getName(), ze.getLastModificationTime());
        }
        return entries;
    }

    protected boolean isFileAdded(ArchiveEntry entry, Map entries) {
        return !entries.containsKey(entry.getName());
    }

    protected boolean isFileUpdated(ArchiveEntry entry, Map entries) {
        Long l = (Long)entries.get(entry.getName());
        return l != null && (l == -1L || !ResourceUtils.isUptodate(entry.getResource(), (long)l));
    }

    protected final void addResources(ResourceIterator resources, ZipOutputStream zOut) throws IOException, ArchiverException {
        File base = null;
        while (resources.hasNext()) {
            ArchiveEntry entry = resources.next();
            String name = entry.getName();
            if ("".equals(name = name.replace(File.separatorChar, '/'))) continue;
            if (entry.getResource().isDirectory() && !name.endsWith("/")) {
                name = name + "/";
            }
            this.addParentDirs(base, name, zOut, "");
            if (entry.getResource().isFile()) {
                this.zipFile(entry, zOut, name);
                continue;
            }
            this.zipDir(entry.getResource(), zOut, name, entry.getMode());
        }
    }

    protected final void addParentDirs(File baseDir, String entry, ZipOutputStream zOut, String prefix) throws IOException {
        if (!this.doFilesonly && this.getIncludeEmptyDirs()) {
            String dir;
            Stack<String> directories = new Stack<String>();
            int slashPos = entry.length() - (entry.endsWith("/") ? 1 : 0);
            while ((slashPos = entry.lastIndexOf(47, slashPos - 1)) != -1) {
                dir = entry.substring(0, slashPos + 1);
                if (this.addedDirs.contains(prefix + dir)) break;
                directories.push(dir);
            }
            while (!directories.isEmpty()) {
                dir = (String)directories.pop();
                File f = baseDir != null ? new File(baseDir, dir) : new File(dir);
                PlexusIoFileResource res = new PlexusIoFileResource(f);
                this.zipDir((PlexusIoResource)res, zOut, prefix + dir, this.getRawDefaultDirectoryMode());
            }
        }
    }

    private void readWithZipStats(InputStream in, byte[] header, ZipEntry ze, ByteArrayOutputStream bos) throws IOException {
        byte[] buffer = new byte[8192];
        CRC32 cal2 = new CRC32();
        long size = 0L;
        for (byte aHeader : header) {
            cal2.update(aHeader);
            ++size;
        }
        int count = 0;
        do {
            size += (long)count;
            cal2.update(buffer, 0, count);
            if (bos == null) continue;
            bos.write(buffer, 0, count);
        } while ((count = in.read(buffer, 0, buffer.length)) != -1);
        ze.setSize(size);
        ze.setCrc(cal2.getValue());
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int n;
        byte[] buffer = new byte[bufferSize];
        long size = 0L;
        while (-1 != (n = input.read(buffer))) {
            size += (long)n;
            output.write(buffer, 0, n);
        }
        return size;
    }

    protected void zipFile(InputStream in, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException, ArchiverException {
        this.getLogger().debug("adding entry " + vPath);
        this.entries.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            ze.setTime(lastModified);
            byte[] header = new byte[4];
            int read = in.read(header);
            boolean compressThis = this.doCompress;
            if (!this.recompressAddedZips && this.isZipHeader(header)) {
                compressThis = false;
            }
            ze.setMethod(compressThis ? 8 : 0);
            ze.setUnixMode(0x8000 | mode);
            if (zOut.isSeekable() || compressThis) {
                zOut.putNextEntry(ze);
                if (read > 0) {
                    zOut.write(header, 0, read);
                }
                IOUtil.copy((InputStream)in, (OutputStream)zOut, (int)8192);
            } else if (in.markSupported()) {
                in.mark(Integer.MAX_VALUE);
                this.readWithZipStats(in, header, ze, null);
                in.reset();
                zOut.putNextEntry(ze);
                if (read > 0) {
                    zOut.write(header, 0, read);
                }
                IOUtil.copy((InputStream)in, (OutputStream)zOut, (int)8192);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(131072);
                this.readWithZipStats(in, header, ze, bos);
                zOut.putNextEntry(ze);
                if (read > 0) {
                    zOut.write(header, 0, read);
                }
                bos.writeTo(zOut);
            }
        }
    }

    private boolean isZipHeader(byte[] header) {
        return header[0] == 80 && header[1] == 75 && header[2] == 3 && header[3] == 4;
    }

    protected void zipFile(ArchiveEntry entry, ZipOutputStream zOut, String vPath) throws IOException, ArchiverException {
        if (ResourceUtils.isSame(entry.getResource(), this.getDestFile())) {
            throw new ArchiverException("A zip file cannot include itself");
        }
        InputStream in = entry.getInputStream();
        try {
            long lastModified = entry.getResource().getLastModified() + (long)(this.roundUp ? 1999 : 0);
            this.zipFile(in, zOut, vPath, lastModified, null, entry.getMode());
        }
        catch (IOException e) {
            throw new ArchiverException("IOException when zipping " + entry.getName() + ": " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((InputStream)in);
        }
    }

    protected void zipDir(PlexusIoResource dir, ZipOutputStream zOut, String vPath, int mode) throws IOException {
        if (this.addedDirs.get(vPath) != null) {
            return;
        }
        this.getLogger().debug("adding directory " + vPath);
        this.addedDirs.put(vPath, vPath);
        if (!this.skipWriting) {
            ZipEntry ze = new ZipEntry(vPath);
            if (dir != null && dir.isExisting()) {
                long lastModified = dir.getLastModified() + (long)(this.roundUp ? 1999 : 0);
                ze.setTime(lastModified);
            } else {
                ze.setTime(System.currentTimeMillis() + (long)(this.roundUp ? 1999 : 0));
            }
            ze.setSize(0L);
            ze.setMethod(0);
            ze.setCrc(EMPTY_CRC);
            ze.setUnixMode(mode);
            zOut.putNextEntry(ze);
        }
    }

    protected boolean createEmptyZip(File zipFile) throws ArchiverException {
        this.getLogger().info("Note: creating empty " + this.archiveType + " archive " + zipFile);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(zipFile);
            byte[] empty = new byte[22];
            empty[0] = 80;
            empty[1] = 75;
            empty[2] = 5;
            empty[3] = 6;
            ((OutputStream)os).write(empty);
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Could not create empty ZIP archive (" + ioe.getMessage() + ")", ioe);
            }
            catch (Throwable throwable) {
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)os);
        return true;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this.addedDirs.clear();
        this.entries.clear();
        this.addingNewFiles = false;
        this.doUpdate = this.savedDoUpdate;
        this.success = false;
        this.zOut = null;
        this.renamedFile = null;
        this.zipFile = null;
    }

    public void reset() {
        this.setDestFile(null);
        this.archiveType = "zip";
        this.doCompress = true;
        this.doUpdate = false;
        this.doFilesonly = false;
        this.encoding = null;
    }

    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
    }

    @Override
    public boolean isSupportingForced() {
        return true;
    }

    @Override
    protected boolean revert(StringBuffer messageBuffer) {
        int initLength = messageBuffer.length();
        if (!(this.doUpdate && this.renamedFile == null || this.zipFile.delete())) {
            messageBuffer.append(" (and the archive is probably corrupt but I could not delete it)");
        }
        if (this.doUpdate && this.renamedFile != null) {
            try {
                FileUtils.rename((File)this.renamedFile, (File)this.zipFile);
            }
            catch (IOException e) {
                messageBuffer.append(" (and I couldn't rename the temporary file ");
                messageBuffer.append(this.renamedFile.getName());
                messageBuffer.append(" back)");
            }
        }
        return messageBuffer.length() == initLength;
    }

    @Override
    protected void close() throws IOException {
        block3: {
            try {
                if (this.zOut != null) {
                    this.zOut.close();
                }
            }
            catch (IOException ex) {
                if (!this.success) break block3;
                throw ex;
            }
        }
    }

    @Override
    protected String getArchiveType() {
        return this.archiveType;
    }
}

