/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.repository.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;

public final class DigestUtils {
    private static final int CHECKSUM_BUFFER_SIZE = 16384;
    private static final int BYTE_MASK = 255;

    private DigestUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createChecksum(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        FileInputStream fis = new FileInputStream(file);
        try {
            int numRead;
            byte[] buffer = new byte[16384];
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                digest.update(buffer, 0, numRead);
            } while (numRead != -1);
        }
        finally {
            IOUtil.close((InputStream)fis);
        }
        return DigestUtils.byteArrayToHexStr(digest.digest());
    }

    public boolean verifyChecksum(File file, String checksum, String algorithm) throws NoSuchAlgorithmException, IOException {
        String filename;
        boolean result = true;
        String trimmedChecksum = checksum.replace('\n', ' ').trim();
        Matcher m = Pattern.compile(algorithm.replaceAll("-", "") + "\\s*\\((.*?)\\)\\s*=\\s*([a-zA-Z0-9]+)").matcher(trimmedChecksum);
        if (m.matches()) {
            filename = m.group(1);
            if (!filename.equals(file.getName())) {
                result = false;
            }
            trimmedChecksum = m.group(2);
        } else {
            m = Pattern.compile("([a-zA-Z0-9]+)\\s\\*?(.+)").matcher(trimmedChecksum);
            if (m.matches()) {
                filename = m.group(2);
                if (!filename.equals(file.getName())) {
                    result = false;
                }
                trimmedChecksum = m.group(1);
            }
        }
        if (result) {
            String sum = DigestUtils.createChecksum(file, algorithm);
            result = trimmedChecksum.toUpperCase().equals(sum.toUpperCase());
        }
        return result;
    }

    private static String byteArrayToHexStr(byte[] data) {
        String output = "";
        for (int cnt = 0; cnt < data.length; ++cnt) {
            int tempInt = data[cnt] & 0xFF;
            String tempStr = Integer.toHexString(tempInt);
            if (tempStr.length() == 1) {
                tempStr = "0" + tempStr;
            }
            output = output + tempStr;
        }
        return output.toUpperCase();
    }
}

