/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.util.internal.StringUtils;

public class RunStatistics {
    private final Sources errorSources = new Sources();
    private final Sources failureSources = new Sources();
    private int completedCount;
    private int errors;
    private int failures;
    private int skipped;

    public void addErrorSource(String errorSource, StackTraceWriter stackTraceWriter) {
        this.errorSources.addSource(errorSource, stackTraceWriter);
    }

    public void addFailureSource(String failureSource, StackTraceWriter stackTraceWriter) {
        this.failureSources.addSource(failureSource, stackTraceWriter);
    }

    public Collection getErrorSources() {
        return this.errorSources.getListOfSources();
    }

    public Collection getFailureSources() {
        return this.failureSources.getListOfSources();
    }

    public synchronized boolean hadFailures() {
        return this.failures > 0;
    }

    public synchronized boolean hadErrors() {
        return this.errors > 0;
    }

    public synchronized int getCompletedCount() {
        return this.completedCount;
    }

    public synchronized int getSkipped() {
        return this.skipped;
    }

    public synchronized void add(TestSetStats testSetStats) {
        this.completedCount += testSetStats.getCompletedCount();
        this.errors += testSetStats.getErrors();
        this.failures += testSetStats.getFailures();
        this.skipped += testSetStats.getSkipped();
    }

    public synchronized RunResult getRunResult() {
        return new RunResult(this.completedCount, this.errors, this.failures, this.skipped);
    }

    public synchronized String getSummary() {
        return "Tests run: " + this.completedCount + ", Failures: " + this.failures + ", Errors: " + this.errors + ", Skipped: " + this.skipped;
    }

    private static class Sources {
        private final Collection<String> listOfSources = new ArrayList<String>();

        private Sources() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSource(String source) {
            Collection<String> collection = this.listOfSources;
            synchronized (collection) {
                this.listOfSources.add(source);
            }
        }

        void addSource(String source, StackTraceWriter stackTraceWriter) {
            String message = this.getMessageOfThrowable(stackTraceWriter);
            String extendedSource = StringUtils.isBlank((String)message) ? source : source + ": " + this.trimToSingleLine(message);
            this.addSource(extendedSource);
        }

        private String trimToSingleLine(String str) {
            int i = str.indexOf("\n");
            return i >= 0 ? str.substring(0, i) + "(..)" : str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Collection getListOfSources() {
            Collection<String> collection = this.listOfSources;
            synchronized (collection) {
                return Collections.unmodifiableCollection(this.listOfSources);
            }
        }

        private String getMessageOfThrowable(StackTraceWriter stackTraceWriter) {
            return stackTraceWriter != null ? this.getMessageOfThrowable(stackTraceWriter.getThrowable()) : "";
        }

        private String getMessageOfThrowable(SafeThrowable throwable) {
            return throwable != null ? throwable.getLocalizedMessage() : "";
        }
    }
}

